/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.standalone.broker.provider;

import com.lmax.disruptor.EventTranslatorOneArg;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import lombok.Generated;
import org.apache.eventmesh.api.LifeCycle;
import org.apache.eventmesh.storage.standalone.broker.model.MessageEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisruptorProvider
implements LifeCycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DisruptorProvider.class);
    private final RingBuffer<MessageEntity> ringBuffer;
    private final Disruptor<MessageEntity> disruptor;
    private volatile boolean start = false;
    private final EventTranslatorOneArg<MessageEntity, MessageEntity> translatorOneArg = (messageEntity, sequence, arg0) -> {
        arg0.setOffset(sequence);
        arg0.setCreateTimeMills(System.currentTimeMillis());
        messageEntity.setOffset(arg0.getOffset());
        messageEntity.setCreateTimeMills(arg0.getCreateTimeMills());
        messageEntity.setTopicMetadata(arg0.getTopicMetadata());
        messageEntity.setMessage(arg0.getMessage());
    };

    public DisruptorProvider(RingBuffer<MessageEntity> ringBuffer, Disruptor<MessageEntity> disruptor) {
        this.ringBuffer = ringBuffer;
        this.disruptor = disruptor;
    }

    public MessageEntity onData(MessageEntity data) {
        if (this.isClosed()) {
            throw new IllegalArgumentException("the disruptor is close");
        }
        try {
            this.ringBuffer.publishEvent(this.translatorOneArg, (Object)data);
        }
        catch (Exception ex) {
            throw new IllegalStateException("send data fail.");
        }
        return data;
    }

    public boolean isStarted() {
        return this.start;
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public void start() {
        if (null != this.disruptor) {
            this.disruptor.start();
            this.start = true;
        }
    }

    public void shutdown() {
        if (null != this.disruptor) {
            this.disruptor.shutdown();
            this.start = false;
        }
    }

    public int getMessageCount() {
        return this.ringBuffer.getBufferSize();
    }
}

