/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.chatgpt.source.managers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.theokanning.openai.client.OpenAiApi;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.service.OpenAiService;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.util.List;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.apache.eventmesh.common.utils.AssertUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.connector.chatgpt.source.config.ChatGPTSourceConfig;
import org.apache.eventmesh.connector.chatgpt.source.config.OpenaiConfig;
import org.apache.eventmesh.connector.chatgpt.source.config.OpenaiProxyConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Retrofit;

public class OpenaiManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenaiManager.class);
    private OpenAiService openAiService;
    private String chatCompletionRequestTemplateStr;
    private static final int DEFAULT_TIMEOUT = 0;

    public OpenaiManager(ChatGPTSourceConfig sourceConfig) {
        this.initOpenAi(sourceConfig);
    }

    public String getResult(ChatCompletionRequest req) {
        StringBuilder gptData = new StringBuilder();
        try {
            this.openAiService.createChatCompletion(req).getChoices().forEach(chatCompletionChoice -> gptData.append(chatCompletionChoice.getMessage().getContent()));
        }
        catch (Exception e) {
            log.error("Failed to generate GPT connection record: {}", (Object)e.getMessage());
        }
        return gptData.toString();
    }

    public ChatCompletionRequest newChatCompletionRequest(List<ChatMessage> chatMessages) {
        ChatCompletionRequest request = (ChatCompletionRequest)JsonUtils.parseObject((String)this.chatCompletionRequestTemplateStr, ChatCompletionRequest.class);
        request.setMessages(chatMessages);
        return request;
    }

    private void initOpenAi(ChatGPTSourceConfig sourceConfig) {
        boolean proxyEnable;
        OpenaiConfig openaiConfig = sourceConfig.getOpenaiConfig();
        if (openaiConfig.getTimeout() < 0L) {
            log.warn("openaiTimeout must be >= 0, your config value is {}, openaiTimeout will be reset {}", (Object)openaiConfig.getTimeout(), (Object)0);
            openaiConfig.setTimeout(0L);
        }
        if (proxyEnable = sourceConfig.connectorConfig.isProxyEnable()) {
            OpenaiProxyConfig chatgptProxyConfig = sourceConfig.openaiProxyConfig;
            if (chatgptProxyConfig.getHost() == null) {
                throw new IllegalStateException("chatgpt proxy config 'host' cannot be null");
            }
            ObjectMapper mapper = OpenAiService.defaultObjectMapper();
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(chatgptProxyConfig.getHost(), chatgptProxyConfig.getPort()));
            OkHttpClient client = OpenAiService.defaultClient((String)openaiConfig.getToken(), (Duration)Duration.ofSeconds(openaiConfig.getTimeout())).newBuilder().proxy(proxy).build();
            Retrofit retrofit = OpenAiService.defaultRetrofit((OkHttpClient)client, (ObjectMapper)mapper);
            OpenAiApi api = (OpenAiApi)retrofit.create(OpenAiApi.class);
            this.openAiService = new OpenAiService(api);
        } else {
            this.openAiService = new OpenAiService(openaiConfig.getToken(), Duration.ofSeconds(openaiConfig.getTimeout()));
        }
        ChatCompletionRequest.ChatCompletionRequestBuilder builder = ChatCompletionRequest.builder().model(openaiConfig.getModel());
        AssertUtils.notNull((Object)openaiConfig.getModel(), (String)"model cannot be null");
        builder = builder.model(openaiConfig.getModel());
        if (openaiConfig.getUser() != null) {
            builder = builder.user(openaiConfig.getUser());
        }
        if (openaiConfig.getPresencePenalty() != null) {
            builder = builder.presencePenalty(openaiConfig.getPresencePenalty());
        }
        if (openaiConfig.getFrequencyPenalty() != null) {
            builder = builder.frequencyPenalty(openaiConfig.getFrequencyPenalty());
        }
        if (openaiConfig.getMaxTokens() != null) {
            builder = builder.maxTokens(openaiConfig.getMaxTokens());
        }
        if (openaiConfig.getTemperature() != null) {
            builder = builder.temperature(openaiConfig.getTemperature());
        }
        if (openaiConfig.getLogitBias() != null && !openaiConfig.getLogitBias().isEmpty()) {
            builder = builder.logitBias(openaiConfig.getLogitBias());
        }
        if (openaiConfig.getStop() != null && !openaiConfig.getStop().isEmpty()) {
            builder = builder.stop(openaiConfig.getStop());
        }
        this.chatCompletionRequestTemplateStr = JsonUtils.toJSONString((Object)builder.build());
    }

    @Generated
    public OpenAiService getOpenAiService() {
        return this.openAiService;
    }
}

