/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.packagescan.resource;

import com.alibaba.nacos.common.packagescan.resource.AbstractResource;
import com.alibaba.nacos.common.packagescan.resource.Resource;
import com.alibaba.nacos.common.packagescan.resource.VfsUtils;
import com.alibaba.nacos.common.packagescan.util.AbstractAssert;
import com.alibaba.nacos.common.packagescan.util.NestedIoException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class VfsResource
extends AbstractResource {
    private final Object resource;

    public VfsResource(Object resource) {
        AbstractAssert.notNull(resource, "VirtualFile must not be null");
        this.resource = resource;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return VfsUtils.getInputStream(this.resource);
    }

    @Override
    public boolean exists() {
        return VfsUtils.exists(this.resource);
    }

    @Override
    public boolean isReadable() {
        return VfsUtils.isReadable(this.resource);
    }

    @Override
    public URL getUrl() throws IOException {
        try {
            return VfsUtils.getUrl(this.resource);
        }
        catch (Exception ex) {
            throw new NestedIoException("Failed to obtain URL for file " + this.resource, ex);
        }
    }

    @Override
    public URI getUri() throws IOException {
        try {
            return VfsUtils.getUri(this.resource);
        }
        catch (Exception ex) {
            throw new NestedIoException("Failed to obtain URI for " + this.resource, ex);
        }
    }

    @Override
    public File getFile() throws IOException {
        return VfsUtils.getFile(this.resource);
    }

    @Override
    public long contentLength() throws IOException {
        return VfsUtils.getSize(this.resource);
    }

    @Override
    public long lastModified() throws IOException {
        return VfsUtils.getLastModified(this.resource);
    }

    @Override
    public Resource createRelative(String relativePath) throws IOException {
        if (!relativePath.startsWith(".") && relativePath.contains("/")) {
            try {
                return new VfsResource(VfsUtils.getChild(this.resource, relativePath));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new VfsResource(VfsUtils.getRelative(new URL(this.getUrl(), relativePath)));
    }

    @Override
    public String getFilename() {
        return VfsUtils.getName(this.resource);
    }

    @Override
    public String getDescription() {
        return "VFS resource [" + this.resource + "]";
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof VfsResource && this.resource.equals(((VfsResource)other).resource);
    }

    @Override
    public int hashCode() {
        return this.resource.hashCode();
    }
}

