/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.connection.impl;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;

public class Flow {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(0);
    private final int flowId;
    @GuardedBy(value="$lock")
    private int requestSequenceNumber = 0;

    @VisibleForTesting
    public Flow(int flowId, int requestSequenceNumber) {
        this.flowId = flowId;
        this.requestSequenceNumber = requestSequenceNumber;
    }

    public static Flow create() {
        return new Flow(ID_GENERATOR.updateAndGet(i -> i == Integer.MAX_VALUE ? 1 : i + 1), 0);
    }

    public static Flow from(long flowAsLong) {
        return new Flow((int)(flowAsLong >> 32), (int)flowAsLong);
    }

    public static int toFlowID(long requestID) {
        return (int)(requestID >> 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long asLong() {
        Object object = this.$lock;
        synchronized (object) {
            return (long)this.flowId << 32 | (long)this.requestSequenceNumber & 0xFFFFFFFL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextSequenceNumber() {
        Object object = this.$lock;
        synchronized (object) {
            this.requestSequenceNumber = this.requestSequenceNumber == Integer.MAX_VALUE ? 0 : ++this.requestSequenceNumber;
            return this.asLong();
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Flow(flowId=" + this.getFlowId() + ", requestSequenceNumber=" + this.requestSequenceNumber + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flow)) {
            return false;
        }
        Flow other = (Flow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFlowId() != other.getFlowId()) {
            return false;
        }
        return this.requestSequenceNumber == other.requestSequenceNumber;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Flow;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFlowId();
        result = result * 59 + this.requestSequenceNumber;
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getFlowId() {
        return this.flowId;
    }
}

