/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.connector.core.spi;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class URLClassExtensionLoader
extends URLClassLoader {
    public URLClassExtensionLoader(URL[] urls) {
        super(urls);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (name.startsWith("java.") || name.startsWith("org.slf4j.") || name.startsWith("org.apache.logging") || name.startsWith("org.apache.zookeeper.") || name.startsWith("org.I0Itec.zkclient.") || name.startsWith("org.apache.commons.logging.")) {
            c = super.loadClass(name);
        }
        if (c != null) {
            return c;
        }
        try {
            c = this.findClass(name);
        }
        catch (ClassNotFoundException e) {
            c = null;
        }
        if (c != null) {
            return c;
        }
        return super.loadClass(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[2];
        tmp[0] = this.findResources(name);
        return new CompoundEnumeration<URL>(tmp);
    }

    private static class CompoundEnumeration<E>
    implements Enumeration<E> {
        private Enumeration<E>[] enums;
        private int index = 0;

        public CompoundEnumeration(Enumeration<E>[] enums) {
            this.enums = enums;
        }

        private boolean next() {
            while (this.index < this.enums.length) {
                if (this.enums[this.index] != null && this.enums[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public E nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            return this.enums[this.index].nextElement();
        }
    }
}

