/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.api;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedProtocolPluginFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnhancedProtocolPluginFactory.class);
    private static final Map<String, ProtocolAdaptor<ProtocolTransportObject>> PROTOCOL_ADAPTOR_MAP = new ConcurrentHashMap<String, ProtocolAdaptor<ProtocolTransportObject>>(32);
    private static final Map<String, ProtocolMetadata> PROTOCOL_METADATA_MAP = new ConcurrentHashMap<String, ProtocolMetadata>(32);
    private static final ReentrantReadWriteLock REGISTRY_LOCK = new ReentrantReadWriteLock();
    private static volatile boolean initialized = false;

    private static void initializePlugins() {
        if (initialized) {
            return;
        }
        REGISTRY_LOCK.writeLock().lock();
        try {
            if (initialized) {
                return;
            }
            log.info("Initializing protocol plugins...");
            log.debug("Enhanced protocol plugin factory initialized");
            initialized = true;
            log.info("Initialized {} protocol plugins", (Object)PROTOCOL_ADAPTOR_MAP.size());
        }
        finally {
            REGISTRY_LOCK.writeLock().unlock();
        }
    }

    private static void registerProtocolAdaptor(ProtocolAdaptor adaptor) {
        try {
            String protocolType = adaptor.getProtocolType();
            if (protocolType == null || protocolType.trim().isEmpty()) {
                log.warn("Skip registering protocol adaptor with null or empty protocol type: {}", (Object)adaptor.getClass().getName());
                return;
            }
            adaptor.initialize();
            PROTOCOL_ADAPTOR_MAP.put(protocolType, adaptor);
            ProtocolMetadata metadata = new ProtocolMetadata(protocolType, adaptor.getVersion(), adaptor.getPriority(), adaptor.supportsBatchProcessing(), adaptor.getCapabilities());
            PROTOCOL_METADATA_MAP.put(protocolType, metadata);
            log.info("Registered protocol adaptor: {} (version: {}, priority: {})", new Object[]{protocolType, adaptor.getVersion(), adaptor.getPriority()});
        }
        catch (Exception e) {
            log.error("Failed to register protocol adaptor: {}", (Object)adaptor.getClass().getName(), (Object)e);
        }
    }

    public static ProtocolAdaptor<ProtocolTransportObject> getProtocolAdaptor(String protocolType) {
        if (protocolType == null || protocolType.trim().isEmpty()) {
            throw new IllegalArgumentException("Protocol type cannot be null or empty");
        }
        REGISTRY_LOCK.readLock().lock();
        try {
            ProtocolAdaptor<ProtocolTransportObject> adaptor = PROTOCOL_ADAPTOR_MAP.get(protocolType);
            if (adaptor == null && (adaptor = EnhancedProtocolPluginFactory.loadProtocolAdaptor(protocolType)) == null) {
                throw new IllegalArgumentException(String.format("Cannot find the Protocol adaptor: %s", protocolType));
            }
            ProtocolAdaptor<ProtocolTransportObject> protocolAdaptor = adaptor;
            return protocolAdaptor;
        }
        finally {
            REGISTRY_LOCK.readLock().unlock();
        }
    }

    public static ProtocolAdaptor<ProtocolTransportObject> getProtocolAdaptorWithFallback(String protocolType, String fallbackType) {
        try {
            return EnhancedProtocolPluginFactory.getProtocolAdaptor(protocolType);
        }
        catch (IllegalArgumentException e) {
            log.warn("Primary protocol {} not found, using fallback: {}", (Object)protocolType, (Object)fallbackType);
            return EnhancedProtocolPluginFactory.getProtocolAdaptor(fallbackType);
        }
    }

    public static List<String> getAvailableProtocolTypes() {
        REGISTRY_LOCK.readLock().lock();
        try {
            List<String> list = PROTOCOL_ADAPTOR_MAP.keySet().stream().sorted().collect(Collectors.toList());
            return list;
        }
        finally {
            REGISTRY_LOCK.readLock().unlock();
        }
    }

    public static List<ProtocolAdaptor<ProtocolTransportObject>> getProtocolAdaptorsByPriority() {
        REGISTRY_LOCK.readLock().lock();
        try {
            List<ProtocolAdaptor<ProtocolTransportObject>> list = PROTOCOL_ADAPTOR_MAP.values().stream().sorted((a, b) -> Integer.compare(b.getPriority(), a.getPriority())).collect(Collectors.toList());
            return list;
        }
        finally {
            REGISTRY_LOCK.readLock().unlock();
        }
    }

    public static ProtocolMetadata getProtocolMetadata(String protocolType) {
        REGISTRY_LOCK.readLock().lock();
        try {
            ProtocolMetadata protocolMetadata = PROTOCOL_METADATA_MAP.get(protocolType);
            return protocolMetadata;
        }
        finally {
            REGISTRY_LOCK.readLock().unlock();
        }
    }

    public static boolean isProtocolSupported(String protocolType) {
        if (protocolType == null || protocolType.trim().isEmpty()) {
            return false;
        }
        REGISTRY_LOCK.readLock().lock();
        try {
            boolean bl = PROTOCOL_ADAPTOR_MAP.containsKey(protocolType);
            return bl;
        }
        finally {
            REGISTRY_LOCK.readLock().unlock();
        }
    }

    public static List<ProtocolAdaptor<ProtocolTransportObject>> getProtocolAdaptorsByCapability(String capability) {
        if (capability == null || capability.trim().isEmpty()) {
            return Collections.emptyList();
        }
        REGISTRY_LOCK.readLock().lock();
        try {
            List<ProtocolAdaptor<ProtocolTransportObject>> list = PROTOCOL_ADAPTOR_MAP.values().stream().filter(adaptor -> adaptor.getCapabilities().contains(capability)).sorted((a, b) -> Integer.compare(b.getPriority(), a.getPriority())).collect(Collectors.toList());
            return list;
        }
        finally {
            REGISTRY_LOCK.readLock().unlock();
        }
    }

    private static ProtocolAdaptor<ProtocolTransportObject> loadProtocolAdaptor(String protocolType) {
        REGISTRY_LOCK.writeLock().lock();
        try {
            ProtocolAdaptor adaptor = PROTOCOL_ADAPTOR_MAP.get(protocolType);
            if (adaptor != null) {
                ProtocolAdaptor protocolAdaptor = adaptor;
                return protocolAdaptor;
            }
            adaptor = (ProtocolAdaptor)EventMeshExtensionFactory.getExtension(ProtocolAdaptor.class, (String)protocolType);
            if (adaptor != null) {
                EnhancedProtocolPluginFactory.registerProtocolAdaptor(adaptor);
            }
            ProtocolAdaptor protocolAdaptor = adaptor;
            return protocolAdaptor;
        }
        finally {
            REGISTRY_LOCK.writeLock().unlock();
        }
    }

    public static void shutdown() {
        REGISTRY_LOCK.writeLock().lock();
        try {
            log.info("Shutting down protocol plugins...");
            for (ProtocolAdaptor<ProtocolTransportObject> adaptor : PROTOCOL_ADAPTOR_MAP.values()) {
                try {
                    adaptor.destroy();
                }
                catch (Exception e) {
                    log.warn("Error destroying protocol adaptor: {}", (Object)adaptor.getProtocolType(), (Object)e);
                }
            }
            PROTOCOL_ADAPTOR_MAP.clear();
            PROTOCOL_METADATA_MAP.clear();
            initialized = false;
            log.info("Protocol plugins shutdown completed");
        }
        finally {
            REGISTRY_LOCK.writeLock().unlock();
        }
    }

    static {
        EnhancedProtocolPluginFactory.initializePlugins();
    }

    public static class ProtocolMetadata {
        private final String type;
        private final String version;
        private final int priority;
        private final boolean supportsBatch;
        private final Set<String> capabilities;

        public ProtocolMetadata(String type, String version, int priority, boolean supportsBatch, Set<String> capabilities) {
            this.type = type;
            this.version = version;
            this.priority = priority;
            this.supportsBatch = supportsBatch;
            this.capabilities = capabilities != null ? capabilities : Collections.emptySet();
        }

        public String getType() {
            return this.type;
        }

        public String getVersion() {
            return this.version;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean supportsBatch() {
            return this.supportsBatch;
        }

        public Set<String> getCapabilities() {
            return this.capabilities;
        }

        public String toString() {
            return String.format("ProtocolMetadata{type='%s', version='%s', priority=%d, batch=%s}", this.type, this.version, this.priority, this.supportsBatch);
        }
    }
}

