/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.service.builtin;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.util.IOUtils;
import com.slack.api.bolt.Initializer;
import com.slack.api.bolt.service.OAuthStateService;
import com.slack.api.bolt.util.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonS3OAuthStateService
implements OAuthStateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AmazonS3OAuthStateService.class);
    private final String bucketName;

    public AmazonS3OAuthStateService(String bucketName) {
        this.bucketName = bucketName;
    }

    @Override
    public Initializer initializer() {
        return app -> {
            boolean bucketExists;
            AWSCredentials credentials = this.getCredentials();
            if (credentials == null || credentials.getAWSAccessKeyId() == null) {
                throw new IllegalStateException("AWS credentials not found");
            }
            if (log.isDebugEnabled()) {
                log.debug("AWS credentials loaded (access key id: {})", (Object)credentials.getAWSAccessKeyId());
            }
            if (!(bucketExists = this.createS3Client().doesBucketExistV2(this.bucketName))) {
                throw new IllegalStateException("Failed to access the Amazon S3 bucket (name: " + this.bucketName + ")");
            }
        };
    }

    @Override
    public void addNewStateToDatastore(String state) throws Exception {
        AmazonS3 s3 = this.createS3Client();
        String value = "" + (System.currentTimeMillis() + this.getExpirationInSeconds() * 1000L);
        PutObjectResult putObjectResult = s3.putObject(this.bucketName, this.getKey(state), value);
        if (log.isDebugEnabled()) {
            log.debug("AWS S3 putObject result of state data - {}", (Object)JsonOps.toJsonString(putObjectResult));
        }
    }

    @Override
    public boolean isAvailableInDatabase(String state) {
        AmazonS3 s3 = this.createS3Client();
        S3Object s3Object = this.getObject(s3, this.getKey(state));
        if (s3Object == null) {
            return false;
        }
        String millisToExpire = null;
        try {
            millisToExpire = IOUtils.toString((InputStream)s3Object.getObjectContent());
            return Long.valueOf(millisToExpire) > System.currentTimeMillis();
        }
        catch (IOException e) {
            log.error("Failed to load a state data for state: {}", (Object)state, (Object)e);
            return false;
        }
        catch (NumberFormatException ne) {
            log.error("Invalid state value detected - state: {}, millisToExpire: {}", (Object)state, (Object)millisToExpire);
            return false;
        }
    }

    @Override
    public void deleteStateFromDatastore(String state) throws Exception {
        AmazonS3 s3 = this.createS3Client();
        s3.deleteObject(this.bucketName, this.getKey(state));
    }

    protected AWSCredentials getCredentials() {
        return DefaultAWSCredentialsProviderChain.getInstance().getCredentials();
    }

    protected AmazonS3 createS3Client() {
        return AmazonS3ClientBuilder.defaultClient();
    }

    private String getKey(String state) {
        return "state/" + state;
    }

    private S3Object getObject(AmazonS3 s3, String fullKey) {
        try {
            return s3.getObject(this.bucketName, fullKey);
        }
        catch (AmazonS3Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Amazon S3 object metadata not found (key: {}, AmazonS3Exception: {})", (Object)fullKey, (Object)e.toString());
            }
            return null;
        }
    }
}

