/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.util;

public class ListenerCodeSuggestion {
    public static final String COMMON_PREFIX = "---\n[Suggestion] You can handle this type of event with the following listener function:\n\n";
    public static final String WORKFLOW_STEP = "---\n[Suggestion] You can handle this type of event with the following listener function:\n\nWorkflowStep step = WorkflowStep.builder()\n  .callbackId(\"copy_review\")\n  .edit((req, ctx) -> { return ctx.ack(); })\n  .save((req, ctx) -> { return ctx.ack(); })\n  .execute((req, ctx) -> { return ctx.ack(); })\n  .build();\n\napp.step(step);\n";

    private ListenerCodeSuggestion() {
    }

    public static final String viewSubmission(String callbackId) {
        return "---\n[Suggestion] You can handle this type of event with the following listener function:\n\napp.viewSubmission(\"" + callbackId + "\", (req, ctx) -> {\n  // Sent inputs: req.getPayload().getView().getState().getValues()\n  return ctx.ack();\n});\n";
    }

    public static final String viewClosed(String callbackId) {
        return "---\n[Suggestion] You can handle this type of event with the following listener function:\n\napp.viewClosed(\"" + callbackId + "\", (req, ctx) -> {\n  // Do something where\n  return ctx.ack();\n});\n";
    }

    public static final String dialogSubmission(String callbackId) {
        return "---\n[Suggestion] You can handle this type of event with the following listener function:\n\napp.dialogSubmission(\"" + callbackId + "\", (req, ctx) -> {\n  // Do something where\n  return ctx.ack();\n});\n";
    }

    public static final String dialogSuggestion(String callbackId) {
        return "---\n[Suggestion] You can handle this type of event with the following listener function:\n\napp.dialogSubmission(\"" + callbackId + "\", (req, ctx) -> {\n  List<Option> options = Arrays.asList(Option.builder().label(\"label\").value(\"value\").build());\n  return ctx.ack(r -> r.options(options));\n});\n";
    }

    public static String dialogCancellation(String callbackId) {
        return "---\n[Suggestion] You can handle this type of event with the following listener function:\n\napp.dialogCancellation(\"" + callbackId + "\", (req, ctx) -> {\n  // Do something where\n  return ctx.ack();\n});\n";
    }

    public static final String command(String command) {
        return "---\n[Suggestion] You can handle this type of event with the following listener function:\n\napp.command(\"" + command + "\", (req, ctx) -> {\n  return ctx.ack();\n});\n";
    }

    public static final String attachmentAction(String callbackId) {
        return "---\n[Suggestion] You can handle this type of event with the following listener function:\n\napp.attachmentAction(\"" + callbackId + "\", (req, ctx) -> {\n  // Do something where\n  return ctx.ack();\n});\n";
    }

    public static final String blockAction(String actionId) {
        return "---\n[Suggestion] You can handle this type of event with the following listener function:\n\napp.blockAction(\"" + actionId + "\", (req, ctx) -> {\n  // Do something where\n  return ctx.ack();\n});\n";
    }

    public static final String blockSuggestion(String actionId) {
        return "---\n[Suggestion] You can handle this type of event with the following listener function:\n\napp.blockSuggestion(\"" + actionId + "\", (req, ctx) -> {\n  List<Option> options = Arrays.asList(Option.builder().text(plainText(\"label\")).value(\"v\").build());\n  return ctx.ack(r -> r.options(options));\n});\n";
    }

    public static final String event(String eventTypeAndSubtype) {
        String className = ListenerCodeSuggestion.toEventClassName(eventTypeAndSubtype);
        return "---\n[Suggestion] You can handle this type of event with the following listener function:\n\napp.event(" + className + ".class, (payload, ctx) -> {\n  return ctx.ack();\n});\n";
    }

    public static final String toEventClassName(String eventTypeAndSubtype) {
        String eventType = eventTypeAndSubtype;
        String[] elements = eventTypeAndSubtype.split(":");
        if (elements.length == 2) {
            eventType = elements[0] + "_" + elements[1].replaceFirst("_message", "").replaceFirst("message_", "");
        }
        if (eventType == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char[] cs = eventType.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            char c = cs[i];
            if (i == 0) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            if (c == '_') {
                sb.append(Character.toUpperCase(cs[++i]));
                continue;
            }
            sb.append(c);
        }
        return sb.toString() + "Event";
    }

    public static String globalShortcut(String callbackId) {
        return "---\n[Suggestion] You can handle this type of event with the following listener function:\n\napp.globalShortcut(\"" + callbackId + "\", (req, ctx) -> {\n  // Do something where\n  return ctx.ack();\n});\n";
    }

    public static String messageShortcut(String callbackId) {
        return "---\n[Suggestion] You can handle this type of event with the following listener function:\n\napp.messageShortcut(\"" + callbackId + "\", (req, ctx) -> {\n  // Do something where\n  return ctx.ack();\n});\n";
    }
}

