/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.meta.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.meta.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.metrics.api.MetricsPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.AbstractHTTPServer;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.apache.eventmesh.runtime.boot.FilterEngine;
import org.apache.eventmesh.runtime.boot.HTTPTrace;
import org.apache.eventmesh.runtime.boot.TransformerEngine;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.consumer.SubscriptionManager;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.ConsumerManager;
import org.apache.eventmesh.runtime.core.protocol.http.processor.BatchSendMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.BatchSendMessageV2Processor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.CreateTopicProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.DeleteTopicProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HandlerService;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HeartBeatProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.LocalSubscribeEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.LocalUnSubscribeEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.QuerySubscriptionProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.RemoteSubscribeEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.RemoteUnSubscribeEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.ReplyMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.SendAsyncEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.SendAsyncMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.SendAsyncRemoteEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.SendSyncMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.SubscribeProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.UnSubscribeProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.push.HTTPClientPool;
import org.apache.eventmesh.runtime.core.protocol.http.retry.HttpRetryer;
import org.apache.eventmesh.runtime.core.protocol.producer.ProducerManager;
import org.apache.eventmesh.runtime.meta.MetaStorage;
import org.apache.eventmesh.runtime.metrics.http.EventMeshHttpMetricsManager;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshHTTPServer
extends AbstractHTTPServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventMeshHTTPServer.class);
    private final EventMeshServer eventMeshServer;
    private final EventMeshHTTPConfiguration eventMeshHttpConfiguration;
    private final MetaStorage metaStorage;
    private final Acl acl;
    private final EventBus eventBus = new EventBus();
    private final transient HTTPClientPool httpClientPool = new HTTPClientPool(10);
    private ConsumerManager consumerManager;
    private ProducerManager producerManager;
    private SubscriptionManager subscriptionManager;
    private FilterEngine filterEngine;
    private TransformerEngine transformerEngine;
    private HttpRetryer httpRetryer;
    private transient RateLimiter msgRateLimiter;
    private transient RateLimiter batchRateLimiter;

    public EventMeshHTTPServer(EventMeshServer eventMeshServer, EventMeshHTTPConfiguration eventMeshHttpConfiguration) {
        super(eventMeshHttpConfiguration.getHttpServerPort(), eventMeshHttpConfiguration.isEventMeshServerUseTls(), eventMeshHttpConfiguration);
        this.eventMeshServer = eventMeshServer;
        this.eventMeshHttpConfiguration = eventMeshHttpConfiguration;
        this.metaStorage = eventMeshServer.getMetaStorage();
        this.acl = eventMeshServer.getAcl();
    }

    @Override
    public void init() throws Exception {
        log.info("==================EventMeshHTTPServer Initialing==================");
        super.init();
        this.msgRateLimiter = RateLimiter.create((double)this.eventMeshHttpConfiguration.getEventMeshHttpMsgReqNumPerSecond());
        this.batchRateLimiter = RateLimiter.create((double)this.eventMeshHttpConfiguration.getEventMeshBatchMsgRequestNumPerSecond());
        ArrayList metricsRegistries = Lists.newArrayList();
        Optional.ofNullable(this.eventMeshHttpConfiguration.getEventMeshMetricsPluginType()).ifPresent(metricsPlugins -> metricsPlugins.forEach(pluginType -> metricsRegistries.add(MetricsPluginFactory.getMetricsRegistry((String)pluginType))));
        this.httpRetryer = new HttpRetryer(this);
        super.setEventMeshHttpMetricsManager(new EventMeshHttpMetricsManager(this, metricsRegistries));
        this.subscriptionManager = new SubscriptionManager(this.eventMeshHttpConfiguration.isEventMeshServerMetaStorageEnable(), this.metaStorage);
        this.consumerManager = new ConsumerManager(this);
        this.consumerManager.init();
        this.producerManager = new ProducerManager(this);
        this.producerManager.init();
        this.filterEngine = new FilterEngine(this.metaStorage, this.producerManager, this.consumerManager);
        this.transformerEngine = new TransformerEngine(this.metaStorage, this.producerManager, this.consumerManager);
        super.setHandlerService(new HandlerService());
        super.getHandlerService().setMetrics(this.getEventMeshHttpMetricsManager());
        if (StringUtils.isNotEmpty((CharSequence)this.eventMeshHttpConfiguration.getEventMeshTracePluginType()) && this.eventMeshHttpConfiguration.isEventMeshServerTraceEnable()) {
            super.setUseTrace(this.eventMeshHttpConfiguration.isEventMeshServerTraceEnable());
        }
        super.getHandlerService().setHttpTrace(new HTTPTrace(this.eventMeshHttpConfiguration.isEventMeshServerTraceEnable()));
        this.registerHTTPRequestProcessor();
        log.info("==================EventMeshHTTPServer initialized==================");
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.getEventMeshHttpMetricsManager().start();
        this.consumerManager.start();
        this.producerManager.start();
        this.httpRetryer.start();
        if (this.metaStorage.getStarted().get()) {
            this.filterEngine.start();
        }
        if (this.eventMeshHttpConfiguration.isEventMeshServerMetaStorageEnable()) {
            this.register();
        }
        log.info("==================EventMeshHTTPServer started==================");
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
        this.getEventMeshHttpMetricsManager().shutdown();
        this.filterEngine.shutdown();
        this.transformerEngine.shutdown();
        this.consumerManager.shutdown();
        this.httpClientPool.shutdown();
        this.producerManager.shutdown();
        this.httpRetryer.shutdown();
        if (this.eventMeshHttpConfiguration.isEventMeshServerMetaStorageEnable()) {
            this.unRegister();
        }
        log.info("==================EventMeshHTTPServer shutdown==================");
    }

    public boolean register() {
        boolean registerResult = false;
        try {
            String endPoints = IPUtils.getLocalAddress() + ":" + this.eventMeshHttpConfiguration.getHttpServerPort();
            EventMeshRegisterInfo eventMeshRegisterInfo = new EventMeshRegisterInfo();
            eventMeshRegisterInfo.setEventMeshClusterName(this.eventMeshHttpConfiguration.getEventMeshCluster());
            eventMeshRegisterInfo.setEventMeshName(this.eventMeshHttpConfiguration.getEventMeshName() + "-" + "HTTP");
            eventMeshRegisterInfo.setEndPoint(endPoints);
            eventMeshRegisterInfo.setProtocolType("HTTP");
            registerResult = this.metaStorage.register(eventMeshRegisterInfo);
        }
        catch (Exception e) {
            log.error("eventMesh register to registry failed", (Throwable)e);
        }
        return registerResult;
    }

    private void unRegister() {
        String endPoints = IPUtils.getLocalAddress() + ":" + this.eventMeshHttpConfiguration.getHttpServerPort();
        EventMeshUnRegisterInfo eventMeshUnRegisterInfo = new EventMeshUnRegisterInfo();
        eventMeshUnRegisterInfo.setEventMeshClusterName(this.eventMeshHttpConfiguration.getEventMeshCluster());
        eventMeshUnRegisterInfo.setEventMeshName(this.eventMeshHttpConfiguration.getEventMeshName());
        eventMeshUnRegisterInfo.setEndPoint(endPoints);
        eventMeshUnRegisterInfo.setProtocolType("HTTP");
        boolean registerResult = this.metaStorage.unRegister(eventMeshUnRegisterInfo);
        if (!registerResult) {
            throw new EventMeshException("eventMesh fail to unRegister");
        }
    }

    private void registerHTTPRequestProcessor() throws Exception {
        BatchSendMessageProcessor batchSendMessageProcessor = new BatchSendMessageProcessor(this);
        this.registerProcessor(RequestCode.MSG_BATCH_SEND.getRequestCode(), batchSendMessageProcessor);
        BatchSendMessageV2Processor batchSendMessageV2Processor = new BatchSendMessageV2Processor(this);
        this.registerProcessor(RequestCode.MSG_BATCH_SEND_V2.getRequestCode(), batchSendMessageV2Processor);
        SendSyncMessageProcessor sendSyncMessageProcessor = new SendSyncMessageProcessor(this);
        this.registerProcessor(RequestCode.MSG_SEND_SYNC.getRequestCode(), sendSyncMessageProcessor);
        SendAsyncMessageProcessor sendAsyncMessageProcessor = new SendAsyncMessageProcessor(this);
        this.registerProcessor(RequestCode.MSG_SEND_ASYNC.getRequestCode(), sendAsyncMessageProcessor);
        SendAsyncEventProcessor sendAsyncEventProcessor = new SendAsyncEventProcessor(this);
        this.getHandlerService().register(sendAsyncEventProcessor);
        SendAsyncRemoteEventProcessor sendAsyncRemoteEventProcessor = new SendAsyncRemoteEventProcessor(this);
        this.getHandlerService().register(sendAsyncRemoteEventProcessor);
        HeartBeatProcessor heartProcessor = new HeartBeatProcessor(this);
        this.registerProcessor(RequestCode.HEARTBEAT.getRequestCode(), heartProcessor);
        SubscribeProcessor subscribeProcessor = new SubscribeProcessor(this);
        this.registerProcessor(RequestCode.SUBSCRIBE.getRequestCode(), subscribeProcessor);
        LocalSubscribeEventProcessor localSubscribeEventProcessor = new LocalSubscribeEventProcessor(this);
        this.getHandlerService().register(localSubscribeEventProcessor);
        RemoteSubscribeEventProcessor remoteSubscribeEventProcessor = new RemoteSubscribeEventProcessor(this);
        this.getHandlerService().register(remoteSubscribeEventProcessor);
        UnSubscribeProcessor unSubscribeProcessor = new UnSubscribeProcessor(this);
        this.registerProcessor(RequestCode.UNSUBSCRIBE.getRequestCode(), unSubscribeProcessor);
        LocalUnSubscribeEventProcessor localUnSubscribeEventProcessor = new LocalUnSubscribeEventProcessor(this);
        this.getHandlerService().register(localUnSubscribeEventProcessor);
        RemoteUnSubscribeEventProcessor remoteUnSubscribeEventProcessor = new RemoteUnSubscribeEventProcessor(this);
        this.getHandlerService().register(remoteUnSubscribeEventProcessor);
        ReplyMessageProcessor replyMessageProcessor = new ReplyMessageProcessor(this);
        this.registerProcessor(RequestCode.REPLY_MESSAGE.getRequestCode(), replyMessageProcessor);
        CreateTopicProcessor createTopicProcessor = new CreateTopicProcessor(this);
        this.getHandlerService().register(createTopicProcessor);
        DeleteTopicProcessor deleteTopicProcessor = new DeleteTopicProcessor(this);
        this.getHandlerService().register(deleteTopicProcessor);
        QuerySubscriptionProcessor querySubscriptionProcessor = new QuerySubscriptionProcessor(this);
        this.getHandlerService().register(querySubscriptionProcessor);
    }

    @Generated
    public EventMeshServer getEventMeshServer() {
        return this.eventMeshServer;
    }

    @Generated
    public EventMeshHTTPConfiguration getEventMeshHttpConfiguration() {
        return this.eventMeshHttpConfiguration;
    }

    @Generated
    public MetaStorage getMetaStorage() {
        return this.metaStorage;
    }

    @Generated
    public Acl getAcl() {
        return this.acl;
    }

    @Generated
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Generated
    public HTTPClientPool getHttpClientPool() {
        return this.httpClientPool;
    }

    @Generated
    public ConsumerManager getConsumerManager() {
        return this.consumerManager;
    }

    @Override
    @Generated
    public ProducerManager getProducerManager() {
        return this.producerManager;
    }

    @Generated
    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    @Generated
    public FilterEngine getFilterEngine() {
        return this.filterEngine;
    }

    @Generated
    public TransformerEngine getTransformerEngine() {
        return this.transformerEngine;
    }

    @Generated
    public HttpRetryer getHttpRetryer() {
        return this.httpRetryer;
    }

    @Generated
    public RateLimiter getMsgRateLimiter() {
        return this.msgRateLimiter;
    }

    @Generated
    public RateLimiter getBatchRateLimiter() {
        return this.batchRateLimiter;
    }
}

