/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.RedirectInfo;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.runtime.boot.TCPThreadPoolGroup;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.SessionState;
import org.apache.eventmesh.runtime.metrics.tcp.EventMeshTcpMetricsManager;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshTcp2Client {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventMeshTcp2Client.class);

    public static InetSocketAddress serverGoodby2Client(TCPThreadPoolGroup tcpThreadPoolGroup, Session session, ClientSessionGroupMapping mapping) {
        log.info("serverGoodby2Client client[{}]", (Object)session.getClient());
        try {
            long startTime = System.currentTimeMillis();
            Package msg = new Package();
            msg.setHeader(new Header(Command.SERVER_GOODBYE_REQUEST, OPStatus.SUCCESS.getCode().intValue(), "graceful normal quit from eventmesh", null));
            tcpThreadPoolGroup.getScheduler().submit(() -> {
                long taskExecuteTime = System.currentTimeMillis();
                Utils.writeAndFlush(msg, startTime, taskExecuteTime, session.getContext(), session);
            });
            InetSocketAddress address = (InetSocketAddress)session.getContext().channel().remoteAddress();
            EventMeshTcp2Client.closeSessionIfTimeout(tcpThreadPoolGroup, session, mapping);
            return address;
        }
        catch (Exception e) {
            log.error("exception occur while serverGoodby2Client", (Throwable)e);
            return null;
        }
    }

    public static InetSocketAddress goodBye2Client(TCPThreadPoolGroup tcpThreadPoolGroup, Session session, String errMsg, int eventMeshStatus, ClientSessionGroupMapping mapping) {
        try {
            long startTime = System.currentTimeMillis();
            Package msg = new Package();
            msg.setHeader(new Header(Command.SERVER_GOODBYE_REQUEST, eventMeshStatus, errMsg, null));
            tcpThreadPoolGroup.getScheduler().schedule(() -> {
                long taskExecuteTime = System.currentTimeMillis();
                Utils.writeAndFlush(msg, startTime, taskExecuteTime, session.getContext(), session);
            }, 1000L, TimeUnit.MILLISECONDS);
            EventMeshTcp2Client.closeSessionIfTimeout(tcpThreadPoolGroup, session, mapping);
            return session.getRemoteAddress();
        }
        catch (Exception e) {
            log.error("exception occur while goodbye2client", (Throwable)e);
            return null;
        }
    }

    public static void goodBye2Client(ChannelHandlerContext ctx, String errMsg, ClientSessionGroupMapping mapping, EventMeshTcpMetricsManager eventMeshTcpMetricsManager) {
        long startTime = System.currentTimeMillis();
        Package pkg = new Package(new Header(Command.SERVER_GOODBYE_REQUEST, OPStatus.FAIL.getCode().intValue(), errMsg, null));
        eventMeshTcpMetricsManager.eventMesh2clientMsgNumIncrement(IPUtils.parseChannelRemoteAddr((Channel)ctx.channel()));
        log.info("goodBye2Client client[{}]", (Object)RemotingHelper.parseChannelRemoteAddr(ctx.channel()));
        ctx.channel().eventLoop().execute(() -> ctx.writeAndFlush((Object)pkg).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            Utils.logSucceedMessageFlow(pkg, null, startTime, startTime);
            try {
                mapping.closeSession(ctx);
            }
            catch (Exception e) {
                log.warn("close session failed!", (Throwable)e);
            }
        })));
    }

    public static String redirectClient2NewEventMesh(TCPThreadPoolGroup tcpThreadPoolGroup, String newEventMeshIp, int port, Session session, ClientSessionGroupMapping mapping) {
        log.info("begin to gracefully redirect Client {}, newIPPort[{}]", (Object)session.getClient(), (Object)(newEventMeshIp + ":" + port));
        try {
            long startTime = System.currentTimeMillis();
            Package pkg = new Package();
            pkg.setHeader(new Header(Command.REDIRECT_TO_CLIENT, OPStatus.SUCCESS.getCode().intValue(), null, null));
            pkg.setBody((Object)new RedirectInfo(newEventMeshIp, port));
            tcpThreadPoolGroup.getScheduler().schedule(() -> {
                long taskExecuteTime = System.currentTimeMillis();
                Utils.writeAndFlush(pkg, startTime, taskExecuteTime, session.getContext(), session);
            }, 5000L, TimeUnit.MILLISECONDS);
            EventMeshTcp2Client.closeSessionIfTimeout(tcpThreadPoolGroup, session, mapping);
            return session.getRemoteAddress() + "--->" + newEventMeshIp + ":" + port;
        }
        catch (Exception e) {
            log.error("exception occur while redirectClient2NewEventMesh", (Throwable)e);
            return null;
        }
    }

    public static void closeSessionIfTimeout(TCPThreadPoolGroup tcpThreadPoolGroup, Session session, ClientSessionGroupMapping mapping) {
        tcpThreadPoolGroup.getScheduler().schedule(() -> {
            try {
                if (session.getSessionState() != SessionState.CLOSED) {
                    mapping.closeSession(session.getContext());
                    log.info("closeSessionIfTimeout success, session[{}]", (Object)session.getClient());
                }
            }
            catch (Exception e) {
                log.error("close session failed", (Throwable)e);
            }
        }, 30000L, TimeUnit.MILLISECONDS);
    }
}

