/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics.http;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.metrics.api.model.InstrumentFurther;
import org.apache.eventmesh.metrics.api.model.LongCounterMetric;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.metrics.api.model.ObservableDoubleGaugeMetric;
import org.apache.eventmesh.metrics.api.model.ObservableLongGaugeMetric;

public class HttpMetrics {
    private static Attributes EMPTY = Attributes.builder().build();
    private static final int STATIC_PERIOD = 30000;
    private static final String HTTP_METRICS_NAME_PREFIX = "eventmesh.http.";
    private static final String METRIC_NAME = "HTTP";
    private float wholeCost = 0.0f;
    private final AtomicLong wholeRequestNum = new AtomicLong(0L);
    private final AtomicLong httpDiscard = new AtomicLong(0L);
    private LongCounterMetric httpDiscardMetric;
    private final AtomicLong maxCost = new AtomicLong(0L);
    private final AtomicLong httpRequestPerSecond = new AtomicLong(0L);
    private final LinkedList<Integer> httpRequestTPSSnapshots = new LinkedList();
    private float httpDecodeTimeCost = 0.0f;
    private final AtomicLong httpDecodeNum = new AtomicLong(0L);
    private final AtomicLong sendBatchMsgNumPerSecond = new AtomicLong(0L);
    private final AtomicLong sendBatchMsgNumSum = new AtomicLong(0L);
    private LongCounterMetric sendBatchMsgNumSumMetric;
    private final AtomicLong sendBatchMsgFailNumSum = new AtomicLong(0L);
    private LongCounterMetric sendBatchMsgFailNumSumMetric;
    private final AtomicLong sendBatchMsgDiscardNumSum = new AtomicLong(0L);
    private LongCounterMetric sendBatchMsgDiscardNumSumMetric;
    private final LinkedList<Integer> sendBatchMsgTPSSnapshots = new LinkedList();
    private final AtomicLong sendMsgNumSum = new AtomicLong(0L);
    private LongCounterMetric sendMsgNumSumMetric;
    private final AtomicLong sendMsgFailNumSum = new AtomicLong(0L);
    private LongCounterMetric sendMsgFailNumSumMetric;
    private final AtomicLong replyMsgNumSum = new AtomicLong(0L);
    private LongCounterMetric replyMsgNumSumMetric;
    private final AtomicLong replyMsgFailNumSum = new AtomicLong(0L);
    private LongCounterMetric replyMsgFailNumSumMetric;
    private final AtomicLong sendMsgNumPerSecond = new AtomicLong(0L);
    private final LinkedList<Integer> sendMsgTPSSnapshots = new LinkedList();
    private float wholePushCost = 0.0f;
    private final AtomicLong wholePushRequestNum = new AtomicLong(0L);
    private final AtomicLong maxHttpPushLatency = new AtomicLong(0L);
    private final AtomicLong pushMsgNumPerSecond = new AtomicLong(0L);
    private final LinkedList<Integer> pushMsgTPSSnapshots = new LinkedList();
    private final AtomicLong httpPushMsgNumSum = new AtomicLong(0L);
    private LongCounterMetric httpPushMsgNumSumMetric;
    private final AtomicLong httpPushFailNumSum = new AtomicLong(0L);
    private LongCounterMetric httpPushFailNumSumMetric;
    private float batchSend2MQWholeCost = 0.0f;
    private final AtomicLong batchSend2MQNum = new AtomicLong(0L);
    private float send2MQWholeCost = 0.0f;
    private final AtomicLong send2MQNum = new AtomicLong(0L);
    private float reply2MQWholeCost = 0.0f;
    private final AtomicLong reply2MQNum = new AtomicLong(0L);
    private final ThreadPoolExecutor batchMsgExecutor;
    private final ThreadPoolExecutor sendMsgExecutor;
    private final ThreadPoolExecutor pushMsgExecutor;
    private final DelayQueue<?> httpFailedQueue;
    private final Map<String, String> labelMap;
    private final Map<String, Metric> metrics = new HashMap<String, Metric>(32);
    private ObservableDoubleGaugeMetric avgHttpBodyDecodeCostMetric;
    private ObservableDoubleGaugeMetric maxHttpTpsMetric;
    private ObservableDoubleGaugeMetric avgHttpTpsMetric;
    private ObservableLongGaugeMetric maxHttpCostMetric;
    private ObservableDoubleGaugeMetric avgHttpCostMetric;
    private ObservableDoubleGaugeMetric maxBatchSendMsgTpsMetric;
    private ObservableDoubleGaugeMetric avgBatchSendMsgTpsMetric;
    private ObservableDoubleGaugeMetric sumBatchFailRateMetric;
    private ObservableDoubleGaugeMetric maxSendMsgTpsMetric;
    private ObservableDoubleGaugeMetric avgSendMsgTpsMetric;
    private ObservableDoubleGaugeMetric sumFailRateMetric;
    private ObservableDoubleGaugeMetric maxPushMsgTpsMetric;
    private ObservableDoubleGaugeMetric avgPushMsgTpsMetric;
    private ObservableDoubleGaugeMetric pushSumFailRateMetric;
    private ObservableDoubleGaugeMetric maxClientLatencyMetric;
    private ObservableDoubleGaugeMetric avgClientLatencyMetric;
    private ObservableLongGaugeMetric batchMsgQMetric;
    private ObservableLongGaugeMetric sendMsgQMetric;
    private ObservableLongGaugeMetric pushMsgQMetric;
    private ObservableLongGaugeMetric httpRetryQMetric;
    private ObservableDoubleGaugeMetric batchAvgSend2MQCostMetric;
    private ObservableDoubleGaugeMetric avgSend2MQCostMetric;
    private ObservableDoubleGaugeMetric avgReply2MQCostMetric;

    public HttpMetrics(ThreadPoolExecutor batchMsgExecutor, ThreadPoolExecutor sendMsgExecutor, ThreadPoolExecutor pushMsgExecutor, DelayQueue<?> httpFailedQueue, Map<String, String> labelMap) {
        this.batchMsgExecutor = batchMsgExecutor;
        this.sendMsgExecutor = sendMsgExecutor;
        this.pushMsgExecutor = pushMsgExecutor;
        this.httpFailedQueue = httpFailedQueue;
        this.labelMap = Optional.ofNullable(labelMap).orElse(new HashMap(0));
        this.initMetrics();
    }

    private void initMetrics() {
        InstrumentFurther furtherHttpDiscard = new InstrumentFurther();
        furtherHttpDiscard.setUnit("1");
        furtherHttpDiscard.setDescription("Http request discard num.");
        furtherHttpDiscard.setName("eventmesh.http.request.discard.num");
        this.httpDiscardMetric = new LongCounterMetric(furtherHttpDiscard, METRIC_NAME);
        this.metrics.put("httpDiscardMetric", (Metric)this.httpDiscardMetric);
        InstrumentFurther furtherSendBatchMsgNumSum = new InstrumentFurther();
        furtherSendBatchMsgNumSum.setUnit("1");
        furtherSendBatchMsgNumSum.setDescription("Sum of batch send message number.");
        furtherSendBatchMsgNumSum.setName("eventmesh.http.batch.send.message.num");
        this.sendBatchMsgNumSumMetric = new LongCounterMetric(furtherSendBatchMsgNumSum, METRIC_NAME);
        this.metrics.put("sendBatchMsgNumSumMetric", (Metric)this.sendBatchMsgNumSumMetric);
        InstrumentFurther furtherSendBatchMsgFailNumSum = new InstrumentFurther();
        furtherSendBatchMsgFailNumSum.setUnit("1");
        furtherSendBatchMsgFailNumSum.setDescription("Sum of batch send message fail message number.");
        furtherSendBatchMsgFailNumSum.setName("eventmesh.http.batch.send.message.fail.num");
        this.sendBatchMsgFailNumSumMetric = new LongCounterMetric(furtherSendBatchMsgFailNumSum, METRIC_NAME);
        this.metrics.put("sendBatchMsgFailNumSumMetric", (Metric)this.sendBatchMsgFailNumSumMetric);
        InstrumentFurther furtherSendBatchMsgDiscardNumSum = new InstrumentFurther();
        furtherSendBatchMsgDiscardNumSum.setUnit("1");
        furtherSendBatchMsgDiscardNumSum.setDescription("Sum of batch send message fail message number.");
        furtherSendBatchMsgDiscardNumSum.setName("eventmesh.http.batch.send.message.discard.num");
        this.sendBatchMsgDiscardNumSumMetric = new LongCounterMetric(furtherSendBatchMsgDiscardNumSum, METRIC_NAME);
        this.metrics.put("sendBatchMsgDiscardNumSumMetric", (Metric)this.sendBatchMsgDiscardNumSumMetric);
        InstrumentFurther furtherSendMsgNumSum = new InstrumentFurther();
        furtherSendMsgNumSum.setUnit("1");
        furtherSendMsgNumSum.setDescription("Sum of send message number.");
        furtherSendMsgNumSum.setName("eventmesh.http.send.message.num");
        this.sendMsgNumSumMetric = new LongCounterMetric(furtherSendMsgNumSum, METRIC_NAME);
        this.metrics.put("sendMsgNumSumMetric", (Metric)this.sendMsgNumSumMetric);
        InstrumentFurther furtherSendMsgFailNumSum = new InstrumentFurther();
        furtherSendMsgFailNumSum.setUnit("1");
        furtherSendMsgFailNumSum.setDescription("Sum of send message fail number.");
        furtherSendMsgFailNumSum.setName("eventmesh.http.send.message.fail.num");
        this.sendMsgFailNumSumMetric = new LongCounterMetric(furtherSendMsgFailNumSum, METRIC_NAME);
        this.metrics.put("sendMsgFailNumSumMetric", (Metric)this.sendMsgFailNumSumMetric);
        InstrumentFurther furtherReplyMsgNumSum = new InstrumentFurther();
        furtherReplyMsgNumSum.setUnit("1");
        furtherReplyMsgNumSum.setDescription("Sum of reply message number.");
        furtherReplyMsgNumSum.setName("eventmesh.http.reply.message.num");
        this.replyMsgNumSumMetric = new LongCounterMetric(furtherReplyMsgNumSum, METRIC_NAME);
        this.metrics.put("replyMsgNumSumMetric", (Metric)this.replyMsgNumSumMetric);
        InstrumentFurther furtherReplyMsgFailNumSum = new InstrumentFurther();
        furtherReplyMsgFailNumSum.setUnit("1");
        furtherReplyMsgFailNumSum.setDescription("Sum of reply message fail number.");
        furtherReplyMsgFailNumSum.setName("eventmesh.http.reply.message.fail.num");
        this.replyMsgFailNumSumMetric = new LongCounterMetric(furtherReplyMsgFailNumSum, METRIC_NAME);
        this.metrics.put("replyMsgFailNumSumMetric", (Metric)this.replyMsgFailNumSumMetric);
        InstrumentFurther furtherHttpPushMsgNumSum = new InstrumentFurther();
        furtherHttpPushMsgNumSum.setUnit("1");
        furtherHttpPushMsgNumSum.setDescription("Sum of http push message number.");
        furtherHttpPushMsgNumSum.setName("eventmesh.http.push.message.num");
        this.httpPushMsgNumSumMetric = new LongCounterMetric(furtherHttpPushMsgNumSum, METRIC_NAME);
        this.metrics.put("httpPushMsgNumSumMetric", (Metric)this.httpPushMsgNumSumMetric);
        InstrumentFurther furtherHttpPushFailNumSum = new InstrumentFurther();
        furtherHttpPushFailNumSum.setUnit("1");
        furtherHttpPushFailNumSum.setDescription("Sum of http push message fail number.");
        furtherHttpPushFailNumSum.setName("eventmesh.http.push.message.fail.num");
        this.httpPushFailNumSumMetric = new LongCounterMetric(furtherHttpPushFailNumSum, METRIC_NAME);
        this.metrics.put("httpPushFailNumSumMetric", (Metric)this.httpPushFailNumSumMetric);
        InstrumentFurther furtherHttpDecode = new InstrumentFurther();
        furtherHttpDecode.setUnit("ms");
        furtherHttpDecode.setDescription("Avg body decode cost time of http");
        furtherHttpDecode.setName("eventmesh.http.body.decode.cost.avg");
        this.avgHttpBodyDecodeCostMetric = new ObservableDoubleGaugeMetric(furtherHttpDecode, METRIC_NAME, () -> this.avgHTTPBodyDecodeCost());
        this.avgHttpBodyDecodeCostMetric.putAll(this.labelMap);
        this.metrics.put("avgHttpBodyDecodeCostMetric", (Metric)this.avgHttpBodyDecodeCostMetric);
        InstrumentFurther furtherMaxHttpTps = new InstrumentFurther();
        furtherMaxHttpTps.setUnit("tps");
        furtherMaxHttpTps.setDescription("Max TPS of HTTP.");
        furtherMaxHttpTps.setName("eventmesh.http.request.tps.max");
        this.maxHttpTpsMetric = new ObservableDoubleGaugeMetric(furtherMaxHttpTps, METRIC_NAME, () -> this.maxHTTPTPS());
        this.maxHttpTpsMetric.putAll(this.labelMap);
        this.metrics.put("maxHttpTpsMetric", (Metric)this.maxHttpTpsMetric);
        InstrumentFurther furtherAvgHttpTps = new InstrumentFurther();
        furtherAvgHttpTps.setUnit("tps");
        furtherAvgHttpTps.setDescription("Avg TPS of HTTP.");
        furtherAvgHttpTps.setName("eventmesh.http.request.tps.avg");
        this.avgHttpTpsMetric = new ObservableDoubleGaugeMetric(furtherAvgHttpTps, METRIC_NAME, () -> this.avgHTTPTPS());
        this.avgHttpTpsMetric.putAll(this.labelMap);
        this.metrics.put("avgHttpTpsMetric", (Metric)this.avgHttpTpsMetric);
        InstrumentFurther furtherMaxCostHttpTps = new InstrumentFurther();
        furtherMaxCostHttpTps.setUnit("ms");
        furtherMaxCostHttpTps.setDescription("Max cost of HTTP.");
        furtherMaxCostHttpTps.setName("eventmesh.http.request.cost.max");
        this.maxHttpCostMetric = new ObservableLongGaugeMetric(furtherMaxCostHttpTps, METRIC_NAME, () -> this.maxHTTPCost());
        this.maxHttpCostMetric.putAll(this.labelMap);
        this.metrics.put("maxHttpCostMetric", (Metric)this.maxHttpCostMetric);
        InstrumentFurther furtherAvgHttpCost = new InstrumentFurther();
        furtherAvgHttpCost.setUnit("tps");
        furtherAvgHttpCost.setDescription("Avg cost of HTTP.");
        furtherAvgHttpCost.setName("eventmesh.http.request.cost.avg");
        this.avgHttpCostMetric = new ObservableDoubleGaugeMetric(furtherAvgHttpCost, METRIC_NAME, () -> this.avgHTTPCost());
        this.avgHttpCostMetric.putAll(this.labelMap);
        this.metrics.put("avgHttpCostMetric", (Metric)this.avgHttpCostMetric);
        InstrumentFurther furtherMaxBatchSendMsgTps = new InstrumentFurther();
        furtherMaxBatchSendMsgTps.setUnit("tps");
        furtherMaxBatchSendMsgTps.setDescription("Max of batch send message tps");
        furtherMaxBatchSendMsgTps.setName("eventmesh.http.batch.send.message.tps.max");
        this.maxBatchSendMsgTpsMetric = new ObservableDoubleGaugeMetric(furtherMaxBatchSendMsgTps, METRIC_NAME, () -> this.maxSendBatchMsgTPS());
        this.maxBatchSendMsgTpsMetric.putAll(this.labelMap);
        this.metrics.put("maxBatchSendMsgTpsMetric", (Metric)this.maxBatchSendMsgTpsMetric);
        InstrumentFurther furtherAvgBatchSendMsgTps = new InstrumentFurther();
        furtherAvgBatchSendMsgTps.setUnit("tps");
        furtherAvgBatchSendMsgTps.setDescription("Avg of batch send message tps.");
        furtherAvgBatchSendMsgTps.setName("eventmesh.http.batch.send.message.tps.avg");
        this.avgBatchSendMsgTpsMetric = new ObservableDoubleGaugeMetric(furtherAvgBatchSendMsgTps, METRIC_NAME, () -> this.avgSendBatchMsgTPS());
        this.avgBatchSendMsgTpsMetric.putAll(this.labelMap);
        this.metrics.put("avgBatchSendMsgTpsMetric", (Metric)this.avgBatchSendMsgTpsMetric);
        InstrumentFurther furtherSumBatchFailRate = new InstrumentFurther();
        furtherSumBatchFailRate.setUnit("%");
        furtherSumBatchFailRate.setDescription("Send batch message fail rate.");
        furtherSumBatchFailRate.setName("eventmesh.http.batch.send.message.fail.rate");
        this.sumBatchFailRateMetric = new ObservableDoubleGaugeMetric(furtherSumBatchFailRate, METRIC_NAME, () -> this.getSendBatchMsgFailRate());
        this.sumBatchFailRateMetric.putAll(this.labelMap);
        this.metrics.put("sumBatchFailRateMetric", (Metric)this.sumBatchFailRateMetric);
        InstrumentFurther furtherMaxSendMsgTps = new InstrumentFurther();
        furtherMaxSendMsgTps.setUnit("tps");
        furtherMaxSendMsgTps.setDescription("Max of send message tps");
        furtherMaxSendMsgTps.setName("eventmesh.http.send.message.tps.max");
        this.maxSendMsgTpsMetric = new ObservableDoubleGaugeMetric(furtherMaxSendMsgTps, METRIC_NAME, () -> this.maxSendMsgTPS());
        this.maxSendMsgTpsMetric.putAll(this.labelMap);
        this.metrics.put("maxSendMsgTpsMetric", (Metric)this.maxSendMsgTpsMetric);
        InstrumentFurther furtherAvgSendMsgTps = new InstrumentFurther();
        furtherAvgSendMsgTps.setUnit("tps");
        furtherAvgSendMsgTps.setDescription("Avg of send message tps");
        furtherAvgSendMsgTps.setName("eventmesh.http.send.message.tps.avg");
        this.avgSendMsgTpsMetric = new ObservableDoubleGaugeMetric(furtherAvgSendMsgTps, METRIC_NAME, () -> this.avgSendMsgTPS());
        this.avgSendMsgTpsMetric.putAll(this.labelMap);
        this.metrics.put("avgSendMsgTpsMetric", (Metric)this.avgSendMsgTpsMetric);
        InstrumentFurther furtherSumFailRate = new InstrumentFurther();
        furtherSumFailRate.setUnit("%");
        furtherSumFailRate.setDescription("Send message fail rate.");
        furtherSumFailRate.setName("eventmesh.http.send.message.fail.rate");
        this.sumFailRateMetric = new ObservableDoubleGaugeMetric(furtherSumFailRate, METRIC_NAME, () -> this.getSendBatchMsgFailRate());
        this.sumFailRateMetric.putAll(this.labelMap);
        this.metrics.put("sumFailRateMetric", (Metric)this.sumFailRateMetric);
        InstrumentFurther furtherMaxPushMsgTps = new InstrumentFurther();
        furtherMaxPushMsgTps.setUnit("tps");
        furtherMaxPushMsgTps.setDescription("Max of push message tps.");
        furtherMaxPushMsgTps.setName("eventmesh.http.push.message.tps.max");
        this.maxPushMsgTpsMetric = new ObservableDoubleGaugeMetric(furtherMaxPushMsgTps, METRIC_NAME, () -> this.maxPushMsgTPS());
        this.maxPushMsgTpsMetric.putAll(this.labelMap);
        this.metrics.put("maxPushMsgTpsMetric", (Metric)this.maxPushMsgTpsMetric);
        InstrumentFurther furtherAvgPushMsgTps = new InstrumentFurther();
        furtherAvgPushMsgTps.setUnit("tps");
        furtherAvgPushMsgTps.setDescription("Avg of push message tps.");
        furtherAvgPushMsgTps.setName("eventmesh.http.push.message.tps.avg");
        this.avgPushMsgTpsMetric = new ObservableDoubleGaugeMetric(furtherAvgPushMsgTps, METRIC_NAME, () -> this.avgPushMsgTPS());
        this.avgPushMsgTpsMetric.putAll(this.labelMap);
        this.metrics.put("avgPushMsgTpsMetric", (Metric)this.avgPushMsgTpsMetric);
        InstrumentFurther furtherPushSumFailRate = new InstrumentFurther();
        furtherPushSumFailRate.setUnit("%");
        furtherPushSumFailRate.setDescription("Http push message fail rate.");
        furtherPushSumFailRate.setName("eventmesh.http.push.message.fail.rate");
        this.pushSumFailRateMetric = new ObservableDoubleGaugeMetric(furtherPushSumFailRate, METRIC_NAME, () -> this.getHttpPushMsgFailRate());
        this.pushSumFailRateMetric.putAll(this.labelMap);
        this.metrics.put("pushSumFailRateMetric", (Metric)this.pushSumFailRateMetric);
        InstrumentFurther furtherMaxClientLatency = new InstrumentFurther();
        furtherMaxClientLatency.setUnit("ms");
        furtherMaxClientLatency.setDescription("Max of http push latency.");
        furtherMaxClientLatency.setName("eventmesh.http.push.latency.max");
        this.maxClientLatencyMetric = new ObservableDoubleGaugeMetric(furtherMaxClientLatency, METRIC_NAME, () -> this.maxHTTPPushLatency());
        this.maxClientLatencyMetric.putAll(this.labelMap);
        this.metrics.put("maxClientLatencyMetric", (Metric)this.maxClientLatencyMetric);
        InstrumentFurther furtherAvgClientLatency = new InstrumentFurther();
        furtherAvgClientLatency.setUnit("ms");
        furtherAvgClientLatency.setDescription("Avg of http push latency.");
        furtherAvgClientLatency.setName("eventmesh.http.push.latency.avg");
        this.avgClientLatencyMetric = new ObservableDoubleGaugeMetric(furtherAvgClientLatency, METRIC_NAME, () -> this.avgHTTPPushLatency());
        this.avgClientLatencyMetric.putAll(this.labelMap);
        this.metrics.put("avgClientLatencyMetric", (Metric)this.avgClientLatencyMetric);
        InstrumentFurther furtherBatchMsgQ = new InstrumentFurther();
        furtherBatchMsgQ.setUnit("1");
        furtherBatchMsgQ.setDescription("Size of batch message queue.");
        furtherBatchMsgQ.setName("eventmesh.http.batch.message.queue.size");
        this.batchMsgQMetric = new ObservableLongGaugeMetric(furtherBatchMsgQ, METRIC_NAME, () -> this.getBatchMsgQueueSize());
        this.batchMsgQMetric.putAll(this.labelMap);
        this.metrics.put("batchMsgQMetric", (Metric)this.batchMsgQMetric);
        InstrumentFurther furtherSendMsgQ = new InstrumentFurther();
        furtherSendMsgQ.setUnit("1");
        furtherSendMsgQ.setDescription("Size of send message queue.");
        furtherSendMsgQ.setName("eventmesh.http.send.message.queue.size");
        this.sendMsgQMetric = new ObservableLongGaugeMetric(furtherSendMsgQ, METRIC_NAME, () -> this.getSendMsgQueueSize());
        this.sendMsgQMetric.putAll(this.labelMap);
        this.metrics.put("sendMsgQMetric", (Metric)this.sendMsgQMetric);
        InstrumentFurther furtherPushMsgQ = new InstrumentFurther();
        furtherPushMsgQ.setUnit("1");
        furtherPushMsgQ.setDescription("Size of push message queue.");
        furtherPushMsgQ.setName("eventmesh.http.push.message.queue.size");
        this.pushMsgQMetric = new ObservableLongGaugeMetric(furtherPushMsgQ, METRIC_NAME, () -> this.getPushMsgQueueSize());
        this.pushMsgQMetric.putAll(this.labelMap);
        this.metrics.put("pushMsgQMetric", (Metric)this.pushMsgQMetric);
        InstrumentFurther furtherHttpRetryQ = new InstrumentFurther();
        furtherHttpRetryQ.setUnit("1");
        furtherHttpRetryQ.setDescription("Size of http retry queue.");
        furtherHttpRetryQ.setName("eventmesh.http.retry.queue.size");
        this.httpRetryQMetric = new ObservableLongGaugeMetric(furtherHttpRetryQ, METRIC_NAME, () -> this.getHttpRetryQueueSize());
        this.httpRetryQMetric.putAll(this.labelMap);
        this.metrics.put("httpRetryQMetric", (Metric)this.httpRetryQMetric);
        InstrumentFurther furtherBatchAvgSend2MQCost = new InstrumentFurther();
        furtherBatchAvgSend2MQCost.setUnit("ms");
        furtherBatchAvgSend2MQCost.setDescription("Avg of batch send message cost.");
        furtherBatchAvgSend2MQCost.setName("eventmesh.http.batch.send.message.cost.avg");
        this.batchAvgSend2MQCostMetric = new ObservableDoubleGaugeMetric(furtherBatchAvgSend2MQCost, METRIC_NAME, () -> this.avgBatchSendMsgCost());
        this.batchAvgSend2MQCostMetric.putAll(this.labelMap);
        this.metrics.put("avgClientLatencyMetric", (Metric)this.batchAvgSend2MQCostMetric);
        InstrumentFurther furtherAvgSend2MQCost = new InstrumentFurther();
        furtherAvgSend2MQCost.setUnit("tps");
        furtherAvgSend2MQCost.setDescription("Avg of send message cost.");
        furtherAvgSend2MQCost.setName("eventmesh.http.send.message.cost.avg");
        this.avgSend2MQCostMetric = new ObservableDoubleGaugeMetric(furtherAvgSend2MQCost, METRIC_NAME, () -> this.avgSendMsgCost());
        this.avgSend2MQCostMetric.putAll(this.labelMap);
        this.metrics.put("avgSend2MQCostMetric", (Metric)this.avgSend2MQCostMetric);
        InstrumentFurther furtherAvgReply2MQCost = new InstrumentFurther();
        furtherAvgReply2MQCost.setUnit("tps");
        furtherAvgReply2MQCost.setDescription("Avg of reply message cost.");
        furtherAvgReply2MQCost.setName("eventmesh.http.reply.message.cost.avg");
        this.avgReply2MQCostMetric = new ObservableDoubleGaugeMetric(furtherAvgReply2MQCost, METRIC_NAME, () -> this.avgReplyMsgCost());
        this.avgReply2MQCostMetric.putAll(this.labelMap);
        this.metrics.put("avgReply2MQCostMetric", (Metric)this.avgReply2MQCostMetric);
    }

    public Collection<Metric> getMetrics() {
        return this.metrics.values();
    }

    public double avgHTTPCost() {
        return this.wholeRequestNum.longValue() == 0L ? 0.0 : (double)(this.wholeCost / (float)this.wholeRequestNum.longValue());
    }

    public long maxHTTPCost() {
        return this.maxCost.longValue();
    }

    public long getHttpDiscard() {
        return this.httpDiscard.longValue();
    }

    public void recordHTTPRequest() {
        this.httpRequestPerSecond.incrementAndGet();
    }

    public void recordHTTPDiscard() {
        this.httpDiscard.incrementAndGet();
        HashMap<String, String> attributes = new HashMap<String, String>(this.labelMap);
        this.httpDiscardMetric.getInstrument().add(1L, HttpMetrics.buildAttributes(attributes));
    }

    private static Attributes buildAttributes(Map<String, String> attributes) {
        if (MapUtils.isEmpty(attributes)) {
            return EMPTY;
        }
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributes.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        return attributesBuilder.build();
    }

    public void snapshotHTTPTPS() {
        Integer tps = this.httpRequestPerSecond.intValue();
        this.httpRequestTPSSnapshots.add(tps);
        this.httpRequestPerSecond.set(0L);
        if (this.httpRequestTPSSnapshots.size() > 30) {
            this.httpRequestTPSSnapshots.removeFirst();
        }
    }

    public double maxHTTPTPS() {
        return Collections.max(this.httpRequestTPSSnapshots).intValue();
    }

    public double avgHTTPTPS() {
        return this.avg(this.httpRequestTPSSnapshots);
    }

    public void recordHTTPReqResTimeCost(long cost) {
        this.wholeRequestNum.incrementAndGet();
        this.wholeCost += (float)cost;
        if (cost > this.maxCost.longValue()) {
            this.maxCost.set(cost);
        }
    }

    public void httpStatInfoClear() {
        this.wholeRequestNum.set(0L);
        this.wholeCost = 0.0f;
        this.maxCost.set(0L);
        this.httpDecodeNum.set(0L);
        this.httpDecodeTimeCost = 0.0f;
    }

    public void recordDecodeTimeCost(long cost) {
        this.httpDecodeNum.incrementAndGet();
        this.httpDecodeTimeCost += (float)cost;
    }

    public double avgHTTPBodyDecodeCost() {
        return this.httpDecodeNum.longValue() == 0L ? 0.0 : (double)this.httpDecodeTimeCost / (double)this.httpDecodeNum.longValue();
    }

    public void recordSendBatchMsgDiscard(long delta) {
        this.sendBatchMsgDiscardNumSum.addAndGet(delta);
        this.sendBatchMsgDiscardNumSumMetric.getInstrument().add(delta, HttpMetrics.buildAttributes(this.labelMap));
    }

    public void snapshotSendBatchMsgTPS() {
        Integer tps = this.sendBatchMsgNumPerSecond.intValue();
        this.sendBatchMsgTPSSnapshots.add(tps);
        this.sendBatchMsgNumPerSecond.set(0L);
        if (this.sendBatchMsgTPSSnapshots.size() > 30) {
            this.sendBatchMsgTPSSnapshots.removeFirst();
        }
    }

    public double maxSendBatchMsgTPS() {
        return Collections.max(this.sendBatchMsgTPSSnapshots).intValue();
    }

    public double avgSendBatchMsgTPS() {
        return this.avg(this.sendBatchMsgTPSSnapshots);
    }

    public void recordSendBatchMsg(long delta) {
        this.sendBatchMsgNumPerSecond.addAndGet(delta);
        this.sendBatchMsgNumSum.addAndGet(delta);
        this.sendBatchMsgNumSumMetric.getInstrument().add(delta, HttpMetrics.buildAttributes(this.labelMap));
    }

    public void recordSendBatchMsgFailed(long delta) {
        this.sendBatchMsgFailNumSum.getAndAdd(delta);
        this.sendBatchMsgFailNumSumMetric.getInstrument().add(delta, HttpMetrics.buildAttributes(this.labelMap));
    }

    public long getSendBatchMsgNumSum() {
        return this.sendBatchMsgNumSum.longValue();
    }

    public long getSendBatchMsgFailNumSum() {
        return this.sendBatchMsgFailNumSum.longValue();
    }

    public double getSendBatchMsgFailRate() {
        return this.sendBatchMsgNumSum.longValue() == 0L ? 0.0 : (double)(this.sendBatchMsgFailNumSum.floatValue() / (float)this.sendBatchMsgNumSum.longValue());
    }

    public void cleanSendBatchStat() {
        this.sendBatchMsgNumSum.set(0L);
        this.sendBatchMsgFailNumSum.set(0L);
    }

    public long getSendBatchMsgDiscardNumSum() {
        return this.sendBatchMsgDiscardNumSum.longValue();
    }

    public void snapshotSendMsgTPS() {
        Integer tps = this.sendMsgNumPerSecond.intValue();
        this.sendMsgTPSSnapshots.add(tps);
        this.sendMsgNumPerSecond.set(0L);
        if (this.sendMsgTPSSnapshots.size() > 30) {
            this.sendMsgTPSSnapshots.removeFirst();
        }
    }

    public double maxSendMsgTPS() {
        return Collections.max(this.sendMsgTPSSnapshots).intValue();
    }

    public double avgSendMsgTPS() {
        return this.avg(this.sendMsgTPSSnapshots);
    }

    public void recordSendMsg() {
        this.sendMsgNumPerSecond.incrementAndGet();
        this.sendMsgNumSum.incrementAndGet();
        this.sendMsgNumSumMetric.getInstrument().add(1L, HttpMetrics.buildAttributes(this.labelMap));
    }

    public void recordReplyMsg() {
        this.replyMsgNumSum.incrementAndGet();
        this.replyMsgNumSumMetric.getInstrument().add(1L, HttpMetrics.buildAttributes(this.labelMap));
    }

    public void recordReplyMsgFailed() {
        this.replyMsgFailNumSum.incrementAndGet();
        this.replyMsgFailNumSumMetric.getInstrument().add(1L, HttpMetrics.buildAttributes(this.labelMap));
    }

    public long getReplyMsgNumSum() {
        return this.replyMsgNumSum.longValue();
    }

    public long getReplyMsgFailNumSum() {
        return this.replyMsgFailNumSum.longValue();
    }

    public long getSendMsgNumSum() {
        return this.sendMsgNumSum.longValue();
    }

    public long getSendMsgFailNumSum() {
        return this.sendMsgFailNumSum.longValue();
    }

    public float getSendMsgFailRate() {
        return this.sendMsgNumSum.longValue() == 0L ? 0.0f : this.sendMsgFailNumSum.floatValue() / (float)this.sendMsgNumSum.longValue();
    }

    public void recordSendMsgFailed() {
        this.sendMsgFailNumSum.incrementAndGet();
        this.sendMsgFailNumSumMetric.getInstrument().add(1L, HttpMetrics.buildAttributes(this.labelMap));
    }

    public void cleanSendMsgStat() {
        this.sendMsgNumSum.set(0L);
        this.replyMsgNumSum.set(0L);
        this.sendMsgFailNumSum.set(0L);
        this.replyMsgFailNumSum.set(0L);
    }

    public void snapshotPushMsgTPS() {
        Integer tps = this.pushMsgNumPerSecond.intValue();
        this.pushMsgTPSSnapshots.add(tps);
        this.pushMsgNumPerSecond.set(0L);
        if (this.pushMsgTPSSnapshots.size() > 30) {
            this.pushMsgTPSSnapshots.removeFirst();
        }
    }

    public void recordHTTPPushTimeCost(long cost) {
        this.wholePushRequestNum.incrementAndGet();
        this.wholePushCost += (float)cost;
        if (cost > this.maxHttpPushLatency.longValue()) {
            this.maxHttpPushLatency.set(cost);
        }
    }

    public double avgHTTPPushLatency() {
        return this.wholePushRequestNum.longValue() == 0L ? 0.0 : (double)(this.wholePushCost / (float)this.wholePushRequestNum.longValue());
    }

    public double maxHTTPPushLatency() {
        return this.maxHttpPushLatency.floatValue();
    }

    public double maxPushMsgTPS() {
        return Collections.max(this.pushMsgTPSSnapshots).intValue();
    }

    public double avgPushMsgTPS() {
        return this.avg(this.pushMsgTPSSnapshots);
    }

    public void recordPushMsg() {
        this.pushMsgNumPerSecond.incrementAndGet();
        this.httpPushMsgNumSum.incrementAndGet();
        this.httpPushMsgNumSumMetric.getInstrument().add(1L, HttpMetrics.buildAttributes(this.labelMap));
    }

    public long getHttpPushMsgNumSum() {
        return this.httpPushMsgNumSum.longValue();
    }

    public long getHttpPushFailNumSum() {
        return this.httpPushFailNumSum.longValue();
    }

    public double getHttpPushMsgFailRate() {
        return this.httpPushMsgNumSum.longValue() == 0L ? 0.0 : (double)(this.httpPushFailNumSum.floatValue() / (float)this.httpPushMsgNumSum.longValue());
    }

    public void recordHttpPushMsgFailed() {
        this.sendMsgFailNumSum.incrementAndGet();
        this.sendMsgFailNumSumMetric.getInstrument().add(1L, HttpMetrics.buildAttributes(this.labelMap));
    }

    public void cleanHttpPushMsgStat() {
        this.httpPushFailNumSum.set(0L);
        this.httpPushMsgNumSum.set(0L);
        this.wholeRequestNum.set(0L);
        this.wholeCost = 0.0f;
        this.maxCost.set(0L);
    }

    public void recordBatchSendMsgCost(long cost) {
        this.batchSend2MQNum.incrementAndGet();
        this.batchSend2MQWholeCost += (float)cost;
    }

    public double avgBatchSendMsgCost() {
        return this.batchSend2MQNum.intValue() == 0 ? 0.0 : (double)(this.batchSend2MQWholeCost / (float)this.batchSend2MQNum.intValue());
    }

    public void recordSendMsgCost(long cost) {
        this.send2MQNum.incrementAndGet();
        this.send2MQWholeCost += (float)cost;
    }

    public double avgSendMsgCost() {
        return this.send2MQNum.intValue() == 0 ? 0.0 : (double)(this.send2MQWholeCost / (float)this.send2MQNum.intValue());
    }

    public void recordReplyMsgCost(long cost) {
        this.reply2MQNum.incrementAndGet();
        this.reply2MQWholeCost += (float)cost;
    }

    public double avgReplyMsgCost() {
        return this.reply2MQNum.intValue() == 0 ? 0.0 : (double)(this.reply2MQWholeCost / (float)this.reply2MQNum.intValue());
    }

    public void send2MQStatInfoClear() {
        this.batchSend2MQWholeCost = 0.0f;
        this.batchSend2MQNum.set(0L);
        this.send2MQWholeCost = 0.0f;
        this.send2MQNum.set(0L);
        this.reply2MQWholeCost = 0.0f;
        this.reply2MQNum.set(0L);
    }

    public long getBatchMsgQueueSize() {
        return this.batchMsgExecutor.getQueue().size();
    }

    public long getSendMsgQueueSize() {
        return this.sendMsgExecutor.getQueue().size();
    }

    public long getPushMsgQueueSize() {
        return this.pushMsgExecutor.getQueue().size();
    }

    public long getHttpRetryQueueSize() {
        return this.httpFailedQueue.size();
    }

    private float avg(LinkedList<Integer> linkedList) {
        if (linkedList.isEmpty()) {
            return 0.0f;
        }
        int sum = (Integer)linkedList.stream().reduce(Integer::sum).get();
        return (float)sum / (float)linkedList.size();
    }
}

