/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.common.utils;

public class MQUtil {
    public static boolean isPatternTopic(String topic) {
        return !topic.matches("^[0-9a-z:/-]+$");
    }

    public static boolean checkTopic(String topic) {
        return topic.matches("^[0-9a-z:/.*-]+$");
    }

    public static boolean checkTag(String tag) {
        return tag.matches("^[0-9a-zA-Z.*]+$");
    }

    public static boolean isPatternTag(String tag) {
        return !tag.matches("^[0-9a-zA-Z]+$");
    }

    public static void checkTopicWithErr(String ... topics) {
        if (null == topics || 0 == topics.length) {
            throw new NullPointerException("topic cannot null");
        }
        if (1 == topics.length) {
            boolean ok = MQUtil.checkTopic(topics[0]);
            if (ok) {
                return;
            }
            throw new RuntimeException("topic invalid: " + topics[0]);
        }
        for (String t : topics) {
            if (!MQUtil.checkTopic(t)) {
                throw new IllegalArgumentException("topic invalid: " + t);
            }
            if (!MQUtil.isPatternTopic(t)) continue;
            throw new RuntimeException("pattern topic cannot multi: " + t);
        }
    }

    public static void checkTagWithErr(String ... tags) {
        if (null == tags || 0 == tags.length) {
            return;
        }
        for (String t : tags) {
            if (!MQUtil.checkTag(t)) {
                throw new IllegalArgumentException("tag invalid: " + t);
            }
            if (!MQUtil.isPatternTag(t)) continue;
            throw new RuntimeException("pattern tag cannot multi: " + t);
        }
    }
}

