/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.HTTP2Stream;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject
public abstract class AbstractFlowControlStrategy
implements FlowControlStrategy,
Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFlowControlStrategy.class);
    private final AtomicLong sessionStall = new AtomicLong();
    private final AtomicLong sessionStallTime = new AtomicLong();
    private final Map<Stream, Long> streamsStalls = new ConcurrentHashMap<Stream, Long>();
    private final AtomicLong streamsStallTime = new AtomicLong();
    private int initialStreamSendWindow;
    private int initialStreamRecvWindow;

    public AbstractFlowControlStrategy(int initialStreamSendWindow) {
        this.initialStreamSendWindow = initialStreamSendWindow;
        this.initialStreamRecvWindow = 65535;
    }

    @ManagedAttribute(value="The initial size of stream's flow control send window", readonly=true)
    public int getInitialStreamSendWindow() {
        return this.initialStreamSendWindow;
    }

    @ManagedAttribute(value="The initial size of stream's flow control receive window", readonly=true)
    public int getInitialStreamRecvWindow() {
        return this.initialStreamRecvWindow;
    }

    @Override
    public void onStreamCreated(Stream stream) {
        this.updateSendWindow(stream, this.getInitialStreamSendWindow());
        this.updateRecvWindow(stream, this.getInitialStreamRecvWindow());
    }

    @Override
    public void onStreamDestroyed(Stream stream) {
        this.streamsStalls.remove(stream);
    }

    @Override
    public void updateInitialStreamWindow(Session session, int initialStreamWindow, boolean local) {
        int previousInitialStreamWindow;
        if (local) {
            previousInitialStreamWindow = this.getInitialStreamRecvWindow();
            this.initialStreamRecvWindow = initialStreamWindow;
        } else {
            previousInitialStreamWindow = this.getInitialStreamSendWindow();
            this.initialStreamSendWindow = initialStreamWindow;
        }
        int delta = initialStreamWindow - previousInitialStreamWindow;
        if (delta == 0) {
            return;
        }
        for (Stream stream : session.getStreams()) {
            if (local) {
                this.updateRecvWindow(stream, delta);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Updated initial stream recv window {} -> {} for {}", new Object[]{previousInitialStreamWindow, initialStreamWindow, stream});
                continue;
            }
            this.updateWindow(session, stream, new WindowUpdateFrame(stream.getId(), delta));
        }
    }

    @Override
    public void onWindowUpdate(Session session, Stream stream, WindowUpdateFrame frame) {
        int delta = frame.getWindowDelta();
        if (frame.getStreamId() > 0) {
            if (stream != null) {
                int oldSize = this.updateSendWindow(stream, delta);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updated stream send window {} -> {} for {}", new Object[]{oldSize, oldSize + delta, stream});
                }
                if (oldSize <= 0) {
                    this.onStreamUnstalled(stream);
                }
            }
        } else {
            int oldSize = this.updateSendWindow(session, delta);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated session send window {} -> {} for {}", new Object[]{oldSize, oldSize + delta, session});
            }
            if (oldSize <= 0) {
                this.onSessionUnstalled(session);
            }
        }
    }

    @Override
    public void onDataReceived(Session session, Stream stream, int length) {
        int oldSize = this.updateRecvWindow(session, -length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Data received, {} bytes, updated session recv window {} -> {} for {}", new Object[]{length, oldSize, oldSize - length, session});
        }
        if (stream != null) {
            oldSize = this.updateRecvWindow(stream, -length);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Data received, {} bytes, updated stream recv window {} -> {} for {}", new Object[]{length, oldSize, oldSize - length, stream});
            }
        }
    }

    @Override
    public void windowUpdate(Session session, Stream stream, WindowUpdateFrame frame) {
    }

    @Override
    public void onDataSending(Stream stream, int length) {
        if (length == 0) {
            return;
        }
        Session session = stream.getSession();
        int oldSessionWindow = this.updateSendWindow(session, -length);
        int newSessionWindow = oldSessionWindow - length;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending, session send window {} -> {} for {}", new Object[]{oldSessionWindow, newSessionWindow, session});
        }
        if (newSessionWindow <= 0) {
            this.onSessionStalled(session);
        }
        int oldStreamWindow = this.updateSendWindow(stream, -length);
        int newStreamWindow = oldStreamWindow - length;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending, stream send window {} -> {} for {}", new Object[]{oldStreamWindow, newStreamWindow, stream});
        }
        if (newStreamWindow <= 0) {
            this.onStreamStalled(stream);
        }
    }

    @Override
    public void onDataSent(Stream stream, int length) {
    }

    protected void updateWindow(Session session, Stream stream, WindowUpdateFrame frame) {
        ((HTTP2Session)session).onWindowUpdate((HTTP2Stream)stream, frame);
    }

    protected int updateRecvWindow(Session session, int value) {
        return ((HTTP2Session)session).updateRecvWindow(value);
    }

    protected int updateSendWindow(Session session, int value) {
        return ((HTTP2Session)session).updateSendWindow(value);
    }

    protected int updateRecvWindow(Stream stream, int value) {
        return ((HTTP2Stream)stream).updateRecvWindow(value);
    }

    protected int updateSendWindow(Stream stream, int value) {
        return ((HTTP2Stream)stream).updateSendWindow(value);
    }

    protected void sendWindowUpdate(Session session, Stream stream, List<WindowUpdateFrame> frames) {
        ((HTTP2Session)session).frames((HTTP2Stream)stream, frames, Callback.NOOP);
    }

    protected void onSessionStalled(Session session) {
        this.sessionStall.set(NanoTime.now());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session stalled {}", (Object)session);
        }
    }

    protected void onStreamStalled(Stream stream) {
        this.streamsStalls.put(stream, NanoTime.now());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stream stalled {}", (Object)stream);
        }
    }

    protected void onSessionUnstalled(Session session) {
        long stallTime = NanoTime.since(this.sessionStall.getAndSet(0L));
        this.sessionStallTime.addAndGet(stallTime);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session unstalled after {} ms {}", (Object)TimeUnit.NANOSECONDS.toMillis(stallTime), (Object)session);
        }
    }

    protected void onStreamUnstalled(Stream stream) {
        Long time = this.streamsStalls.remove(stream);
        if (time != null) {
            long stallTime = NanoTime.since(time);
            this.streamsStallTime.addAndGet(stallTime);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream unstalled after {} ms {}", (Object)TimeUnit.NANOSECONDS.toMillis(stallTime), (Object)stream);
            }
        }
    }

    @ManagedAttribute(value="The time, in milliseconds, that the session flow control has stalled", readonly=true)
    public long getSessionStallTime() {
        long pastStallTime = this.sessionStallTime.get();
        long currentStallTime = this.sessionStall.get();
        if (currentStallTime != 0L) {
            currentStallTime = NanoTime.since(currentStallTime);
        }
        return TimeUnit.NANOSECONDS.toMillis(pastStallTime + currentStallTime);
    }

    @ManagedAttribute(value="The time, in milliseconds, that the streams flow control has stalled", readonly=true)
    public long getStreamsStallTime() {
        long pastStallTime = this.streamsStallTime.get();
        long now = NanoTime.now();
        long currentStallTime = this.streamsStalls.values().stream().reduce(0L, (result, time) -> NanoTime.elapsed(time, now));
        return TimeUnit.NANOSECONDS.toMillis(pastStallTime + currentStallTime);
    }

    @ManagedOperation(value="Resets the statistics", impact="ACTION")
    public void reset() {
        this.sessionStallTime.set(0L);
        this.streamsStallTime.set(0L);
    }

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        out.append(this.toString()).append(System.lineSeparator());
    }
}

