/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.util.ArrayList;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.LineStringExtracter;
import org.locationtech.jts.operation.polygonize.Polygonizer;

public class SplitOperation {
    private final Geometry geom;
    private final Geometry blade;

    public SplitOperation(Geometry geom, Geometry blade) {
        this.geom = geom;
        this.blade = blade;
    }

    public Geometry split() {
        if (this.geom instanceof LineString && this.blade instanceof Point) {
            return SplitOperation.split((LineString)this.geom, (Point)this.blade);
        }
        if (this.geom instanceof LineString && this.blade instanceof LineString) {
            return SplitOperation.split((LineString)this.geom, (LineString)this.blade);
        }
        if (this.geom instanceof MultiLineString && this.blade instanceof Point) {
            return SplitOperation.split((MultiLineString)this.geom, (Point)this.blade);
        }
        if (this.geom instanceof MultiLineString && this.blade instanceof LineString) {
            return SplitOperation.split((MultiLineString)this.geom, (LineString)this.blade);
        }
        if (this.geom instanceof Polygon && this.blade instanceof LineString) {
            return SplitOperation.split((Polygon)this.geom, (LineString)this.blade);
        }
        if (this.geom instanceof MultiPolygon && this.blade instanceof LineString) {
            return SplitOperation.split((MultiPolygon)this.geom, (LineString)this.blade);
        }
        throw new UnsupportedOperationException("Split operation not supported for " + this.geom.getGeometryType() + " and " + this.blade.getGeometryType());
    }

    private static Geometry split(LineString geometry, Point blade) {
        GeometryFactory factory = geometry.getFactory();
        Coordinate[] coordinates = geometry.getCoordinates();
        RobustLineIntersector intersector = new RobustLineIntersector();
        Coordinate p = blade.getCoordinate();
        ArrayList<Coordinate> accumulator = new ArrayList<Coordinate>();
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (int i = 1; i < coordinates.length; ++i) {
            Coordinate p1 = coordinates[i - 1];
            Coordinate p2 = coordinates[i];
            accumulator.add(p1.copy());
            ((LineIntersector)intersector).computeIntersection(p, p1, p2);
            if (!intersector.hasIntersection()) continue;
            accumulator.add(p.copy());
            LineString line = factory.createLineString(accumulator.toArray(new Coordinate[0]));
            lines.add(line);
            accumulator.clear();
            accumulator.add(p.copy());
        }
        accumulator.add(coordinates[coordinates.length - 1].copy());
        LineString line = factory.createLineString(accumulator.toArray(new Coordinate[0]));
        lines.add(line);
        if (lines.size() == 1) {
            return (Geometry)lines.get(0);
        }
        return factory.buildGeometry(lines);
    }

    private static Geometry split(MultiLineString geometry, Point blade) {
        GeometryFactory factory = geometry.getFactory();
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry split = SplitOperation.split((LineString)geometry.getGeometryN(i), blade);
            if (split instanceof GeometryCollection) {
                for (int j = 0; j < split.getNumGeometries(); ++j) {
                    geometries.add(split.getGeometryN(j));
                }
                continue;
            }
            geometries.add(split);
        }
        return factory.buildGeometry(geometries);
    }

    private static Geometry split(LineString geometry, LineString blade) {
        return geometry.difference(blade);
    }

    private static Geometry split(MultiLineString geometry, LineString blade) {
        return geometry.difference(blade);
    }

    private static Geometry split(Polygon geometry, LineString blade) {
        GeometryFactory factory = geometry.getFactory();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        Geometry union = geometry.getBoundary().union(blade);
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(LineStringExtracter.getLines(union));
        for (Polygon p : GeometryFactory.toPolygonArray(polygonizer.getPolygons())) {
            if (!geometry.contains(geometry.getInteriorPoint())) continue;
            p.normalize();
            polygons.add(p);
        }
        return factory.buildGeometry(polygons);
    }

    private static Geometry split(MultiPolygon geometry, LineString blade) {
        GeometryFactory factory = geometry.getFactory();
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry split = SplitOperation.split((Polygon)geometry.getGeometryN(i), blade);
            if (split instanceof GeometryCollection) {
                for (int j = 0; j < split.getNumGeometries(); ++j) {
                    geometries.add(split.getGeometryN(j));
                }
                continue;
            }
            geometries.add(split);
        }
        return factory.buildGeometry(geometries);
    }
}

