/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.connectors;

import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperatorFactory;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.ExternalCatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.connector.RowLevelModificationScanContext;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsBucketing;
import org.apache.flink.table.connector.sink.abilities.SupportsOverwrite;
import org.apache.flink.table.connector.sink.abilities.SupportsPartitioning;
import org.apache.flink.table.connector.sink.abilities.SupportsRowLevelDelete;
import org.apache.flink.table.connector.sink.abilities.SupportsRowLevelUpdate;
import org.apache.flink.table.connector.sink.abilities.SupportsTargetColumnWriting;
import org.apache.flink.table.connector.sink.abilities.SupportsWritingMetadata;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.operations.CollectModifyOperation;
import org.apache.flink.table.operations.ExternalModifyOperation;
import org.apache.flink.table.operations.SinkModifyOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.connectors.CollectDynamicSink;
import org.apache.flink.table.planner.connectors.DynamicSourceUtils;
import org.apache.flink.table.planner.connectors.ExternalDynamicSink;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.plan.abilities.sink.BucketingSpec;
import org.apache.flink.table.planner.plan.abilities.sink.OverwriteSpec;
import org.apache.flink.table.planner.plan.abilities.sink.RowLevelDeleteSpec;
import org.apache.flink.table.planner.plan.abilities.sink.RowLevelUpdateSpec;
import org.apache.flink.table.planner.plan.abilities.sink.SinkAbilitySpec;
import org.apache.flink.table.planner.plan.abilities.sink.TargetColumnWritingSpec;
import org.apache.flink.table.planner.plan.abilities.sink.WritingMetadataSpec;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalSink;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.utils.RowLevelModificationContextUtils;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.inference.TypeTransformations;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public final class DynamicSinkUtils {
    public static RelNode convertCollectToRel(FlinkRelBuilder relBuilder, RelNode input, CollectModifyOperation collectModifyOperation, ReadableConfig configuration, ClassLoader classLoader) {
        DataTypeFactory dataTypeFactory = ShortcutUtils.unwrapContext(relBuilder).getCatalogManager().getDataTypeFactory();
        ResolvedSchema childSchema = collectModifyOperation.getChild().getResolvedSchema();
        ResolvedSchema schema = ResolvedSchema.physical((List)childSchema.getColumnNames(), (List)childSchema.getColumnDataTypes());
        ResolvedCatalogTable catalogTable = new ResolvedCatalogTable((CatalogTable)new ExternalCatalogTable(Schema.newBuilder().fromResolvedSchema(schema).build()), schema);
        ContextResolvedTable contextResolvedTable = ContextResolvedTable.anonymous((String)"collect", (ResolvedCatalogBaseTable)catalogTable);
        DataType consumedDataType = DynamicSinkUtils.deriveCollectDataType(dataTypeFactory, schema);
        String zone = (String)configuration.get(TableConfigOptions.LOCAL_TIME_ZONE);
        ZoneId zoneId = ((String)TableConfigOptions.LOCAL_TIME_ZONE.defaultValue()).equals(zone) ? ZoneId.systemDefault() : ZoneId.of(zone);
        CollectDynamicSink tableSink = new CollectDynamicSink(contextResolvedTable.getIdentifier(), consumedDataType, (MemorySize)configuration.get(CollectSinkOperatorFactory.MAX_BATCH_SIZE), (Duration)configuration.get(CollectSinkOperatorFactory.SOCKET_TIMEOUT), classLoader, zoneId, ((ExecutionConfigOptions.LegacyCastBehaviour)configuration.get(ExecutionConfigOptions.TABLE_EXEC_LEGACY_CAST_BEHAVIOUR)).isEnabled(), configuration);
        collectModifyOperation.setSelectResultProvider(tableSink.getSelectResultProvider());
        collectModifyOperation.setConsumedDataType(consumedDataType);
        return DynamicSinkUtils.convertSinkToRel(relBuilder, input, Collections.emptyMap(), contextResolvedTable, Collections.emptyMap(), null, false, tableSink);
    }

    public static RelNode convertExternalToRel(FlinkRelBuilder relBuilder, RelNode input, ExternalModifyOperation externalModifyOperation) {
        ExternalDynamicSink tableSink = new ExternalDynamicSink(externalModifyOperation.getChangelogMode().orElse(null), externalModifyOperation.getPhysicalDataType());
        return DynamicSinkUtils.convertSinkToRel(relBuilder, input, Collections.emptyMap(), externalModifyOperation.getContextResolvedTable(), Collections.emptyMap(), null, false, tableSink);
    }

    public static RelNode convertSinkToRel(FlinkRelBuilder relBuilder, RelNode input, SinkModifyOperation sinkModifyOperation, DynamicTableSink sink) {
        return DynamicSinkUtils.convertSinkToRel(relBuilder, input, sinkModifyOperation.getDynamicOptions(), sinkModifyOperation.getContextResolvedTable(), sinkModifyOperation.getStaticPartitions(), sinkModifyOperation.getTargetColumns(), sinkModifyOperation.isOverwrite(), sink);
    }

    public static RelNode convertCreateTableAsToRel(FlinkRelBuilder relBuilder, RelNode input, Catalog catalog, CreateTableOperation createTableOperation, Map<String, String> staticPartitions, boolean isOverwrite, DynamicTableSink sink) {
        ResolvedCatalogTable catalogTable = createTableOperation.getCatalogTable();
        ObjectIdentifier identifier = createTableOperation.getTableIdentifier();
        ContextResolvedTable contextResolvedTable = createTableOperation.isTemporary() ? ContextResolvedTable.temporary((ObjectIdentifier)identifier, (ResolvedCatalogBaseTable)catalogTable) : ContextResolvedTable.permanent((ObjectIdentifier)identifier, (Catalog)catalog, (ResolvedCatalogBaseTable)catalogTable);
        return DynamicSinkUtils.convertSinkToRel(relBuilder, input, Collections.emptyMap(), contextResolvedTable, staticPartitions, null, isOverwrite, sink);
    }

    private static RelNode convertSinkToRel(FlinkRelBuilder relBuilder, RelNode input, Map<String, String> dynamicOptions, ContextResolvedTable contextResolvedTable, Map<String, String> staticPartitions, int[][] targetColumns, boolean isOverwrite, DynamicTableSink sink) {
        if (!dynamicOptions.isEmpty()) {
            contextResolvedTable = contextResolvedTable.copy(FlinkHints.mergeTableOptions(dynamicOptions, contextResolvedTable.getResolvedTable().getOptions()));
        }
        DataTypeFactory dataTypeFactory = ShortcutUtils.unwrapContext(relBuilder).getCatalogManager().getDataTypeFactory();
        FlinkTypeFactory typeFactory = ShortcutUtils.unwrapTypeFactory(relBuilder);
        ResolvedSchema schema = contextResolvedTable.getResolvedSchema();
        String tableDebugName = contextResolvedTable.getIdentifier().asSummaryString();
        ArrayList<SinkAbilitySpec> sinkAbilitySpecs = new ArrayList<SinkAbilitySpec>();
        boolean isDelete = false;
        boolean isUpdate = false;
        if (input instanceof LogicalTableModify) {
            LogicalTableModify tableModify = (LogicalTableModify)input;
            isDelete = tableModify.getOperation() == TableModify.Operation.DELETE;
            isUpdate = tableModify.getOperation() == TableModify.Operation.UPDATE;
        }
        DynamicSinkUtils.prepareDynamicSink(tableDebugName, staticPartitions, isOverwrite, sink, (ResolvedCatalogTable)contextResolvedTable.getResolvedTable(), sinkAbilitySpecs, targetColumns);
        if (isDelete) {
            input = DynamicSinkUtils.convertDelete((LogicalTableModify)input, sink, contextResolvedTable, tableDebugName, dataTypeFactory, typeFactory, sinkAbilitySpecs);
        } else if (isUpdate) {
            input = DynamicSinkUtils.convertUpdate((LogicalTableModify)input, sink, contextResolvedTable, tableDebugName, dataTypeFactory, typeFactory, sinkAbilitySpecs);
        }
        sinkAbilitySpecs.forEach(spec -> spec.apply(sink));
        RelNode query = input;
        if (!isDelete && !isUpdate) {
            query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(input, schema, tableDebugName, dataTypeFactory, typeFactory);
        }
        relBuilder.push(query);
        List<Integer> metadataColumns = DynamicSinkUtils.extractPersistedMetadataColumns(schema);
        if (!metadataColumns.isEmpty()) {
            DynamicSinkUtils.pushMetadataProjection(relBuilder, typeFactory, schema, sink);
        }
        ArrayList<RelHint> hints = new ArrayList<RelHint>();
        if (!dynamicOptions.isEmpty()) {
            hints.add(RelHint.builder("OPTIONS").hintOptions(dynamicOptions).build());
        }
        RelNode finalQuery = relBuilder.build();
        return LogicalSink.create(finalQuery, hints, contextResolvedTable, sink, staticPartitions, targetColumns, sinkAbilitySpecs.toArray(new SinkAbilitySpec[0]));
    }

    public static RelNode validateSchemaAndApplyImplicitCast(RelNode query, ResolvedSchema sinkSchema, String tableDebugName, DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory) {
        RowType sinkType = (RowType)DynamicSinkUtils.fixSinkDataType(dataTypeFactory, sinkSchema.toSinkRowDataType()).getLogicalType();
        return DynamicSinkUtils.validateSchemaAndApplyImplicitCast(query, sinkType, tableDebugName, typeFactory);
    }

    public static RelNode validateSchemaAndApplyImplicitCast(RelNode query, List<DataType> targetTypes, String tableDebugName, DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory) {
        RowType sinkType = (RowType)DynamicSinkUtils.fixSinkDataType(dataTypeFactory, DataTypes.ROW((DataType[])targetTypes.toArray(new DataType[0]))).getLogicalType();
        return DynamicSinkUtils.validateSchemaAndApplyImplicitCast(query, sinkType, tableDebugName, typeFactory);
    }

    private static RelNode validateSchemaAndApplyImplicitCast(RelNode query, RowType sinkType, String tableDebugName, FlinkTypeFactory typeFactory) {
        RowType queryType = FlinkTypeFactory.toLogicalRowType(query.getRowType());
        List queryFields = queryType.getFields();
        List sinkFields = sinkType.getFields();
        if (queryFields.size() != sinkFields.size()) {
            throw DynamicSinkUtils.createSchemaMismatchException("Different number of columns.", tableDebugName, queryFields, sinkFields);
        }
        boolean requiresCasting = false;
        for (int i = 0; i < sinkFields.size(); ++i) {
            LogicalType sinkColumnType;
            LogicalType queryColumnType = ((RowType.RowField)queryFields.get(i)).getType();
            if (!LogicalTypeCasts.supportsImplicitCast((LogicalType)queryColumnType, (LogicalType)(sinkColumnType = ((RowType.RowField)sinkFields.get(i)).getType()))) {
                throw DynamicSinkUtils.createSchemaMismatchException(String.format("Incompatible types for sink column '%s' at position %s.", ((RowType.RowField)sinkFields.get(i)).getName(), i), tableDebugName, queryFields, sinkFields);
            }
            if (LogicalTypeCasts.supportsAvoidingCast((LogicalType)queryColumnType, (LogicalType)sinkColumnType)) continue;
            requiresCasting = true;
        }
        if (requiresCasting) {
            RelDataType castRelDataType = typeFactory.buildRelNodeRowType(sinkType);
            return RelOptUtil.createCastRel(query, castRelDataType, true);
        }
        return query;
    }

    private static RelNode convertDelete(LogicalTableModify tableModify, DynamicTableSink sink, ContextResolvedTable contextResolvedTable, String tableDebugName, DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory, List<SinkAbilitySpec> sinkAbilitySpecs) {
        if (!(sink instanceof SupportsRowLevelDelete)) {
            throw new UnsupportedOperationException(String.format("Can't perform delete operation of the table %s because the corresponding dynamic table sink has not yet implemented %s.", tableDebugName, SupportsRowLevelDelete.class.getName()));
        }
        SupportsRowLevelDelete supportsRowLevelDelete = (SupportsRowLevelDelete)sink;
        RowLevelModificationScanContext context = RowLevelModificationContextUtils.getScanContext();
        SupportsRowLevelDelete.RowLevelDeleteInfo rowLevelDeleteInfo = supportsRowLevelDelete.applyRowLevelDelete(context);
        if (rowLevelDeleteInfo.getRowLevelDeleteMode() != SupportsRowLevelDelete.RowLevelDeleteMode.DELETED_ROWS && rowLevelDeleteInfo.getRowLevelDeleteMode() != SupportsRowLevelDelete.RowLevelDeleteMode.REMAINING_ROWS) {
            throw new TableException("Unknown delete mode: " + String.valueOf(rowLevelDeleteInfo.getRowLevelDeleteMode()));
        }
        if (rowLevelDeleteInfo.getRowLevelDeleteMode() == SupportsRowLevelDelete.RowLevelDeleteMode.REMAINING_ROWS) {
            DynamicSinkUtils.convertPredicateToNegative(tableModify);
        }
        Tuple2<RelNode, int[]> deleteRelNodeAndRequireIndices = DynamicSinkUtils.convertToRowLevelDelete(tableModify, contextResolvedTable, rowLevelDeleteInfo, tableDebugName, dataTypeFactory, typeFactory);
        sinkAbilitySpecs.add(new RowLevelDeleteSpec(rowLevelDeleteInfo.getRowLevelDeleteMode(), context, (int[])deleteRelNodeAndRequireIndices.f1));
        return (RelNode)deleteRelNodeAndRequireIndices.f0;
    }

    private static RelNode convertUpdate(LogicalTableModify tableModify, DynamicTableSink sink, ContextResolvedTable contextResolvedTable, String tableDebugName, DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory, List<SinkAbilitySpec> sinkAbilitySpecs) {
        RowLevelModificationScanContext context;
        if (!(sink instanceof SupportsRowLevelUpdate)) {
            throw new UnsupportedOperationException(String.format("Can't perform update operation of the table %s because the corresponding dynamic table sink has not yet implemented %s.", tableDebugName, SupportsRowLevelUpdate.class.getName()));
        }
        SupportsRowLevelUpdate supportsRowLevelUpdate = (SupportsRowLevelUpdate)sink;
        ResolvedSchema resolvedSchema = contextResolvedTable.getResolvedSchema();
        List<Column> updatedColumns = DynamicSinkUtils.getUpdatedColumns(tableModify, resolvedSchema);
        SupportsRowLevelUpdate.RowLevelUpdateInfo updateInfo = supportsRowLevelUpdate.applyRowLevelUpdate(updatedColumns, context = RowLevelModificationContextUtils.getScanContext());
        if (updateInfo.getRowLevelUpdateMode() != SupportsRowLevelUpdate.RowLevelUpdateMode.UPDATED_ROWS && updateInfo.getRowLevelUpdateMode() != SupportsRowLevelUpdate.RowLevelUpdateMode.ALL_ROWS) {
            throw new IllegalArgumentException("Unknown update mode:" + String.valueOf(updateInfo.getRowLevelUpdateMode()));
        }
        Tuple2<RelNode, int[]> updateRelNodeAndRequireIndices = DynamicSinkUtils.convertToRowLevelUpdate(tableModify, contextResolvedTable, updateInfo, tableDebugName, dataTypeFactory, typeFactory);
        sinkAbilitySpecs.add(new RowLevelUpdateSpec(updatedColumns, updateInfo.getRowLevelUpdateMode(), context, (int[])updateRelNodeAndRequireIndices.f1));
        return (RelNode)updateRelNodeAndRequireIndices.f0;
    }

    private static List<Column> getUpdatedColumns(LogicalTableModify tableModify, ResolvedSchema resolvedSchema) {
        ArrayList<Column> updatedColumns = new ArrayList<Column>();
        List<String> updatedColumnNames = tableModify.getUpdateColumnList();
        for (Column column : resolvedSchema.getColumns()) {
            if (!updatedColumnNames.contains(column.getName())) continue;
            updatedColumns.add(column);
        }
        return updatedColumns;
    }

    private static Tuple2<RelNode, int[]> convertToRowLevelDelete(LogicalTableModify tableModify, ContextResolvedTable contextResolvedTable, SupportsRowLevelDelete.RowLevelDeleteInfo rowLevelDeleteInfo, String tableDebugName, DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory) {
        ResolvedSchema resolvedSchema = contextResolvedTable.getResolvedSchema();
        Optional optionalColumns = rowLevelDeleteInfo.requiredColumns();
        List requiredColumns = optionalColumns.orElse(resolvedSchema.getColumns());
        LogicalTableScan tableScan = DynamicSinkUtils.getSourceTableScan(tableModify);
        Tuple2<List<Integer>, List<Column.MetadataColumn>> colsIndexAndExtraMetaCols = DynamicSinkUtils.getRequireColumnsIndexAndExtraMetaCols(tableScan, requiredColumns, resolvedSchema);
        List colIndexes = (List)colsIndexAndExtraMetaCols.f0;
        List metadataColumns = (List)colsIndexAndExtraMetaCols.f1;
        if (metadataColumns.size() > 0) {
            resolvedSchema = DynamicSinkUtils.addExtraMetaCols(tableModify, tableScan, tableDebugName, metadataColumns, typeFactory);
        }
        return Tuple2.of((Object)DynamicSinkUtils.projectColumnsForDelete(tableModify, resolvedSchema, colIndexes, tableDebugName, dataTypeFactory, typeFactory), (Object)DynamicSinkUtils.getPhysicalColumnIndices(colIndexes, resolvedSchema));
    }

    private static int[] getPhysicalColumnIndices(List<Integer> colIndexes, ResolvedSchema schema) {
        return colIndexes.stream().filter(i -> ((Column)schema.getColumns().get((int)i)).isPhysical()).mapToInt(i -> i).toArray();
    }

    private static void convertPredicateToNegative(LogicalTableModify tableModify) {
        LogicalFilter newFilter;
        RexBuilder rexBuilder = tableModify.getCluster().getRexBuilder();
        RelNode input = tableModify.getInput();
        if (input.getInput(0) instanceof LogicalTableScan) {
            newFilter = LogicalFilter.create(input.getInput(0), rexBuilder.makeLiteral(false));
        } else {
            LogicalFilter filter = (LogicalFilter)input.getInput(0);
            RexNode complementFilter = rexBuilder.makeCall(filter.getCondition().getType(), FlinkSqlOperatorTable.NOT, Collections.singletonList(filter.getCondition()));
            newFilter = filter.copy(filter.getTraitSet(), filter.getInput(), complementFilter);
        }
        input.replaceInput(0, newFilter);
    }

    private static Tuple2<List<Integer>, List<Column.MetadataColumn>> getRequireColumnsIndexAndExtraMetaCols(LogicalTableScan tableScan, List<Column> requiredColumns, ResolvedSchema resolvedSchema) {
        ArrayList<Integer> columnIndexList = new ArrayList<Integer>();
        ArrayList<Column.MetadataColumn> extraMetadataColumns = new ArrayList<Column.MetadataColumn>();
        List fieldNames = resolvedSchema.getColumnNames();
        TableSourceTable sourceTable = tableScan.getTable().unwrap(TableSourceTable.class);
        DynamicTableSource dynamicTableSource = sourceTable.tableSource();
        int additionCols = 0;
        for (Column column : requiredColumns) {
            int index = fieldNames.indexOf(column.getName());
            if (index <= -1) {
                if (column instanceof Column.MetadataColumn) {
                    String metaCol;
                    columnIndexList.add(fieldNames.size() + additionCols);
                    if (!(dynamicTableSource instanceof SupportsReadingMetadata)) {
                        throw new UnsupportedOperationException(String.format("The table source don't support reading metadata, but the require columns contains the meta columns: %s.", column));
                    }
                    SupportsReadingMetadata supportsReadingMetadata = (SupportsReadingMetadata)dynamicTableSource;
                    Map readableMetadata = supportsReadingMetadata.listReadableMetadata();
                    if (!readableMetadata.containsKey(metaCol = ((Column.MetadataColumn)column).getMetadataKey().orElse(column.getName()))) {
                        throw new IllegalArgumentException(String.format("Expect to read the meta column %s, but the table source for table %s doesn't support read the metadata column.Please make sure the readable metadata for the source contains %s.", column, UnresolvedIdentifier.of(tableScan.getTable().getQualifiedName()), metaCol));
                    }
                    ++additionCols;
                    DataType dataType = (DataType)readableMetadata.get(metaCol);
                    if (!dataType.equals((Object)column.getDataType())) {
                        throw new IllegalArgumentException(String.format("Un-matched data type: the required column %s has datatype %s, but the data type in readable metadata for the table %s has data type %s. ", column, column.getDataType(), UnresolvedIdentifier.of(tableScan.getTable().getQualifiedName()), dataType));
                    }
                    extraMetadataColumns.add((Column.MetadataColumn)column);
                    continue;
                }
                throw new IllegalArgumentException("Unknown required column " + String.valueOf(column));
            }
            columnIndexList.add(index);
        }
        return Tuple2.of(columnIndexList, extraMetadataColumns);
    }

    private static LogicalTableScan getSourceTableScan(RelNode relNode) {
        while (!(relNode instanceof LogicalTableScan)) {
            relNode = relNode.getInput(0);
        }
        return (LogicalTableScan)relNode;
    }

    private static Tuple2<RelNode, int[]> convertToRowLevelUpdate(LogicalTableModify tableModify, ContextResolvedTable contextResolvedTable, SupportsRowLevelUpdate.RowLevelUpdateInfo rowLevelUpdateInfo, String tableDebugName, DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory) {
        ResolvedSchema resolvedSchema = contextResolvedTable.getResolvedSchema();
        Optional optionalColumns = rowLevelUpdateInfo.requiredColumns();
        List requiredColumns = optionalColumns.orElse(resolvedSchema.getColumns());
        LogicalTableScan tableScan = DynamicSinkUtils.getSourceTableScan(tableModify);
        Tuple2<List<Integer>, List<Column.MetadataColumn>> colsIndexAndExtraMetaCols = DynamicSinkUtils.getRequireColumnsIndexAndExtraMetaCols(tableScan, requiredColumns, resolvedSchema);
        List colIndexes = (List)colsIndexAndExtraMetaCols.f0;
        List metadataColumns = (List)colsIndexAndExtraMetaCols.f1;
        int originColsCount = resolvedSchema.getColumnCount();
        if (metadataColumns.size() > 0) {
            resolvedSchema = DynamicSinkUtils.addExtraMetaCols(tableModify, tableScan, tableDebugName, metadataColumns, typeFactory);
        }
        return Tuple2.of((Object)DynamicSinkUtils.projectColumnsForUpdate(tableModify, originColsCount, resolvedSchema, colIndexes, rowLevelUpdateInfo.getRowLevelUpdateMode(), tableDebugName, dataTypeFactory, typeFactory), (Object)DynamicSinkUtils.getPhysicalColumnIndices(colIndexes, resolvedSchema));
    }

    private static RelNode projectColumnsForUpdate(LogicalTableModify tableModify, int originColsCount, ResolvedSchema resolvedSchema, List<Integer> updatedIndexes, SupportsRowLevelUpdate.RowLevelUpdateMode updateMode, String tableDebugName, DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory) {
        RexBuilder rexBuilder = tableModify.getCluster().getRexBuilder();
        List<String> updatedColumnNames = tableModify.getUpdateColumnList();
        ArrayList<RexNode> newRexNodeList = new ArrayList<RexNode>();
        ArrayList<String> newFieldNames = new ArrayList<String>();
        ArrayList<DataType> updateTargetDataTypes = new ArrayList<DataType>();
        Project project = (Project)tableModify.getInput();
        LogicalFilter filter = null;
        if (updateMode == SupportsRowLevelUpdate.RowLevelUpdateMode.ALL_ROWS && project.getInput() instanceof LogicalFilter) {
            filter = (LogicalFilter)project.getInput();
        }
        List<RexNode> oldRexNodes = project.getProjects();
        for (int index : updatedIndexes) {
            String colName = (String)resolvedSchema.getColumnNames().get(index);
            if (updatedColumnNames.contains(colName)) {
                int i = updatedColumnNames.indexOf(colName);
                RexNode rexNode = oldRexNodes.get(originColsCount + i);
                if (filter != null) {
                    rexNode = rexBuilder.makeCall((SqlOperator)FlinkSqlOperatorTable.IF, Arrays.asList(filter.getCondition(), rexNode, rexBuilder.makeInputRef(project.getInput(), index)));
                }
                newRexNodeList.add(rexNode);
            } else {
                newRexNodeList.add(rexBuilder.makeInputRef(project.getInput(), index));
            }
            newFieldNames.add(colName);
            updateTargetDataTypes.add((DataType)resolvedSchema.getColumnDataTypes().get(index));
        }
        project = project.copy(project.getTraitSet(), filter != null ? filter.getInput() : project.getInput(), newRexNodeList, RexUtil.createStructType(typeFactory, newRexNodeList, newFieldNames, null));
        return DynamicSinkUtils.validateSchemaAndApplyImplicitCast((RelNode)project, updateTargetDataTypes, tableDebugName, dataTypeFactory, typeFactory);
    }

    private static ResolvedSchema addExtraMetaCols(LogicalTableModify tableModify, LogicalTableScan tableScan, String tableDebugName, List<Column.MetadataColumn> metadataColumns, FlinkTypeFactory typeFactory) {
        TableSourceTable sourceTable = tableScan.getTable().unwrap(TableSourceTable.class);
        DynamicTableSource dynamicTableSource = sourceTable.tableSource();
        ResolvedSchema oldSchema = sourceTable.contextResolvedTable().getResolvedSchema();
        ArrayList<Column.MetadataColumn> newColumns = new ArrayList<Column.MetadataColumn>(oldSchema.getColumns());
        newColumns.addAll(metadataColumns);
        ResolvedSchema resolvedSchema = ResolvedSchema.of(newColumns);
        List<RelDataTypeField> oldFields = sourceTable.getRowType().getFieldList();
        ArrayList<RelDataTypeField> newFields = new ArrayList<RelDataTypeField>(sourceTable.getRowType().getFieldList());
        for (int i = 0; i < metadataColumns.size(); ++i) {
            Column.MetadataColumn column = metadataColumns.get(i);
            newFields.add(new RelDataTypeFieldImpl(column.getName(), oldFields.size() + i, typeFactory.createFieldTypeFromLogicalType(column.getDataType().getLogicalType())));
        }
        TableSourceTable newTableSourceTab = sourceTable.copy(dynamicTableSource, sourceTable.contextResolvedTable().copy(resolvedSchema), new RelRecordType(StructKind.FULLY_QUALIFIED, newFields, false), sourceTable.abilitySpecs());
        LogicalTableScan newTableScan = new LogicalTableScan(tableScan.getCluster(), tableScan.getTraitSet(), tableScan.getHints(), newTableSourceTab);
        Project project = (Project)tableModify.getInput();
        if (project.getInput() instanceof LogicalFilter) {
            LogicalFilter logicalFilter = (LogicalFilter)project.getInput();
            project.replaceInput(0, logicalFilter.copy(logicalFilter.getTraitSet(), newTableScan, logicalFilter.getCondition()));
        } else {
            project.replaceInput(0, newTableScan);
        }
        DynamicSourceUtils.validateAndApplyMetadata(tableDebugName, resolvedSchema, newTableSourceTab.tableSource(), new ArrayList<SourceAbilitySpec>());
        return resolvedSchema;
    }

    private static RelNode projectColumnsForDelete(LogicalTableModify tableModify, ResolvedSchema resolvedSchema, List<Integer> colIndexes, String tableDebugName, DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory) {
        ArrayList<RexNode> newRexNodeList = new ArrayList<RexNode>();
        ArrayList<String> newFieldNames = new ArrayList<String>();
        ArrayList<DataType> deleteTargetDataTypes = new ArrayList<DataType>();
        Project project = (Project)tableModify.getInput();
        RexBuilder rexBuilder = tableModify.getCluster().getRexBuilder();
        for (int index : colIndexes) {
            newRexNodeList.add(rexBuilder.makeInputRef(project.getInput(), index));
            newFieldNames.add((String)resolvedSchema.getColumnNames().get(index));
            deleteTargetDataTypes.add((DataType)resolvedSchema.getColumnDataTypes().get(index));
        }
        project = project.copy(project.getTraitSet(), project.getInput(), newRexNodeList, RexUtil.createStructType(typeFactory, newRexNodeList, newFieldNames, null));
        return DynamicSinkUtils.validateSchemaAndApplyImplicitCast((RelNode)project, deleteTargetDataTypes, tableDebugName, dataTypeFactory, typeFactory);
    }

    private static DataType deriveCollectDataType(DataTypeFactory dataTypeFactory, ResolvedSchema schema) {
        DataType fixedDataType = DataTypeUtils.transform((DataTypeFactory)dataTypeFactory, (DataType)schema.toSourceRowDataType(), (TypeTransformation[])new TypeTransformation[]{TypeTransformations.legacyRawToTypeInfoRaw(), TypeTransformations.legacyToNonLegacy()});
        DataType defaultDataType = TypeConversions.fromLogicalToDataType((LogicalType)fixedDataType.getLogicalType());
        return DataTypeUtils.alignStructuredTypes((DataTypeFactory)dataTypeFactory, (DataType)defaultDataType);
    }

    private static void pushMetadataProjection(FlinkRelBuilder relBuilder, FlinkTypeFactory typeFactory, ResolvedSchema schema, DynamicTableSink sink) {
        RexBuilder rexBuilder = relBuilder.getRexBuilder();
        List columns = schema.getColumns();
        List<Integer> physicalColumns = DynamicSinkUtils.extractPhysicalColumns(schema);
        Map keyToMetadataColumn = DynamicSinkUtils.extractPersistedMetadataColumns(schema).stream().collect(Collectors.toMap(pos -> {
            Column.MetadataColumn metadataColumn = (Column.MetadataColumn)columns.get((int)pos);
            return metadataColumn.getMetadataKey().orElse(metadataColumn.getName());
        }, Function.identity()));
        List metadataColumns = DynamicSinkUtils.createRequiredMetadataColumns(schema, sink).stream().map(col -> col.getMetadataKey().orElse(col.getName())).map(keyToMetadataColumn::get).collect(Collectors.toList());
        List fieldNames = Stream.concat(physicalColumns.stream().map(columns::get).map(Column::getName), metadataColumns.stream().map(columns::get).map(Column.MetadataColumn.class::cast).map(c -> c.getMetadataKey().orElse(c.getName()))).collect(Collectors.toList());
        Map<String, DataType> metadataMap = DynamicSinkUtils.extractMetadataMap(sink);
        List fieldNodes = Stream.concat(physicalColumns.stream().map(pos -> {
            int posAdjusted = DynamicSinkUtils.adjustByVirtualColumns(columns, pos);
            return relBuilder.field(posAdjusted);
        }), metadataColumns.stream().map(pos -> {
            Column.MetadataColumn metadataColumn = (Column.MetadataColumn)columns.get((int)pos);
            String metadataKey = metadataColumn.getMetadataKey().orElse(metadataColumn.getName());
            LogicalType expectedType = ((DataType)metadataMap.get(metadataKey)).getLogicalType();
            RelDataType expectedRelDataType = typeFactory.createFieldTypeFromLogicalType(expectedType);
            int posAdjusted = DynamicSinkUtils.adjustByVirtualColumns(columns, pos);
            return rexBuilder.makeAbstractCast(expectedRelDataType, relBuilder.field(posAdjusted));
        })).collect(Collectors.toList());
        relBuilder.projectNamed(fieldNodes, fieldNames, true);
    }

    private static void prepareDynamicSink(String tableDebugName, Map<String, String> staticPartitions, boolean isOverwrite, DynamicTableSink sink, ResolvedCatalogTable table, List<SinkAbilitySpec> sinkAbilitySpecs, int[][] targetColumns) {
        table.getDistribution().ifPresent(distribution -> DynamicSinkUtils.validateBucketing(tableDebugName, sink, distribution, sinkAbilitySpecs));
        DynamicSinkUtils.validatePartitioning(tableDebugName, staticPartitions, sink, table.getPartitionKeys());
        DynamicSinkUtils.validateAndApplyOverwrite(tableDebugName, isOverwrite, sink, sinkAbilitySpecs);
        DynamicSinkUtils.validateAndApplyMetadata(tableDebugName, sink, table.getResolvedSchema(), sinkAbilitySpecs);
        DynamicSinkUtils.validateAndApplyTargetColumns(sink, targetColumns, sinkAbilitySpecs);
    }

    private static List<Column.MetadataColumn> createRequiredMetadataColumns(ResolvedSchema schema, DynamicTableSink sink) {
        List tableColumns = schema.getColumns();
        List<Integer> metadataColumns = DynamicSinkUtils.extractPersistedMetadataColumns(schema);
        HashMap<String, Column.MetadataColumn> metadataKeysToMetadataColumns = new HashMap<String, Column.MetadataColumn>();
        for (Integer columnIndex : metadataColumns) {
            Column.MetadataColumn metadataColumn = (Column.MetadataColumn)tableColumns.get(columnIndex);
            String metadataKey = metadataColumn.getMetadataKey().orElse(metadataColumn.getName());
            metadataKeysToMetadataColumns.put(metadataKey, metadataColumn);
        }
        Map<String, DataType> metadataMap = DynamicSinkUtils.extractMetadataMap(sink);
        return metadataMap.keySet().stream().filter(metadataKeysToMetadataColumns::containsKey).map(metadataKeysToMetadataColumns::get).collect(Collectors.toList());
    }

    private static ValidationException createSchemaMismatchException(String cause, String tableDebugName, List<RowType.RowField> queryFields, List<RowType.RowField> sinkFields) {
        String querySchema = queryFields.stream().map(f -> f.getName() + ": " + f.getType().asSummaryString()).collect(Collectors.joining(", ", "[", "]"));
        String sinkSchema = sinkFields.stream().map(sinkField -> sinkField.getName() + ": " + sinkField.getType().asSummaryString()).collect(Collectors.joining(", ", "[", "]"));
        return new ValidationException(String.format("Column types of query result and sink for '%s' do not match.\nCause: %s\n\nQuery schema: %s\nSink schema:  %s", tableDebugName, cause, querySchema, sinkSchema));
    }

    private static DataType fixSinkDataType(DataTypeFactory dataTypeFactory, DataType sinkDataType) {
        return DataTypeUtils.transform((DataTypeFactory)dataTypeFactory, (DataType)sinkDataType, (TypeTransformation[])new TypeTransformation[]{TypeTransformations.legacyRawToTypeInfoRaw(), TypeTransformations.legacyToNonLegacy(), TypeTransformations.toNullable()});
    }

    private static void validateBucketing(String tableDebugName, DynamicTableSink sink, TableDistribution distribution, List<SinkAbilitySpec> sinkAbilitySpecs) {
        if (!(sink instanceof SupportsBucketing)) {
            throw new TableException(String.format("Table '%s' is distributed into buckets, but the underlying %s doesn't implement the %s interface.", tableDebugName, DynamicTableSink.class.getSimpleName(), SupportsBucketing.class.getSimpleName()));
        }
        SupportsBucketing sinkWithBucketing = (SupportsBucketing)sink;
        if (sinkWithBucketing.requiresBucketCount() && !distribution.getBucketCount().isPresent()) {
            throw new ValidationException(String.format("Table '%s' is a bucketed table, but the underlying %s requires the number of buckets to be set.", tableDebugName, DynamicTableSink.class.getSimpleName()));
        }
        if (!sinkWithBucketing.listAlgorithms().contains(distribution.getKind())) {
            if (distribution.getKind() == TableDistribution.Kind.UNKNOWN) {
                throw new ValidationException(String.format("Bucketed table '%s' must specify an algorithm. Supported algorithms: %s", tableDebugName, sinkWithBucketing.listAlgorithms().stream().map(Enum::toString).sorted().collect(Collectors.toList())));
            }
            throw new ValidationException(String.format("Table '%s' is a bucketed table and it supports %s, but algorithm %s was requested.", tableDebugName, sinkWithBucketing.listAlgorithms().stream().map(Enum::toString).sorted().collect(Collectors.toList()), distribution.getKind()));
        }
        sinkAbilitySpecs.add(new BucketingSpec());
    }

    private static void validatePartitioning(String tableDebugName, Map<String, String> staticPartitions, DynamicTableSink sink, List<String> partitionKeys) {
        if (!partitionKeys.isEmpty() && !(sink instanceof SupportsPartitioning)) {
            throw new TableException(String.format("Table '%s' is a partitioned table, but the underlying %s doesn't implement the %s interface.", tableDebugName, DynamicTableSink.class.getSimpleName(), SupportsPartitioning.class.getSimpleName()));
        }
        staticPartitions.keySet().forEach(p -> {
            if (!partitionKeys.contains(p)) {
                throw new ValidationException(String.format("Static partition column '%s' should be in the partition keys list %s for table '%s'.", p, partitionKeys, tableDebugName));
            }
        });
    }

    private static void validateAndApplyOverwrite(String tableDebugName, boolean isOverwrite, DynamicTableSink sink, List<SinkAbilitySpec> sinkAbilitySpecs) {
        if (!isOverwrite) {
            return;
        }
        if (!(sink instanceof SupportsOverwrite)) {
            throw new ValidationException(String.format("INSERT OVERWRITE requires that the underlying %s of table '%s' implements the %s interface.", DynamicTableSink.class.getSimpleName(), tableDebugName, SupportsOverwrite.class.getSimpleName()));
        }
        sinkAbilitySpecs.add(new OverwriteSpec(true));
    }

    private static List<Integer> extractPhysicalColumns(ResolvedSchema schema) {
        List columns = schema.getColumns();
        return IntStream.range(0, schema.getColumnCount()).filter(pos -> ((Column)columns.get(pos)).isPhysical()).boxed().collect(Collectors.toList());
    }

    private static List<Integer> extractPersistedMetadataColumns(ResolvedSchema schema) {
        List columns = schema.getColumns();
        return IntStream.range(0, schema.getColumnCount()).filter(pos -> {
            Column column = (Column)columns.get(pos);
            return column instanceof Column.MetadataColumn && column.isPersisted();
        }).boxed().collect(Collectors.toList());
    }

    private static int adjustByVirtualColumns(List<Column> columns, int pos) {
        return pos - (int)IntStream.range(0, pos).filter(i -> !((Column)columns.get(i)).isPersisted()).count();
    }

    private static Map<String, DataType> extractMetadataMap(DynamicTableSink sink) {
        if (sink instanceof SupportsWritingMetadata) {
            return ((SupportsWritingMetadata)sink).listWritableMetadata();
        }
        return Collections.emptyMap();
    }

    private static void validateAndApplyMetadata(String tableDebugName, DynamicTableSink sink, ResolvedSchema schema, List<SinkAbilitySpec> sinkAbilitySpecs) {
        List columns = schema.getColumns();
        List<Integer> metadataColumns = DynamicSinkUtils.extractPersistedMetadataColumns(schema);
        if (metadataColumns.isEmpty()) {
            return;
        }
        if (!(sink instanceof SupportsWritingMetadata)) {
            throw new ValidationException(String.format("Table '%s' declares persistable metadata columns, but the underlying %s doesn't implement the %s interface. If the column should not be persisted, it can be declared with the VIRTUAL keyword.", tableDebugName, DynamicTableSink.class.getSimpleName(), SupportsWritingMetadata.class.getSimpleName()));
        }
        Map metadataMap = ((SupportsWritingMetadata)sink).listWritableMetadata();
        metadataColumns.forEach(pos -> {
            Column.MetadataColumn metadataColumn = (Column.MetadataColumn)columns.get((int)pos);
            String metadataKey = metadataColumn.getMetadataKey().orElse(metadataColumn.getName());
            LogicalType metadataType = metadataColumn.getDataType().getLogicalType();
            DataType expectedMetadataDataType = (DataType)metadataMap.get(metadataKey);
            if (expectedMetadataDataType == null) {
                throw new ValidationException(String.format("Invalid metadata key '%s' in column '%s' of table '%s'. The %s class '%s' supports the following metadata keys for writing:\n%s", metadataKey, metadataColumn.getName(), tableDebugName, DynamicTableSink.class.getSimpleName(), sink.getClass().getName(), String.join((CharSequence)"\n", metadataMap.keySet())));
            }
            if (!LogicalTypeCasts.supportsExplicitCast((LogicalType)metadataType, (LogicalType)expectedMetadataDataType.getLogicalType())) {
                if (metadataKey.equals(metadataColumn.getName())) {
                    throw new ValidationException(String.format("Invalid data type for metadata column '%s' of table '%s'. The column cannot be declared as '%s' because the type must be castable to metadata type '%s'.", metadataColumn.getName(), tableDebugName, metadataType, expectedMetadataDataType.getLogicalType()));
                }
                throw new ValidationException(String.format("Invalid data type for metadata column '%s' with metadata key '%s' of table '%s'. The column cannot be declared as '%s' because the type must be castable to metadata type '%s'.", metadataColumn.getName(), metadataKey, tableDebugName, metadataType, expectedMetadataDataType.getLogicalType()));
            }
        });
        sinkAbilitySpecs.add(new WritingMetadataSpec(DynamicSinkUtils.createRequiredMetadataColumns(schema, sink).stream().map(col -> col.getMetadataKey().orElse(col.getName())).collect(Collectors.toList()), (LogicalType)DynamicSinkUtils.createConsumedType(schema, sink)));
    }

    private static void validateAndApplyTargetColumns(DynamicTableSink sink, int[][] targetColumns, List<SinkAbilitySpec> sinkAbilitySpecs) {
        if (targetColumns == null || targetColumns.length == 0) {
            return;
        }
        if (!(sink instanceof SupportsTargetColumnWriting)) {
            return;
        }
        sinkAbilitySpecs.add(new TargetColumnWritingSpec(targetColumns));
    }

    private static RowType createConsumedType(ResolvedSchema schema, DynamicTableSink sink) {
        Map<String, DataType> metadataMap = DynamicSinkUtils.extractMetadataMap(sink);
        Stream<RowType.RowField> physicalFields = schema.getColumns().stream().filter(Column::isPhysical).map(c -> new RowType.RowField(c.getName(), c.getDataType().getLogicalType()));
        Stream<RowType.RowField> metadataFields = DynamicSinkUtils.createRequiredMetadataColumns(schema, sink).stream().map(column -> new RowType.RowField(column.getName(), ((DataType)metadataMap.get(column.getMetadataKey().orElse(column.getName()))).getLogicalType()));
        List rowFields = Stream.concat(physicalFields, metadataFields).collect(Collectors.toList());
        return new RowType(false, rowFields);
    }

    private DynamicSinkUtils() {
    }
}

