/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.planner.expressions.ColumnReferenceFinder;
import org.apache.flink.table.utils.EncodingUtils;

public class SchemaReferencesManager {
    private final Set<String> columns;
    private final Map<String, Set<String>> columnToReferences;
    private final Map<String, Set<String>> columnToDependencies;
    private final Set<String> primaryKeys;
    private final Set<String> watermarkReferences;
    private final Set<String> partitionKeys;
    private final Set<String> distributionKeys;

    private SchemaReferencesManager(Set<String> columns, Map<String, Set<String>> columnToReferences, Map<String, Set<String>> columnToDependencies, Set<String> primaryKeys, Set<String> watermarkReferences, Set<String> partitionKeys, Set<String> distributionKeys) {
        this.columns = columns;
        this.columnToReferences = columnToReferences;
        this.columnToDependencies = columnToDependencies;
        this.primaryKeys = primaryKeys;
        this.watermarkReferences = watermarkReferences;
        this.partitionKeys = partitionKeys;
        this.distributionKeys = distributionKeys;
    }

    public static SchemaReferencesManager create(ResolvedCatalogTable catalogTable) {
        HashMap<String, Set<String>> columnToReferences = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> columnToDependencies = new HashMap<String, Set<String>>();
        catalogTable.getResolvedSchema().getColumns().stream().filter(column -> column instanceof Column.ComputedColumn).forEach(column -> {
            Set<String> referencedColumns = ColumnReferenceFinder.findReferencedColumn(column.getName(), catalogTable.getResolvedSchema());
            for (String referencedColumn : referencedColumns) {
                columnToReferences.computeIfAbsent(referencedColumn, key -> new HashSet()).add(column.getName());
                columnToDependencies.computeIfAbsent(column.getName(), key -> new HashSet()).add(referencedColumn);
            }
        });
        return new SchemaReferencesManager(new HashSet<String>(catalogTable.getResolvedSchema().getColumnNames()), columnToReferences, columnToDependencies, catalogTable.getResolvedSchema().getPrimaryKey().map(constraint -> new HashSet(constraint.getColumns())).orElse(new HashSet()), ColumnReferenceFinder.findWatermarkReferencedColumn(catalogTable.getResolvedSchema()), new HashSet<String>(catalogTable.getPartitionKeys()), new HashSet<String>(catalogTable.getDistribution().map(TableDistribution::getBucketKeys).orElse(List.of())));
    }

    public void dropColumn(String columnName, Supplier<String> errorMsg) {
        this.checkReferences(columnName, errorMsg);
        if (this.primaryKeys.contains(columnName)) {
            throw new ValidationException(String.format("%sThe column %s is used as the primary key.", errorMsg.get(), EncodingUtils.escapeIdentifier((String)columnName)));
        }
        this.columnToDependencies.getOrDefault(columnName, Set.of()).forEach(referredColumn -> this.columnToReferences.get(referredColumn).remove(columnName));
        this.columnToDependencies.remove(columnName);
        this.columns.remove(columnName);
    }

    public int getColumnDependencyCount(String columnName) {
        return this.columnToDependencies.getOrDefault(columnName, Set.of()).size();
    }

    public void checkReferences(String columnName, Supplier<String> errorMsg) {
        if (!this.columns.contains(columnName)) {
            throw new ValidationException(String.format("%sThe column `%s` does not exist in the base table.", errorMsg.get(), columnName));
        }
        if (this.columnToReferences.containsKey(columnName) && !this.columnToReferences.get(columnName).isEmpty()) {
            throw new ValidationException(String.format("%sThe column %s is referenced by computed column %s.", errorMsg.get(), EncodingUtils.escapeIdentifier((String)columnName), this.columnToReferences.get(columnName).stream().map(EncodingUtils::escapeIdentifier).sorted().collect(Collectors.joining(", "))));
        }
        if (this.partitionKeys.contains(columnName)) {
            throw new ValidationException(String.format("%sThe column `%s` is used as the partition keys.", errorMsg.get(), columnName));
        }
        if (this.watermarkReferences.contains(columnName)) {
            throw new ValidationException(String.format("%sThe column `%s` is referenced by watermark expression.", errorMsg.get(), columnName));
        }
        if (this.distributionKeys.contains(columnName)) {
            throw new ValidationException(String.format("%sThe column `%s` is used as a distribution key.", errorMsg.get(), columnName));
        }
    }

    public static void buildUpdatedColumn(Schema.Builder builder, ResolvedCatalogBaseTable<?> oldTable, BiConsumer<Schema.Builder, Schema.UnresolvedColumn> columnConsumer) {
        oldTable.getUnresolvedSchema().getColumns().forEach(column -> columnConsumer.accept(builder, (Schema.UnresolvedColumn)column));
    }

    public static void buildUpdatedWatermark(Schema.Builder builder, ResolvedCatalogBaseTable<?> oldTable) {
        oldTable.getUnresolvedSchema().getWatermarkSpecs().forEach(watermarkSpec -> builder.watermark(watermarkSpec.getColumnName(), watermarkSpec.getWatermarkExpression()));
    }

    public static void buildUpdatedPrimaryKey(Schema.Builder builder, ResolvedCatalogBaseTable<?> oldTable, Function<String, String> columnRenamer) {
        oldTable.getUnresolvedSchema().getPrimaryKey().ifPresent(pk -> {
            List oldPrimaryKeyNames = pk.getColumnNames();
            String constrainName = pk.getConstraintName();
            List newPrimaryKeyNames = oldPrimaryKeyNames.stream().map(columnRenamer).collect(Collectors.toList());
            builder.primaryKeyNamed(constrainName, newPrimaryKeyNames);
        });
    }
}

