/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream;

import java.util.Iterator;
import java.util.function.Function;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.operators.join.JoinConditionWithNullFilters;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinRecordStateView;
import org.apache.flink.table.runtime.operators.join.stream.state.OuterJoinRecordStateView;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinInputSideSpec;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.Preconditions;

public abstract class AbstractStreamingJoinOperator
extends AbstractStreamOperator<RowData>
implements TwoInputStreamOperator<RowData, RowData, RowData> {
    private static final long serialVersionUID = -376944622236540545L;
    protected static final String LEFT_RECORDS_STATE_NAME = "left-records";
    protected static final String RIGHT_RECORDS_STATE_NAME = "right-records";
    private final GeneratedJoinCondition generatedJoinCondition;
    protected final InternalTypeInfo<RowData> leftType;
    protected final InternalTypeInfo<RowData> rightType;
    protected final JoinInputSideSpec leftInputSideSpec;
    protected final JoinInputSideSpec rightInputSideSpec;
    private final boolean[] filterNullKeys;
    protected final long leftStateRetentionTime;
    protected final long rightStateRetentionTime;
    protected transient JoinConditionWithNullFilters joinCondition;
    protected transient TimestampedCollector<RowData> collector;

    public AbstractStreamingJoinOperator(InternalTypeInfo<RowData> leftType, InternalTypeInfo<RowData> rightType, GeneratedJoinCondition generatedJoinCondition, JoinInputSideSpec leftInputSideSpec, JoinInputSideSpec rightInputSideSpec, boolean[] filterNullKeys, long leftStateRetentionTime, long rightStateRetentionTime) {
        this.leftType = leftType;
        this.rightType = rightType;
        this.generatedJoinCondition = generatedJoinCondition;
        this.leftInputSideSpec = leftInputSideSpec;
        this.rightInputSideSpec = rightInputSideSpec;
        this.leftStateRetentionTime = leftStateRetentionTime;
        this.rightStateRetentionTime = rightStateRetentionTime;
        this.filterNullKeys = filterNullKeys;
    }

    public void open() throws Exception {
        super.open();
        JoinCondition condition = (JoinCondition)this.generatedJoinCondition.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.joinCondition = new JoinConditionWithNullFilters(condition, this.filterNullKeys, (KeyContext)this);
        this.joinCondition.setRuntimeContext((RuntimeContext)this.getRuntimeContext());
        this.joinCondition.open(DefaultOpenContext.INSTANCE);
        this.collector = new TimestampedCollector(this.output);
    }

    public void close() throws Exception {
        super.close();
        if (this.joinCondition != null) {
            this.joinCondition.close();
        }
    }

    private static <I, O> Iterator<O> collect(final Iterator<I> delegate, final Function<I, Boolean> matcher, final Function<I, O> mapper) {
        return new Iterator<O>(){
            private I next;

            @Override
            public boolean hasNext() {
                this.advance();
                return this.next != null;
            }

            @Override
            public O next() {
                Preconditions.checkState((boolean)this.hasNext());
                Object tmp = this.next;
                this.next = null;
                return mapper.apply(tmp);
            }

            private void advance() {
                while (this.next == null && delegate.hasNext()) {
                    Object record = delegate.next();
                    if (!((Boolean)matcher.apply(record)).booleanValue()) continue;
                    this.next = record;
                }
            }
        };
    }

    protected static Iterator<OuterRecord> iterator(RowData input, boolean inputIsLeft, JoinRecordStateView otherSideStateView, JoinCondition condition) throws Exception {
        if (otherSideStateView instanceof OuterJoinRecordStateView) {
            return AbstractStreamingJoinOperator.collect(((OuterJoinRecordStateView)otherSideStateView).getRecordsAndNumOfAssociations().iterator(), record -> inputIsLeft ? condition.apply(input, (RowData)record.f0) : condition.apply((RowData)record.f0, input), record -> new OuterRecord((RowData)record.f0, (Integer)record.f1));
        }
        return AbstractStreamingJoinOperator.collect(otherSideStateView.getRecords().iterator(), record -> inputIsLeft ? condition.apply(input, (RowData)record) : condition.apply((RowData)record, input), record -> new OuterRecord((RowData)record, -1));
    }

    protected static final class OuterRecord {
        public final RowData record;
        public final int numOfAssociations;

        private OuterRecord(RowData record, int numOfAssociations) {
            this.record = record;
            this.numOfAssociations = numOfAssociations;
        }
    }
}

