/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.statemachine.kafka;

import java.util.Properties;
import org.apache.flink.streaming.examples.statemachine.event.Event;
import org.apache.flink.streaming.examples.statemachine.generator.StandaloneThreadedGenerator;
import org.apache.flink.streaming.examples.statemachine.kafka.EventDeSerializationSchema;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;

public class KafkaStandaloneGenerator
extends StandaloneThreadedGenerator {
    public static final String BROKER_ADDRESS = "localhost:9092";
    public static final String TOPIC = "flink-demo-topic-1";
    public static final int NUM_PARTITIONS = 1;

    public static void main(String[] args) throws Exception {
        KafkaCollector[] collectors = new KafkaCollector[1];
        for (int i = 0; i < collectors.length; ++i) {
            collectors[i] = new KafkaCollector(BROKER_ADDRESS, TOPIC, i);
        }
        StandaloneThreadedGenerator.runGenerator(collectors);
    }

    private static class KafkaCollector
    implements Collector<Event>,
    AutoCloseable {
        private final KafkaProducer<Object, byte[]> producer;
        private final EventDeSerializationSchema serializer;
        private final String topic;
        private final int partition;

        KafkaCollector(String brokerAddress, String topic, int partition) {
            this.topic = (String)Preconditions.checkNotNull((Object)topic);
            this.partition = partition;
            this.serializer = new EventDeSerializationSchema();
            Properties properties = new Properties();
            properties.put("bootstrap.servers", brokerAddress);
            properties.put("key.serializer", ByteArraySerializer.class.getCanonicalName());
            properties.put("value.serializer", ByteArraySerializer.class.getCanonicalName());
            this.producer = new KafkaProducer(properties);
        }

        public void collect(Event evt) {
            byte[] serialized = this.serializer.serialize(evt);
            this.producer.send(new ProducerRecord<Object, byte[]>(this.topic, this.partition, null, serialized));
        }

        @Override
        public void close() {
            this.producer.close();
        }
    }
}

