/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.agent;

import groovy.lang.Closure;
import groovyx.gpars.agent.AgentCore;
import groovyx.gpars.dataflow.DataflowVariable;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.codehaus.groovy.runtime.NullObject;

abstract class AgentBase<T>
extends AgentCore {
    protected ReadWriteLock lock = new ReentrantReadWriteLock();
    protected T data;
    private final Closure copy;
    private final Collection<Closure> listeners = new CopyOnWriteArrayList<Closure>();
    private final Collection<Closure> validators = new CopyOnWriteArrayList<Closure>();
    private static final Closure awaitClosure = new AwaitClosure();

    AgentBase(T data) {
        this(data, null);
    }

    AgentBase(T data, Closure copy) {
        this.data = data;
        this.copy = copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onMessage(NullObject obj) {
        this.lock.readLock().lock();
        try {
            this.updateValue(null);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onMessage(Closure code) {
        this.lock.writeLock().lock();
        try {
            code.setDelegate((Object)this);
            code.call(this.copy != null ? this.copy.call(this.data) : this.data);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onMessage(T message) {
        this.lock.writeLock().lock();
        try {
            this.updateValue(message);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public final void updateValue(T newValue) {
        T oldValue = this.copy != null ? this.copy.call(this.data) : this.data;
        boolean validated = false;
        try {
            for (Closure validator : this.validators) {
                validator.call(new Object[]{oldValue, newValue});
            }
            validated = true;
        }
        catch (Throwable e) {
            this.registerError(e);
        }
        if (validated) {
            this.data = newValue;
            for (Closure listener : this.listeners) {
                listener.call(new Object[]{oldValue, newValue});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T getInstantVal() {
        this.lock.readLock().lock();
        try {
            T t = this.copy != null ? this.copy.call(this.data) : this.data;
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public final T getVal() throws InterruptedException {
        return this.sendAndWait(awaitClosure);
    }

    public final void valAsync(final Closure callback) {
        this.send(new Closure(this){
            private static final long serialVersionUID = 27598476470091452L;

            public Object call(Object arguments) {
                callback.call(arguments);
                return null;
            }
        });
    }

    public final T sendAndWait(final Closure message) throws InterruptedException {
        if (Thread.currentThread() == this.currentThread) {
            throw new IllegalStateException("Cannot submit messages to agents inside submitted commands");
        }
        final DataflowVariable result = new DataflowVariable();
        this.send(new Closure(message.getOwner()){
            private static final long serialVersionUID = -4637623342002266534L;

            public Object call(Object arguments) {
                Object value = message.call(arguments);
                result.bind(value);
                return null;
            }
        });
        return result.getVal();
    }

    public final void await() throws InterruptedException {
        this.sendAndWait(awaitClosure);
    }

    public void addListener(Closure listener) {
        this.listeners.add(this.checkClosure(listener));
    }

    public void addValidator(Closure validator) {
        this.validators.add(this.checkClosure(validator));
    }

    private Closure checkClosure(Closure code) {
        int maximumNumberOfParameters = code.getMaximumNumberOfParameters();
        if (maximumNumberOfParameters < 2 || maximumNumberOfParameters > 3) {
            throw new IllegalArgumentException("Agent listeners and validators can only take two arguments plus optionally the current agent instance as the first argument.");
        }
        if (maximumNumberOfParameters == 3) {
            return code.curry(new Object[]{this});
        }
        return code;
    }

    private static class AwaitClosure
    extends Closure {
        private static final long serialVersionUID = 8104821777516625579L;

        private AwaitClosure() {
            super(null);
        }

        public Object call(Object arguments) {
            return arguments;
        }
    }
}

