/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.qjournal.client.AsyncLogger;
import org.apache.hadoop.hdfs.qjournal.client.DirectExecutorService;
import org.apache.hadoop.hdfs.qjournal.client.IPCLoggerChannel;
import org.apache.hadoop.hdfs.qjournal.client.QuorumJournalManager;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocolProtos;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.mockito.Mockito;

public final class SpyQJournalUtil {
    private SpyQJournalUtil() {
    }

    public static QuorumJournalManager createSpyingQJM(Configuration conf, URI uri, NamespaceInfo nsInfo, String nameServiceId) throws IOException {
        AsyncLogger.Factory spyFactory = new AsyncLogger.Factory(){

            public AsyncLogger createLogger(Configuration conf, NamespaceInfo nsInfo, String journalId, String nameServiceId, InetSocketAddress addr) {
                IPCLoggerChannel logger = new IPCLoggerChannel(conf, nsInfo, journalId, nameServiceId, addr){

                    protected ExecutorService createSingleThreadExecutor() {
                        return new DirectExecutorService();
                    }
                };
                return (AsyncLogger)Mockito.spy((Object)logger);
            }
        };
        return new QuorumJournalManager(conf, uri, nsInfo, nameServiceId, spyFactory);
    }

    public static void mockJNWithEmptyOrSlowResponse(QuorumJournalManager manager, long startTxid) {
        List spies = manager.getLoggerSetForTests().getLoggersForTests();
        Semaphore semaphore = new Semaphore(0);
        ((AsyncLogger)Mockito.doAnswer(invocation -> {
            semaphore.release();
            return QJournalProtocolProtos.GetJournaledEditsResponseProto.newBuilder().setTxnCount(0).build();
        }).when(spies.get(0))).getJournaledEdits(startTxid, 5000);
        SpyQJournalUtil.spyGetJournaledEdits(spies, 1, startTxid, () -> semaphore.release(1));
        SpyQJournalUtil.spyGetJournaledEdits(spies, 2, startTxid, () -> semaphore.acquireUninterruptibly(2));
    }

    public static void spyGetJournaledEdits(List<AsyncLogger> spies, int jnSpyIdx, long fromTxId, Runnable preHook) {
        ((AsyncLogger)Mockito.doAnswer(invocation -> {
            preHook.run();
            ListenableFuture result = (ListenableFuture)invocation.callRealMethod();
            return result;
        }).when((Object)spies.get(jnSpyIdx))).getJournaledEdits(fromTxId, 5000);
    }
}

