/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.hdfs.server.namenode.NamenodeFsck;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.javax.servlet.ServletContext;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;

@InterfaceAudience.Private
public class FsckServlet
extends DfsServlet {
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map pmap = request.getParameterMap();
        PrintWriter out = response.getWriter();
        InetAddress remoteAddress = InetAddress.getByName(request.getRemoteAddr());
        ServletContext context = this.getServletContext();
        Configuration conf = NameNodeHttpServer.getConfFromContext(context);
        UserGroupInformation ugi = this.getUGI(request, conf);
        try {
            ugi.doAs(() -> {
                NameNode nn = NameNodeHttpServer.getNameNodeFromContext(context);
                FSNamesystem namesystem = nn.getNamesystem();
                BlockManager bm = namesystem.getBlockManager();
                int totalDatanodes = namesystem.getNumberOfDatanodes(HdfsConstants.DatanodeReportType.LIVE);
                NamenodeFsck fsck = new NamenodeFsck(conf, nn, bm.getDatanodeManager().getNetworkTopology(), pmap, out, totalDatanodes, remoteAddress);
                String auditSource = fsck.getAuditSource();
                boolean success = false;
                try {
                    fsck.fsck();
                    success = true;
                }
                finally {
                    namesystem.logFsckEvent(success, auditSource, remoteAddress);
                }
                return null;
            });
        }
        catch (InterruptedException e) {
            response.sendError(400, e.getMessage());
        }
    }
}

