/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.invocation;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.shaded.org.mockito.ArgumentMatcher;
import org.apache.hadoop.shaded.org.mockito.internal.exceptions.Reporter;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.InvocationMatcher;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.LocalizedMatcher;
import org.apache.hadoop.shaded.org.mockito.internal.progress.ArgumentMatcherStorage;
import org.apache.hadoop.shaded.org.mockito.invocation.Invocation;

public class MatchersBinder
implements Serializable {
    public InvocationMatcher bindMatchers(ArgumentMatcherStorage argumentMatcherStorage, Invocation invocation) {
        List<LocalizedMatcher> lastMatchers = argumentMatcherStorage.pullLocalizedMatchers();
        this.validateMatchers(invocation, lastMatchers);
        LinkedList<ArgumentMatcher> matchers = new LinkedList<ArgumentMatcher>();
        for (LocalizedMatcher m : lastMatchers) {
            matchers.add(m.getMatcher());
        }
        return new InvocationMatcher(invocation, matchers);
    }

    private void validateMatchers(Invocation invocation, List<LocalizedMatcher> lastMatchers) {
        if (!lastMatchers.isEmpty()) {
            int recordedMatchersSize = lastMatchers.size();
            int expectedMatchersSize = invocation.getArguments().length;
            if (expectedMatchersSize != recordedMatchersSize) {
                throw Reporter.invalidUseOfMatchers(expectedMatchersSize, lastMatchers);
            }
        }
    }
}

