/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.data;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.finance.data.DatePrice;
import org.ojalgo.netio.BasicParser;
import org.ojalgo.netio.ResourceLocator;
import org.ojalgo.series.CalendarDateSeries;
import org.ojalgo.type.CalendarDateUnit;
import org.ojalgo.type.TypeCache;

public abstract class DataSource<DP extends DatePrice>
implements BasicParser<DP> {
    protected static final boolean DEBUG = false;
    private final CalendarDateUnit myResolution;
    private final ResourceLocator myResourceLocator = new ResourceLocator();
    private final String mySymbol;

    private DataSource() {
        this(null, null);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected DataSource(String symbol, CalendarDateUnit resolution) {
        this.mySymbol = symbol;
        this.myResolution = resolution;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource)obj;
        if (this.myResolution != other.myResolution) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        return !(this.mySymbol == null ? other.mySymbol != null : !this.mySymbol.equals(other.mySymbol));
    }

    public List<DP> getHistoricalPrices() {
        return this.getHistoricalPrices(this.myResourceLocator.getStreamReader());
    }

    public List<DP> getHistoricalPrices(Reader reader) {
        ArrayList retVal = new ArrayList();
        this.parse(reader, (T i) -> retVal.add(i));
        Collections.sort(retVal);
        return retVal;
    }

    public CalendarDateSeries<Double> getPriceSeries() {
        return this.getPriceSeries(this.myResourceLocator.getStreamReader());
    }

    public CalendarDateSeries<Double> getPriceSeries(Reader reader) {
        CalendarDateSeries retVal = (CalendarDateSeries)new CalendarDateSeries(this.myResolution).name(this.mySymbol);
        for (DatePrice tmpDatePrice : this.getHistoricalPrices(reader)) {
            retVal.put(tmpDatePrice.getKey(), tmpDatePrice.getValue());
        }
        return retVal;
    }

    public CalendarDateUnit getResolution() {
        return this.myResolution;
    }

    public String getSymbol() {
        return this.mySymbol;
    }

    public TypeCache<? extends List<DP>> getSymbolCache(long purgeIntervalMeassure, CalendarDateUnit purgeIntervalUnit) {
        return new TypeCache<List<DP>>(purgeIntervalMeassure, purgeIntervalUnit){

            @Override
            protected List<DP> recreateCache() {
                return DataSource.this.getHistoricalPrices();
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myResolution == null ? 0 : this.myResolution.hashCode());
        result = 31 * result + (this.mySymbol == null ? 0 : this.mySymbol.hashCode());
        return result;
    }

    protected String addQueryParameter(String key, String value) {
        return this.myResourceLocator.addQueryParameter(key, value);
    }

    protected void setHost(String host) {
        this.myResourceLocator.setHost(host);
    }

    protected void setPath(String path) {
        this.myResourceLocator.setPath(path);
    }
}

