/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.pi.math;

public class Modular {
    static final long MAX_SQRT_LONG = (long)Math.sqrt(9.223372036854776E18);

    public static long mod(long e, long n) {
        int HALF = 63 - Long.numberOfLeadingZeros(n) >> 1;
        int FULL = HALF << 1;
        long ONES = (1 << HALF) - 1;
        long r = 2L;
        for (long mask = Long.highestOneBit(e) >> 1; mask > 0L; mask >>= 1) {
            if (r <= MAX_SQRT_LONG) {
                if ((r *= r) >= n) {
                    r %= n;
                }
            } else {
                long high = r >>> HALF;
                long low = r &= ONES;
                if ((r *= r) >= n) {
                    r %= n;
                }
                if (high != 0L) {
                    long s = high * high;
                    if (s >= n) {
                        s %= n;
                    }
                    for (int i = 0; i < FULL; ++i) {
                        if ((s <<= 1) < n) continue;
                        s -= n;
                    }
                    if (low == 0L) {
                        r = s;
                    } else {
                        long t = high * low;
                        if (t >= n) {
                            t %= n;
                        }
                        for (int i = -1; i < HALF; ++i) {
                            if ((t <<= 1) < n) continue;
                            t -= n;
                        }
                        if ((r += s) >= n) {
                            r -= n;
                        }
                        if ((r += t) >= n) {
                            r -= n;
                        }
                    }
                }
            }
            if ((e & mask) == 0L || (r <<= 1) < n) continue;
            r -= n;
        }
        return r;
    }

    public static double addMod(double x, double a) {
        return (x += a) >= 1.0 ? x - 1.0 : (x < 0.0 ? x + 1.0 : x);
    }

    public static long modInverse(long x, long y) {
        if (x == 1L) {
            return 1L;
        }
        long a = 1L;
        long b = 0L;
        long c = x;
        long u = 0L;
        long v = 1L;
        long w = y;
        while (true) {
            long q = w / c;
            u -= q * a;
            if ((w -= q * c) == 1L) {
                return u > 0L ? u : u + y;
            }
            v -= q * b;
            q = c / w;
            a -= q * u;
            if ((c -= q * w) == 1L) {
                return a > 0L ? a : a + y;
            }
            b -= q * v;
        }
    }
}

