/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.monitor.probe;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.monitor.probe.Probe;
import org.apache.hadoop.yarn.service.monitor.probe.ProbeStatus;
import org.apache.hadoop.yarn.service.utils.ServiceRegistryUtils;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;

public class DefaultProbe
extends Probe {
    private final boolean dnsCheckEnabled;
    private final String dnsAddress;

    public DefaultProbe(Map<String, String> props) {
        this("Default probe: IP presence", props);
    }

    protected DefaultProbe(String name, Map<String, String> props) {
        this.dnsCheckEnabled = DefaultProbe.getPropertyBool(props, "dns.check.enabled", false);
        this.dnsAddress = props.get("dns.address");
        String additionalName = "";
        if (this.dnsCheckEnabled) {
            additionalName = this.dnsAddress == null ? " with DNS checking" : " with DNS checking and DNS server address " + this.dnsAddress;
        }
        this.setName(name + additionalName);
    }

    public static DefaultProbe create() throws IOException {
        return new DefaultProbe(Collections.emptyMap());
    }

    public static DefaultProbe create(Map<String, String> props) throws IOException {
        return new DefaultProbe(props);
    }

    @Override
    public ProbeStatus ping(ComponentInstance instance) {
        ProbeStatus status = new ProbeStatus();
        ContainerStatus containerStatus = instance.getContainerStatus();
        if (containerStatus == null || ServiceUtils.isEmpty(containerStatus.getIPs())) {
            status.fail(this, new IOException(instance.getCompInstanceName() + ": IP is not available yet"));
            return status;
        }
        String hostname = instance.getHostname();
        if (this.dnsCheckEnabled && !ServiceRegistryUtils.registryDNSLookupExists(this.dnsAddress, hostname)) {
            status.fail(this, new IOException(instance.getCompInstanceName() + ": DNS checking is enabled, but lookup for " + hostname + " is not available yet"));
            return status;
        }
        status.succeed(this);
        return status;
    }

    protected boolean isDnsCheckEnabled() {
        return this.dnsCheckEnabled;
    }
}

