/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;

public class CalculationContext {
    private final String resourceName;
    private final QueueCapacityVector.ResourceUnitCapacityType capacityType;
    private final CSQueue queue;

    public CalculationContext(String resourceName, QueueCapacityVector.ResourceUnitCapacityType capacityType, CSQueue queue) {
        this.resourceName = resourceName;
        this.capacityType = capacityType;
        this.queue = queue;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public QueueCapacityVector.ResourceUnitCapacityType getCapacityType() {
        return this.capacityType;
    }

    public CSQueue getQueue() {
        return this.queue;
    }

    public QueueCapacityVector.QueueCapacityVectorEntry getCurrentMinimumCapacityEntry(String label) {
        return this.queue.getConfiguredCapacityVector(label).getResource(this.resourceName);
    }

    public QueueCapacityVector.QueueCapacityVectorEntry getCurrentMaximumCapacityEntry(String label) {
        return this.queue.getConfiguredMaxCapacityVector(label).getResource(this.resourceName);
    }
}

