/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.request;

import lombok.Generated;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;

public final class Range {
    private final long start;
    private final long end;
    private static final String TO_HTTP_STRING_FORMAT = "bytes=%d-%d";
    private static final String TO_STRING_FORMAT = "%d-%d";

    public Range(long start, long end) {
        Preconditions.checkArgument(start >= 0L, "`start` must not be negative");
        Preconditions.checkArgument(end >= 0L, "`end` must not be negative");
        Preconditions.checkArgument(start <= end, "`start` must be less than equal to `end`");
        this.start = start;
        this.end = end;
    }

    public boolean contains(long pos) {
        return this.start <= pos && pos <= this.end;
    }

    public int getLength() {
        return (int)(this.end - this.start + 1L);
    }

    public String toString() {
        return String.format(TO_STRING_FORMAT, this.start, this.end);
    }

    public String toHttpString() {
        return String.format(TO_HTTP_STRING_FORMAT, this.start, this.end);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        if (this.getStart() != other.getStart()) {
            return false;
        }
        return this.getEnd() == other.getEnd();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $start = this.getStart();
        result = result * 59 + (int)($start >>> 32 ^ $start);
        long $end = this.getEnd();
        result = result * 59 + (int)($end >>> 32 ^ $end);
        return result;
    }

    @Generated
    public long getStart() {
        return this.start;
    }

    @Generated
    public long getEnd() {
        return this.end;
    }
}

