/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.AMStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEventHandler;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.util.functional.FutureIO;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobHistoryCopyService
extends CompositeService
implements HistoryEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JobHistoryCopyService.class);
    private final ApplicationAttemptId applicationAttemptId;
    private final EventHandler<Event> handler;
    private final JobId jobId;

    public JobHistoryCopyService(ApplicationAttemptId applicationAttemptId, EventHandler<Event> handler) {
        super("JobHistoryCopyService");
        this.applicationAttemptId = applicationAttemptId;
        this.jobId = TypeConverter.toYarn((JobID)TypeConverter.fromYarn((ApplicationId)applicationAttemptId.getApplicationId()));
        this.handler = handler;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
    }

    public void handleEvent(HistoryEvent event) throws IOException {
        if (!(event instanceof AMStartedEvent)) {
            this.handler.handle((Event)new JobHistoryEvent(this.jobId, event));
        }
    }

    protected void serviceStart() throws Exception {
        try {
            this.parse();
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        super.serviceStart();
    }

    private void parse() throws IOException {
        FSDataInputStream in = null;
        try {
            in = JobHistoryCopyService.getPreviousJobHistoryFileStream(this.getConfig(), this.applicationAttemptId);
        }
        catch (IOException e) {
            LOG.warn("error trying to open previous history file. No history data will be copied over.", (Throwable)e);
            return;
        }
        JobHistoryParser parser = new JobHistoryParser(in);
        parser.parse((HistoryEventHandler)this);
        IOException parseException = parser.getParseException();
        if (parseException != null) {
            LOG.info("Got an error parsing job-history file, ignoring incomplete events.", (Throwable)parseException);
        }
    }

    public static FSDataInputStream getPreviousJobHistoryFileStream(Configuration conf, ApplicationAttemptId applicationAttemptId) throws IOException {
        FSDataInputStream in = null;
        Path historyFile = null;
        String jobId = TypeConverter.fromYarn((ApplicationId)applicationAttemptId.getApplicationId()).toString();
        String jobhistoryDir = JobHistoryUtils.getConfiguredHistoryStagingDirPrefix((Configuration)conf, (String)jobId);
        Path histDirPath = FileContext.getFileContext((Configuration)conf).makeQualified(new Path(jobhistoryDir));
        FileContext fc = FileContext.getFileContext((URI)histDirPath.toUri(), (Configuration)conf);
        historyFile = fc.makeQualified(JobHistoryUtils.getStagingJobHistoryFile((Path)histDirPath, (String)jobId, (int)(applicationAttemptId.getAttemptId() - 1)));
        LOG.info("History file is at " + historyFile);
        in = (FSDataInputStream)FutureIO.awaitFuture((Future)((FutureDataInputStreamBuilder)fc.openFile(historyFile).opt("fs.option.openfile.read.policy", "whole-file")).build());
        return in;
    }
}

