/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ReplicatedResourceClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreClient;
import com.microsoft.azure.cosmosdb.rx.internal.BadRequestException;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceResponse;
import com.microsoft.azure.cosmosdb.rx.internal.RxStoreModel;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import org.apache.commons.lang3.EnumUtils;
import rx.Observable;
import rx.Single;

public class ServerStoreModel
implements RxStoreModel {
    private final StoreClient storeClient;

    public ServerStoreModel(StoreClient storeClient) {
        this.storeClient = storeClient;
    }

    public Observable<RxDocumentServiceResponse> processMessage(RxDocumentServiceRequest request) {
        String requestConsistencyLevelHeaderValue = (String)request.getHeaders().get("x-ms-consistency-level");
        request.requestContext.originalRequestConsistencyLevel = null;
        if (!Strings.isNullOrEmpty((String)requestConsistencyLevelHeaderValue)) {
            ConsistencyLevel requestConsistencyLevel = (ConsistencyLevel)EnumUtils.getEnum(ConsistencyLevel.class, (String)requestConsistencyLevelHeaderValue);
            if (requestConsistencyLevel == null) {
                return Observable.error((Throwable)new BadRequestException(String.format("Value '%s' specified for the header '%s' is invalid.", requestConsistencyLevelHeaderValue, "x-ms-consistency-level")));
            }
            request.requestContext.originalRequestConsistencyLevel = requestConsistencyLevel;
        }
        if (ReplicatedResourceClient.isMasterResource(request.getResourceType())) {
            request.getHeaders().put("x-ms-consistency-level", ConsistencyLevel.Strong.toString());
        }
        Single<RxDocumentServiceResponse> response = this.storeClient.processMessageAsync(request);
        return response.toObservable();
    }
}

