/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl;

import com.microsoft.azure.datalake.store.ADLFileInputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class AdlFsInputStream
extends FSInputStream {
    private final ADLFileInputStream in;
    private final FileSystem.Statistics stat;
    private final boolean enablePositionalReadExperiment;

    public AdlFsInputStream(ADLFileInputStream inputStream, FileSystem.Statistics statistics, Configuration conf) throws IOException {
        this.in = inputStream;
        this.in.setBufferSize(conf.getInt("adl.feature.client.cache.readahead", 0x400000));
        this.enablePositionalReadExperiment = conf.getBoolean("adl.feature.experiment.positional.read.enable", true);
        this.stat = statistics;
    }

    public synchronized void seek(long pos) throws IOException {
        this.in.seek(pos);
    }

    public synchronized long getPos() throws IOException {
        return this.in.getPos();
    }

    public boolean seekToNewSource(long l) throws IOException {
        return false;
    }

    public synchronized int read() throws IOException {
        int ch = this.in.read();
        if (this.stat != null && ch != -1) {
            this.stat.incrementBytesRead(1L);
        }
        return ch;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        int numberOfByteRead = 0;
        numberOfByteRead = this.enablePositionalReadExperiment ? this.in.read(position, buffer, offset, length) : super.read(position, buffer, offset, length);
        if (this.stat != null && numberOfByteRead > 0) {
            this.stat.incrementBytesRead((long)numberOfByteRead);
        }
        return numberOfByteRead;
    }

    public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
        int numberOfByteRead = this.in.read(buffer, offset, length);
        if (this.stat != null && numberOfByteRead > 0) {
            this.stat.incrementBytesRead((long)numberOfByteRead);
        }
        return numberOfByteRead;
    }

    public synchronized int available() throws IOException {
        return (int)Math.min(this.in.length() - this.in.getPos(), Integer.MAX_VALUE);
    }

    public synchronized void close() throws IOException {
        this.in.close();
    }

    public synchronized long skip(long pos) throws IOException {
        return this.in.skip(pos);
    }
}

