/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.io.IOException;
import javax.security.sasl.SaslException;
import org.apache.hadoop.io.retry.Idempotent;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.AccessControlException;

public interface UnreliableInterface {
    public void alwaysSucceeds() throws UnreliableException;

    public void alwaysFailsWithFatalException() throws FatalException;

    public void alwaysFailsWithRemoteFatalException() throws RemoteException;

    public void failsOnceWithIOException() throws IOException;

    public void failsOnceWithRemoteException() throws RemoteException;

    public void failsOnceThenSucceeds() throws UnreliableException;

    public boolean failsOnceThenSucceedsWithReturnValue() throws UnreliableException;

    public void failsTenTimesThenSucceeds() throws UnreliableException;

    public void failsWithSASLExceptionTenTimes() throws SaslException;

    @Idempotent
    public void failsWithAccessControlExceptionEightTimes() throws AccessControlException;

    @Idempotent
    public void failsWithWrappedAccessControlException() throws IOException;

    public String succeedsOnceThenFailsReturningString() throws UnreliableException, StandbyException, IOException;

    @Idempotent
    public String succeedsOnceThenFailsReturningStringIdempotent() throws UnreliableException, StandbyException, IOException;

    public String succeedsTenTimesThenFailsReturningString() throws UnreliableException, StandbyException, IOException;

    @Idempotent
    public String failsIfIdentifierDoesntMatch(String var1) throws UnreliableException, StandbyException, IOException;

    public void nonIdempotentVoidFailsIfIdentifierDoesntMatch(String var1) throws UnreliableException, StandbyException, IOException;

    public static class FatalException
    extends UnreliableException {
        private static final long serialVersionUID = 1L;
    }

    public static class UnreliableException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private String identifier;

        public UnreliableException() {
        }

        public UnreliableException(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public String getMessage() {
            return this.identifier;
        }
    }
}

