/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.util;

public abstract class Clock {
    public abstract long getTick();

    public long duration(long startTick) {
        return this.getTick() - startTick;
    }

    public static Clock defaultClock() {
        return UserTimeClockHolder.DEFAULT;
    }

    private static class UserTimeClockHolder {
        private static final Clock DEFAULT = new UserTimeClock();

        private UserTimeClockHolder() {
        }
    }

    public static class UserTimeClock
    extends Clock {
        @Override
        public long getTick() {
            return System.currentTimeMillis();
        }
    }
}

