/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.queue.impl;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import org.apache.hertzbeat.common.config.CommonProperties;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.common.serialize.RedisMetricsDataCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="common.queue", name={"type"}, havingValue="redis")
public class RedisCommonDataQueue
implements CommonDataQueue,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RedisCommonDataQueue.class);
    private final RedisClient redisClient;
    private final StatefulRedisConnection<String, CollectRep.MetricsData> connection;
    private final RedisCommands<String, CollectRep.MetricsData> syncCommands;
    private final String metricsDataQueueNameToStorage;
    private final String metricsDataQueueNameForServiceDiscovery;
    private final String metricsDataQueueNameToAlerter;
    private final CommonProperties.RedisProperties redisProperties;

    public RedisCommonDataQueue(CommonProperties properties) {
        if (properties == null || properties.getQueue() == null || properties.getQueue().getRedis() == null) {
            log.error("init error, please config common.queue.redis props in application.yml");
            throw new IllegalArgumentException("please config common.queue.redis props");
        }
        this.redisProperties = properties.getQueue().getRedis();
        this.redisClient = RedisClient.create((RedisURI)RedisURI.builder().withHost(this.redisProperties.getRedisHost()).withPort(this.redisProperties.getRedisPort()).build());
        RedisMetricsDataCodec codec = new RedisMetricsDataCodec();
        this.connection = this.redisClient.connect((RedisCodec)codec);
        this.syncCommands = this.connection.sync();
        this.metricsDataQueueNameToStorage = this.redisProperties.getMetricsDataQueueNameToPersistentStorage();
        this.metricsDataQueueNameForServiceDiscovery = this.redisProperties.getMetricsDataQueueNameForServiceDiscovery();
        this.metricsDataQueueNameToAlerter = this.redisProperties.getMetricsDataQueueNameToAlerter();
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToAlerter() {
        try {
            return (CollectRep.MetricsData)this.syncCommands.rpop((Object)this.metricsDataQueueNameToAlerter);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToStorage() throws InterruptedException {
        try {
            return (CollectRep.MetricsData)this.syncCommands.rpop((Object)this.metricsDataQueueNameToStorage);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    @Override
    public CollectRep.MetricsData pollServiceDiscoveryData() throws InterruptedException {
        try {
            return (CollectRep.MetricsData)this.syncCommands.rpop((Object)this.metricsDataQueueNameForServiceDiscovery);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    @Override
    public void sendMetricsData(CollectRep.MetricsData metricsData) {
        try {
            this.syncCommands.lpush((Object)this.metricsDataQueueNameToAlerter, (Object[])new CollectRep.MetricsData[]{metricsData});
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    @Override
    public void sendMetricsDataToStorage(CollectRep.MetricsData metricsData) {
        try {
            this.syncCommands.lpush((Object)this.metricsDataQueueNameToStorage, (Object[])new CollectRep.MetricsData[]{metricsData});
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    @Override
    public void sendServiceDiscoveryData(CollectRep.MetricsData metricsData) {
        try {
            this.syncCommands.lpush((Object)this.metricsDataQueueNameForServiceDiscovery, (Object[])new CollectRep.MetricsData[]{metricsData});
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public void destroy() {
        this.connection.close();
        this.redisClient.shutdown();
    }
}

