/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.genai;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientMetrics;
import io.opentelemetry.instrumentation.api.incubator.semconv.genai.AutoValue_GenAiClientMetrics_State;
import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiMetricsAdvice;
import io.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.instrumentation.api.internal.OperationMetricsUtil;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GenAiClientMetrics
implements OperationListener {
    private static final double NANOS_PER_S = TimeUnit.SECONDS.toNanos(1L);
    private static final ContextKey<State> GEN_AI_CLIENT_METRICS_STATE = ContextKey.named((String)"gen-ai-client-metrics-state");
    private static final Logger logger = Logger.getLogger(DbClientMetrics.class.getName());
    static final AttributeKey<String> GEN_AI_TOKEN_TYPE = AttributeKey.stringKey((String)"gen_ai.token.type");
    private final LongHistogram tokenUsage;
    private final DoubleHistogram operationDuration;

    public static OperationMetrics get() {
        return OperationMetricsUtil.create((String)"gen_ai client", GenAiClientMetrics::new);
    }

    private GenAiClientMetrics(Meter meter) {
        LongHistogramBuilder tokenUsageBuilder = meter.histogramBuilder("gen_ai.client.token.usage").ofLongs().setUnit("{token}").setDescription("Measures number of input and output tokens used").setExplicitBucketBoundariesAdvice(GenAiMetricsAdvice.CLIENT_TOKEN_USAGE_BUCKETS);
        GenAiMetricsAdvice.applyClientTokenUsageAdvice(tokenUsageBuilder);
        this.tokenUsage = tokenUsageBuilder.build();
        DoubleHistogramBuilder operationDurationBuilder = meter.histogramBuilder("gen_ai.client.operation.duration").setUnit("s").setDescription("GenAI operation duration").setExplicitBucketBoundariesAdvice(GenAiMetricsAdvice.CLIENT_OPERATION_DURATION_BUCKETS);
        GenAiMetricsAdvice.applyClientOperationDurationAdvice(operationDurationBuilder);
        this.operationDuration = operationDurationBuilder.build();
    }

    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(GEN_AI_CLIENT_METRICS_STATE, (Object)new AutoValue_GenAiClientMetrics_State(startAttributes, startNanos));
    }

    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        Long outputTokens;
        State state = (State)context.get(GEN_AI_CLIENT_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record gen_ai operation metrics.", context);
            return;
        }
        AttributesBuilder attributesBuilder = state.startAttributes().toBuilder().putAll(endAttributes);
        this.operationDuration.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_S, attributesBuilder.build(), context);
        Long inputTokens = (Long)endAttributes.get(GenAiAttributesExtractor.GEN_AI_USAGE_INPUT_TOKENS);
        if (inputTokens != null) {
            this.tokenUsage.record(inputTokens.longValue(), attributesBuilder.put(GEN_AI_TOKEN_TYPE, (Object)"input").build(), context);
        }
        if ((outputTokens = (Long)endAttributes.get(GenAiAttributesExtractor.GEN_AI_USAGE_OUTPUT_TOKENS)) != null) {
            this.tokenUsage.record(outputTokens.longValue(), attributesBuilder.put(GEN_AI_TOKEN_TYPE, (Object)"output").build(), context);
        }
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

