/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import io.netty5.buffer.Buffer;
import io.netty5.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.WebSocketFrame;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.Netty5DataBuffer;
import org.springframework.core.io.buffer.Netty5DataBufferFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.AbstractWebSocketSession;

public abstract class Netty5WebSocketSessionSupport<T>
extends AbstractWebSocketSession<T> {
    public static final int DEFAULT_FRAME_MAX_SIZE = 65536;
    private static final Map<Class<?>, WebSocketMessage.Type> messageTypes = new HashMap(8);

    protected Netty5WebSocketSessionSupport(T delegate, HandshakeInfo info, Netty5DataBufferFactory factory) {
        super(delegate, ObjectUtils.getIdentityHexString(delegate), info, (DataBufferFactory)factory);
    }

    public Netty5DataBufferFactory bufferFactory() {
        return (Netty5DataBufferFactory)super.bufferFactory();
    }

    protected WebSocketMessage toMessage(WebSocketFrame frame) {
        Netty5DataBuffer payload = this.bufferFactory().wrap(frame.binaryData());
        WebSocketMessage.Type messageType = messageTypes.get(frame.getClass());
        Assert.state((messageType != null ? 1 : 0) != 0, (String)"Unexpected message type");
        return new WebSocketMessage(messageType, (DataBuffer)payload, frame);
    }

    protected WebSocketFrame toFrame(WebSocketMessage message) {
        if (message.getNativeMessage() != null) {
            return (WebSocketFrame)message.getNativeMessage();
        }
        Buffer buffer = Netty5DataBufferFactory.toBuffer((DataBuffer)message.getPayload());
        if (WebSocketMessage.Type.TEXT.equals((Object)message.getType())) {
            return new TextWebSocketFrame(buffer);
        }
        if (WebSocketMessage.Type.BINARY.equals((Object)message.getType())) {
            return new BinaryWebSocketFrame(buffer);
        }
        if (WebSocketMessage.Type.PING.equals((Object)message.getType())) {
            return new PingWebSocketFrame(buffer);
        }
        if (WebSocketMessage.Type.PONG.equals((Object)message.getType())) {
            return new PongWebSocketFrame(buffer);
        }
        throw new IllegalArgumentException("Unexpected message type: " + message.getType());
    }

    static {
        messageTypes.put(TextWebSocketFrame.class, WebSocketMessage.Type.TEXT);
        messageTypes.put(BinaryWebSocketFrame.class, WebSocketMessage.Type.BINARY);
        messageTypes.put(PingWebSocketFrame.class, WebSocketMessage.Type.PING);
        messageTypes.put(PongWebSocketFrame.class, WebSocketMessage.Type.PONG);
    }
}

