/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.alert.dto.AlibabaCloudSlsExternAlert;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.ExternAlertService;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AlibabaCloudSlsExternAlertService
implements ExternAlertService {
    private static final Logger log = LoggerFactory.getLogger(AlibabaCloudSlsExternAlertService.class);
    private final AlarmCommonReduce alarmCommonReduce;

    public AlibabaCloudSlsExternAlertService(AlarmCommonReduce alarmCommonReduce) {
        this.alarmCommonReduce = alarmCommonReduce;
    }

    @Override
    public void addExternAlert(String content) {
        AlibabaCloudSlsExternAlert externAlert = (AlibabaCloudSlsExternAlert)JsonUtil.fromJson((String)content, AlibabaCloudSlsExternAlert.class);
        if (externAlert == null) {
            log.warn("Failure to parse external alert content. content: {}", (Object)content);
            return;
        }
        SingleAlert singleAlert = new AlibabaCloudSlsConverter().convert(externAlert);
        this.alarmCommonReduce.reduceAndSendAlarm(singleAlert);
    }

    @Override
    public String supportSource() {
        return "alibabacloud-sls";
    }

    public static class AlibabaCloudSlsConverter {
        public SingleAlert convert(AlibabaCloudSlsExternAlert externAlert) {
            return SingleAlert.builder().triggerTimes(Integer.valueOf(1)).status(externAlert.getStatus()).startAt(Long.valueOf(Instant.ofEpochSecond(externAlert.getFireTime()).toEpochMilli())).activeAt(Long.valueOf(Instant.ofEpochSecond(externAlert.getAlertTime()).toEpochMilli())).endAt(this.convertResolveTime(externAlert.getStatus(), externAlert.getResolveTime())).labels(this.buildLabels(externAlert)).annotations(this.buildAnnotations(externAlert)).content(this.formatContent(externAlert)).build();
        }

        private String formatContent(AlibabaCloudSlsExternAlert externAlert) {
            Optional<AlibabaCloudSlsExternAlert.Severity> severity = AlibabaCloudSlsExternAlert.Severity.convert(externAlert.getSeverity());
            Long resolveTimeMilli = this.convertResolveTime(externAlert.getStatus(), externAlert.getResolveTime());
            return MessageFormat.format("AlibabaCloud-sls alert , {0} - [{1}], level: [{2}], desc: {3}, fire_time:{4}, resolve_time:{5}", externAlert.getAnnotation("title"), externAlert.getStatus(), severity.isPresent() ? severity.get().getAlias() : "N/A", externAlert.getAnnotation("desc"), this.timeSecondToDate(Instant.ofEpochSecond(externAlert.getFireTime()).toEpochMilli()), null != resolveTimeMilli ? this.timeSecondToDate(resolveTimeMilli) : "N/A");
        }

        private String timeSecondToDate(long timestampMillis) {
            LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestampMillis), ZoneId.systemDefault());
            return dateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }

        private Map<String, String> buildAnnotations(AlibabaCloudSlsExternAlert externAlert) {
            HashMap<String, String> annotations = new HashMap<String, String>(8);
            Optional<AlibabaCloudSlsExternAlert.Severity> severity = AlibabaCloudSlsExternAlert.Severity.convert(externAlert.getSeverity());
            severity.ifPresent(value -> annotations.put("severity", value.getAlias()));
            if (StringUtils.isNotBlank((CharSequence)externAlert.getSigninUrl()) && IpDomainUtil.isHasSchema((String)externAlert.getSigninUrl())) {
                annotations.put("signinUrl", "<a target=\"_blank\" href=\"" + externAlert.getSigninUrl() + "\">View Details</a>");
            }
            if (null != externAlert.getAnnotations() && !externAlert.getAnnotations().isEmpty()) {
                annotations.putAll(externAlert.getAnnotations());
            }
            return annotations;
        }

        private Map<String, String> buildLabels(AlibabaCloudSlsExternAlert externAlert) {
            HashMap<String, String> labels = new HashMap<String, String>(8);
            labels.put("__source__", "alibabacloud-sls");
            labels.put("alertname", externAlert.getAlertName());
            labels.put("region", externAlert.getRegion());
            labels.put("project", externAlert.getProject());
            if (null != externAlert.getLabels() && !externAlert.getLabels().isEmpty()) {
                labels.putAll(externAlert.getLabels());
            }
            return labels;
        }

        private Long convertResolveTime(String status, int resolveTimeSecond) {
            return "resolved".equals(status) ? Long.valueOf(Instant.ofEpochSecond(resolveTimeSecond).toEpochMilli()) : null;
        }
    }
}

