/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.graph;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.ErrorCode;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class VerifyClientVersionResp
implements TBase,
Serializable,
Cloneable,
Comparable<VerifyClientVersionResp> {
    private static final TStruct STRUCT_DESC = new TStruct("VerifyClientVersionResp");
    private static final TField ERROR_CODE_FIELD_DESC = new TField("error_code", 8, 1);
    private static final TField ERROR_MSG_FIELD_DESC = new TField("error_msg", 11, 2);
    public ErrorCode error_code;
    public byte[] error_msg;
    public static final int ERROR_CODE = 1;
    public static final int ERROR_MSG = 2;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public VerifyClientVersionResp() {
    }

    public VerifyClientVersionResp(ErrorCode error_code) {
        this();
        this.error_code = error_code;
    }

    public VerifyClientVersionResp(ErrorCode error_code, byte[] error_msg) {
        this();
        this.error_code = error_code;
        this.error_msg = error_msg;
    }

    public static Builder builder() {
        return new Builder();
    }

    public VerifyClientVersionResp(VerifyClientVersionResp other) {
        if (other.isSetError_code()) {
            this.error_code = TBaseHelper.deepCopy(other.error_code);
        }
        if (other.isSetError_msg()) {
            this.error_msg = TBaseHelper.deepCopy(other.error_msg);
        }
    }

    @Override
    public VerifyClientVersionResp deepCopy() {
        return new VerifyClientVersionResp(this);
    }

    public ErrorCode getError_code() {
        return this.error_code;
    }

    public VerifyClientVersionResp setError_code(ErrorCode error_code) {
        this.error_code = error_code;
        return this;
    }

    public void unsetError_code() {
        this.error_code = null;
    }

    public boolean isSetError_code() {
        return this.error_code != null;
    }

    public void setError_codeIsSet(boolean __value) {
        if (!__value) {
            this.error_code = null;
        }
    }

    public byte[] getError_msg() {
        return this.error_msg;
    }

    public VerifyClientVersionResp setError_msg(byte[] error_msg) {
        this.error_msg = error_msg;
        return this;
    }

    public void unsetError_msg() {
        this.error_msg = null;
    }

    public boolean isSetError_msg() {
        return this.error_msg != null;
    }

    public void setError_msgIsSet(boolean __value) {
        if (!__value) {
            this.error_msg = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetError_code();
                    break;
                }
                this.setError_code((ErrorCode)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetError_msg();
                    break;
                }
                this.setError_msg((byte[])__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getError_code();
            }
            case 2: {
                return this.getError_msg();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof VerifyClientVersionResp)) {
            return false;
        }
        VerifyClientVersionResp that = (VerifyClientVersionResp)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetError_code(), that.isSetError_code(), this.error_code, that.error_code)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetError_msg(), that.isSetError_msg(), this.error_msg, that.error_msg);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.error_code, this.error_msg});
    }

    @Override
    public int compareTo(VerifyClientVersionResp other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetError_code()).compareTo(other.isSetError_code());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.error_code, other.error_code);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetError_msg()).compareTo(other.isSetError_msg());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.error_msg, other.error_msg);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.error_code = ErrorCode.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 11) {
                        this.error_msg = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.error_code != null) {
            oprot.writeFieldBegin(ERROR_CODE_FIELD_DESC);
            oprot.writeI32(this.error_code == null ? 0 : this.error_code.getValue());
            oprot.writeFieldEnd();
        }
        if (this.error_msg != null && this.isSetError_msg()) {
            oprot.writeFieldBegin(ERROR_MSG_FIELD_DESC);
            oprot.writeBinary(this.error_msg);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("VerifyClientVersionResp");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("error_code");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getError_code() == null) {
            sb.append("null");
        } else {
            String error_code_name;
            String string = error_code_name = this.getError_code() == null ? "null" : this.getError_code().name();
            if (error_code_name != null) {
                sb.append(error_code_name);
                sb.append(" (");
            }
            sb.append(this.getError_code());
            if (error_code_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (this.isSetError_msg()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("error_msg");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getError_msg() == null) {
                sb.append("null");
            } else {
                int __error_msg_size = Math.min(this.getError_msg().length, 128);
                for (int i = 0; i < __error_msg_size; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(Integer.toHexString(this.getError_msg()[i]).length() > 1 ? Integer.toHexString(this.getError_msg()[i]).substring(Integer.toHexString(this.getError_msg()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getError_msg()[i]).toUpperCase());
                }
                if (this.getError_msg().length > 128) {
                    sb.append(" ...");
                }
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.error_code == null) {
            throw new TProtocolException(6, "Required field 'error_code' was not present! Struct: " + this.toString());
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("error_code", 1, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("error_msg", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(VerifyClientVersionResp.class, metaDataMap);
    }

    public static class Builder {
        private ErrorCode error_code;
        private byte[] error_msg;

        public Builder setError_code(ErrorCode error_code) {
            this.error_code = error_code;
            return this;
        }

        public Builder setError_msg(byte[] error_msg) {
            this.error_msg = error_msg;
            return this;
        }

        public VerifyClientVersionResp build() {
            VerifyClientVersionResp result = new VerifyClientVersionResp();
            result.setError_code(this.error_code);
            result.setError_msg(this.error_msg);
            return result;
        }
    }
}

