/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.logging;

import java.util.HashMap;
import java.util.Map;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.logging.inner.Logger;

public class InnerLoggerFactory
extends InternalLoggerFactory {
    public InnerLoggerFactory() {
        this.doRegister();
    }

    @Override
    protected InternalLogger getLoggerInstance(String name) {
        return new InnerLogger(name);
    }

    @Override
    protected String getLoggerType() {
        return "inner";
    }

    @Override
    protected void shutdown() {
        Logger.getRepository().shutdown();
    }

    public static class MessageFormatter {
        public static FormattingTuple format(String messagePattern, Object arg) {
            return MessageFormatter.arrayFormat(messagePattern, new Object[]{arg});
        }

        public static FormattingTuple format(String messagePattern, Object arg1, Object arg2) {
            return MessageFormatter.arrayFormat(messagePattern, new Object[]{arg1, arg2});
        }

        static Throwable getThrowableCandidate(Object[] argArray) {
            if (argArray != null && argArray.length != 0) {
                Object lastEntry = argArray[argArray.length - 1];
                return lastEntry instanceof Throwable ? (Throwable)lastEntry : null;
            }
            return null;
        }

        public static FormattingTuple arrayFormat(String messagePattern, Object[] argArray) {
            int len;
            Throwable throwableCandidate = MessageFormatter.getThrowableCandidate(argArray);
            if (messagePattern == null) {
                return new FormattingTuple(null, argArray, throwableCandidate);
            }
            if (argArray == null) {
                return new FormattingTuple(messagePattern);
            }
            int i = 0;
            StringBuilder sbuf = new StringBuilder(messagePattern.length() + 50);
            for (len = 0; len < argArray.length; ++len) {
                int j = messagePattern.indexOf("{}", i);
                if (j == -1) {
                    if (i == 0) {
                        return new FormattingTuple(messagePattern, argArray, throwableCandidate);
                    }
                    sbuf.append(messagePattern.substring(i, messagePattern.length()));
                    return new FormattingTuple(sbuf.toString(), argArray, throwableCandidate);
                }
                if (MessageFormatter.isEscapeDelimeter(messagePattern, j)) {
                    if (!MessageFormatter.isDoubleEscaped(messagePattern, j)) {
                        --len;
                        sbuf.append(messagePattern.substring(i, j - 1));
                        sbuf.append('{');
                        i = j + 1;
                        continue;
                    }
                    sbuf.append(messagePattern.substring(i, j - 1));
                    MessageFormatter.deeplyAppendParameter(sbuf, argArray[len], null);
                    i = j + 2;
                    continue;
                }
                sbuf.append(messagePattern.substring(i, j));
                MessageFormatter.deeplyAppendParameter(sbuf, argArray[len], null);
                i = j + 2;
            }
            sbuf.append(messagePattern.substring(i, messagePattern.length()));
            if (len < argArray.length - 1) {
                return new FormattingTuple(sbuf.toString(), argArray, throwableCandidate);
            }
            return new FormattingTuple(sbuf.toString(), argArray, null);
        }

        static boolean isEscapeDelimeter(String messagePattern, int delimeterStartIndex) {
            if (delimeterStartIndex == 0) {
                return false;
            }
            char potentialEscape = messagePattern.charAt(delimeterStartIndex - 1);
            return potentialEscape == '\\';
        }

        static boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
            return delimeterStartIndex >= 2 && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
        }

        private static void deeplyAppendParameter(StringBuilder sbuf, Object o, Map<Object[], Object> seenMap) {
            if (o == null) {
                sbuf.append("null");
            } else if (!o.getClass().isArray()) {
                MessageFormatter.safeObjectAppend(sbuf, o);
            } else if (o instanceof boolean[]) {
                MessageFormatter.booleanArrayAppend(sbuf, (boolean[])o);
            } else if (o instanceof byte[]) {
                MessageFormatter.byteArrayAppend(sbuf, (byte[])o);
            } else if (o instanceof char[]) {
                MessageFormatter.charArrayAppend(sbuf, (char[])o);
            } else if (o instanceof short[]) {
                MessageFormatter.shortArrayAppend(sbuf, (short[])o);
            } else if (o instanceof int[]) {
                MessageFormatter.intArrayAppend(sbuf, (int[])o);
            } else if (o instanceof long[]) {
                MessageFormatter.longArrayAppend(sbuf, (long[])o);
            } else if (o instanceof float[]) {
                MessageFormatter.floatArrayAppend(sbuf, (float[])o);
            } else if (o instanceof double[]) {
                MessageFormatter.doubleArrayAppend(sbuf, (double[])o);
            } else {
                MessageFormatter.objectArrayAppend(sbuf, (Object[])o, seenMap);
            }
        }

        private static void safeObjectAppend(StringBuilder sbuf, Object o) {
            try {
                String t = o.toString();
                sbuf.append(t);
            }
            catch (Throwable var3) {
                System.err.println("RocketMQ InnerLogger: Failed toString() invocation on an object of type [" + o.getClass().getName() + "]");
                var3.printStackTrace();
                sbuf.append("[FAILED toString()]");
            }
        }

        private static void objectArrayAppend(StringBuilder sbuf, Object[] a, Map<Object[], Object> seenMap) {
            if (seenMap == null) {
                seenMap = new HashMap<Object[], Object>();
            }
            sbuf.append('[');
            if (!seenMap.containsKey(a)) {
                seenMap.put(a, null);
                int len = a.length;
                for (int i = 0; i < len; ++i) {
                    MessageFormatter.deeplyAppendParameter(sbuf, a[i], seenMap);
                    if (i == len - 1) continue;
                    sbuf.append(", ");
                }
                seenMap.remove(a);
            } else {
                sbuf.append("...");
            }
            sbuf.append(']');
        }

        private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a) {
            sbuf.append('[');
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(a[i]);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }

        private static void byteArrayAppend(StringBuilder sbuf, byte[] a) {
            sbuf.append('[');
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(a[i]);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }

        private static void charArrayAppend(StringBuilder sbuf, char[] a) {
            sbuf.append('[');
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(a[i]);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }

        private static void shortArrayAppend(StringBuilder sbuf, short[] a) {
            sbuf.append('[');
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(a[i]);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }

        private static void intArrayAppend(StringBuilder sbuf, int[] a) {
            sbuf.append('[');
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(a[i]);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }

        private static void longArrayAppend(StringBuilder sbuf, long[] a) {
            sbuf.append('[');
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(a[i]);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }

        private static void floatArrayAppend(StringBuilder sbuf, float[] a) {
            sbuf.append('[');
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(a[i]);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }

        private static void doubleArrayAppend(StringBuilder sbuf, double[] a) {
            sbuf.append('[');
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(a[i]);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }
    }

    public static class FormattingTuple {
        private String message;
        private Throwable throwable;
        private Object[] argArray;

        public FormattingTuple(String message) {
            this(message, null, null);
        }

        public FormattingTuple(String message, Object[] argArray, Throwable throwable) {
            this.message = message;
            this.throwable = throwable;
            this.argArray = throwable == null ? argArray : FormattingTuple.trimmedCopy(argArray);
        }

        static Object[] trimmedCopy(Object[] argArray) {
            if (argArray != null && argArray.length != 0) {
                int trimemdLen = argArray.length - 1;
                Object[] trimmed = new Object[trimemdLen];
                System.arraycopy(argArray, 0, trimmed, 0, trimemdLen);
                return trimmed;
            }
            throw new IllegalStateException("non-sensical empty or null argument array");
        }

        public String getMessage() {
            return this.message;
        }

        public Object[] getArgArray() {
            return this.argArray;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    public static class InnerLogger
    implements InternalLogger {
        private Logger logger;

        public InnerLogger(String name) {
            this.logger = Logger.getLogger(name);
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public void debug(String var1) {
            this.logger.debug(var1);
        }

        @Override
        public void debug(String var1, Throwable var2) {
            this.logger.debug(var1, var2);
        }

        @Override
        public void info(String var1) {
            this.logger.info(var1);
        }

        @Override
        public void info(String var1, Throwable var2) {
            this.logger.info(var1, var2);
        }

        @Override
        public void warn(String var1) {
            this.logger.warn(var1);
        }

        @Override
        public void warn(String var1, Throwable var2) {
            this.logger.warn(var1, var2);
        }

        @Override
        public void error(String var1) {
            this.logger.error(var1);
        }

        @Override
        public void error(String var1, Throwable var2) {
            this.logger.error(var1, var2);
        }

        @Override
        public void debug(String var1, Object var2) {
            FormattingTuple format = MessageFormatter.format(var1, var2);
            this.logger.debug(format.getMessage(), format.getThrowable());
        }

        @Override
        public void debug(String var1, Object var2, Object var3) {
            FormattingTuple format = MessageFormatter.format(var1, var2, var3);
            this.logger.debug(format.getMessage(), format.getThrowable());
        }

        @Override
        public void debug(String var1, Object ... var2) {
            FormattingTuple format = MessageFormatter.arrayFormat(var1, var2);
            this.logger.debug(format.getMessage(), format.getThrowable());
        }

        @Override
        public void info(String var1, Object var2) {
            FormattingTuple format = MessageFormatter.format(var1, var2);
            this.logger.info(format.getMessage(), format.getThrowable());
        }

        @Override
        public void info(String var1, Object var2, Object var3) {
            FormattingTuple format = MessageFormatter.format(var1, var2, var3);
            this.logger.info(format.getMessage(), format.getThrowable());
        }

        @Override
        public void info(String var1, Object ... var2) {
            FormattingTuple format = MessageFormatter.arrayFormat(var1, var2);
            this.logger.info(format.getMessage(), format.getThrowable());
        }

        @Override
        public void warn(String var1, Object var2) {
            FormattingTuple format = MessageFormatter.format(var1, var2);
            this.logger.warn(format.getMessage(), format.getThrowable());
        }

        @Override
        public void warn(String var1, Object ... var2) {
            FormattingTuple format = MessageFormatter.arrayFormat(var1, var2);
            this.logger.warn(format.getMessage(), format.getThrowable());
        }

        @Override
        public void warn(String var1, Object var2, Object var3) {
            FormattingTuple format = MessageFormatter.format(var1, var2, var3);
            this.logger.warn(format.getMessage(), format.getThrowable());
        }

        @Override
        public void error(String var1, Object var2) {
            FormattingTuple format = MessageFormatter.format(var1, var2);
            this.logger.warn(format.getMessage(), format.getThrowable());
        }

        @Override
        public void error(String var1, Object var2, Object var3) {
            FormattingTuple format = MessageFormatter.format(var1, var2, var3);
            this.logger.warn(format.getMessage(), format.getThrowable());
        }

        @Override
        public void error(String var1, Object ... var2) {
            FormattingTuple format = MessageFormatter.arrayFormat(var1, var2);
            this.logger.warn(format.getMessage(), format.getThrowable());
        }

        public Logger getLogger() {
            return this.logger;
        }
    }
}

