/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

public class TypesUtil {
    static final short REDHORSE_TYPE_NONE = 0;
    static final short REDHORSE_TYPE_NULL = 1;
    static final short REDHORSE_TYPE_BOOLEAN = 2;
    static final short REDHORSE_TYPE_TINYINT = 3;
    static final short REDHORSE_TYPE_SMALLINT = 4;
    static final short REDHORSE_TYPE_INTEGER = 5;
    static final short REDHORSE_TYPE_BIGINT = 6;
    static final short REDHORSE_TYPE_NUMERIC = 7;
    static final short REDHORSE_TYPE_FLOAT = 8;
    static final short REDHORSE_TYPE_DOUBLE = 9;
    static final short REDHORSE_TYPE_DATE = 10;
    static final short REDHORSE_TYPE_TIME = 11;
    static final short REDHORSE_TYPE_TIME_TZ = 12;
    static final short REDHORSE_TYPE_DATETIME = 13;
    static final short REDHORSE_TYPE_DATETIME_TZ = 14;
    static final short REDHORSE_TYPE_INTERVAL_Y = 15;
    static final short REDHORSE_TYPE_INTERVAL_Y2M = 16;
    static final short REDHORSE_TYPE_INTERVAL_M = 17;
    static final short REDHORSE_TYPE_INTERVAL_D = 18;
    static final short REDHORSE_TYPE_INTERVAL_D2H = 19;
    static final short REDHORSE_TYPE_INTERVAL_H = 20;
    static final short REDHORSE_TYPE_INTERVAL_D2M = 21;
    static final short REDHORSE_TYPE_INTERVAL_H2M = 22;
    static final short REDHORSE_TYPE_INTERVAL_MI = 23;
    static final short REDHORSE_TYPE_INTERVAL_D2S = 24;
    static final short REDHORSE_TYPE_INTERVAL_H2S = 25;
    static final short REDHORSE_TYPE_INTERVAL_M2S = 26;
    static final short REDHORSE_TYPE_INTERVAL_S = 27;
    static final short REDHORSE_TYPE_ROWVERSION = 28;
    static final short REDHORSE_TYPE_GUID = 29;
    static final short REDHORSE_TYPE_CHAR = 30;
    static final short REDHORSE_TYPE_CLOB = 32;
    static final short REDHORSE_TYPE_BINARY = 33;
    static final short REDHORSE_TYPE_BLOB = 34;
    static final short REDHORSE_TYPE_GEOMETRY_OLD = 35;
    static final short REDHORSE_TYPE_POINT_OLD = 36;
    static final short REDHORSE_TYPE_BOX_OLD = 37;
    static final short REDHORSE_TYPE_LINE_OLD = 38;
    static final short REDHORSE_TYPE_POLYGON_OLD = 39;
    static final short REDHORSE_TYPE_BLOB_I = 40;
    static final short REDHORSE_TYPE_BLOB_S = 41;
    static final short REDHORSE_TYPE_BLOB_M = 42;
    static final short REDHORSE_TYPE_BLOB_OM = 43;
    static final short REDHORSE_TYPE_STREAM = 44;
    static final short REDHORSE_TYPE_ROWID = 45;
    static final short REDHORSE_TYPE_SIBLING = 46;
    static final short REDHORSE_TYPE_JSON = 47;
    static final short REDHORSE_TYPE_POINT = 48;
    static final short REDHORSE_TYPE_LSEG = 49;
    static final short REDHORSE_TYPE_LINE = 50;
    static final short REDHORSE_TYPE_BOX = 51;
    static final short REDHORSE_TYPE_PATH = 52;
    static final short REDHORSE_TYPE_POLYGON = 53;
    static final short REDHORSE_TYPE_CIRCLE = 54;
    static final short REDHORSE_TYPE_GEOMETRY = 55;
    static final short REDHORSE_TYPE_GEOGRAPHY = 56;
    static final short REDHORSE_TYPE_BOX2D = 57;
    static final short REDHORSE_TYPE_BOX3D = 58;
    static final short REDHORSE_TYPE_SPHEROID = 59;
    static final short REDHORSE_TYPE_RASTER = 60;
    static final short REDHORSE_TYPE_ST_END = 61;
    static final short REDHORSE_TYPE_BIT = 62;
    static final short REDHORSE_TYPE_VARBIT = 63;
    static final short REDHORSE_TYPE_XML = 64;
    static final short REDHORSE_TYPE_ARRAY = 65;
    static final short REDHORSE_TYPE_BLADE_BEGIN = 101;
    static final short REDHORSE_TYPE_BLADE_END = 1000;
    static final short REDHORSE_TYPE_OBJECT = 1001;
    static final short REDHORSE_TYPE_REFROW = 1002;
    static final short REDHORSE_TYPE_RECORD = 1003;
    static final short REDHORSE_TYPE_VARRAY = 1004;
    static final short REDHORSE_TYPE_TABLE = 1005;
    static final short REDHORSE_TYPE_ITABLE = 1006;
    static final short REDHORSE_TYPE_CURSOR = 1007;
    static final short REDHORSE_TYPE_REFCUR = 1008;
    static final short REDHORSE_TYPE_ROWTYPE = 1009;
    static final short REDHORSE_TYPE_COLTYPE = 1010;
    static final short REDHORSE_TYPE_CUR_REC = 1011;
    static final short REDHORSE_TYPE_PARAM = 1012;
    static final short REDHORSE_TYPE_MAX_ALL = 1013;
    static final short REDHORSE_TYPE_ARRAY_NONE = 10000;
    static final short REDHORSE_TYPE_ARRAY_NULL = 10001;
    static final short REDHORSE_TYPE_ARRAY_BOOLEAN = 10002;
    static final short REDHORSE_TYPE_ARRAY_TINYINT = 10003;
    static final short REDHORSE_TYPE_ARRAY_SMALLINT = 10004;
    static final short REDHORSE_TYPE_ARRAY_INTEGER = 10005;
    static final short REDHORSE_TYPE_ARRAY_BIGINT = 10006;
    static final short REDHORSE_TYPE_ARRAY_NUMERIC = 10007;
    static final short REDHORSE_TYPE_ARRAY_FLOAT = 10008;
    static final short REDHORSE_TYPE_ARRAY_DOUBLE = 10009;
    static final short REDHORSE_TYPE_ARRAY_DATE = 10010;
    static final short REDHORSE_TYPE_ARRAY_TIME = 10011;
    static final short REDHORSE_TYPE_ARRAY_TIME_TZ = 10012;
    static final short REDHORSE_TYPE_ARRAY_DATETIME = 10013;
    static final short REDHORSE_TYPE_ARRAY_DATETIME_TZ = 10014;
    static final short REDHORSE_TYPE_ARRAY_INTERVAL_Y = 10015;
    static final short REDHORSE_TYPE_ARRAY_INTERVAL_Y2M = 10016;
    static final short REDHORSE_TYPE_ARRAY_INTERVAL_M = 10017;
    static final short REDHORSE_TYPE_ARRAY_INTERVAL_D = 10018;
    static final short REDHORSE_TYPE_ARRAY_INTERVAL_D2H = 10019;
    static final short REDHORSE_TYPE_ARRAY_INTERVAL_H = 10020;
    static final short REDHORSE_TYPE_ARRAY_INTERVAL_D2M = 10021;
    static final short REDHORSE_TYPE_ARRAY_INTERVAL_H2M = 10022;
    static final short REDHORSE_TYPE_ARRAY_INTERVAL_MI = 10023;
    static final short REDHORSE_TYPE_ARRAY_INTERVAL_D2S = 10024;
    static final short REDHORSE_TYPE_ARRAY_INTERVAL_H2S = 10025;
    static final short REDHORSE_TYPE_ARRAY_INTERVAL_M2S = 10026;
    static final short REDHORSE_TYPE_ARRAY_INTERVAL_S = 10027;
    static final short REDHORSE_TYPE_ARRAY_ROWVERSION = 10028;
    static final short REDHORSE_TYPE_ARRAY_GUID = 10029;
    static final short REDHORSE_TYPE_ARRAY_CHAR = 10030;
    static final short REDHORSE_TYPE_ARRAY_NCHAR = 10031;
    static final short REDHORSE_TYPE_ARRAY_CLOB = 10032;
    static final short REDHORSE_TYPE_ARRAY_BINARY = 10033;
    static final short REDHORSE_TYPE_ARRAY_BLOB = 10034;
    static final short REDHORSE_TYPE_ARRAY_GEOMETRY_OLD = 10035;
    static final short REDHORSE_TYPE_ARRAY_POINT_OLD = 10036;
    static final short REDHORSE_TYPE_ARRAY_BOX_OLD = 10037;
    static final short REDHORSE_TYPE_ARRAY_LINE_OLD = 10038;
    static final short REDHORSE_TYPE_ARRAY_POLYGON_OLD = 10039;
    static final short REDHORSE_TYPE_ARRAY_BLOB_I = 10040;
    static final short REDHORSE_TYPE_ARRAY_BLOB_S = 10041;
    static final short REDHORSE_TYPE_ARRAY_BLOB_M = 10042;
    static final short REDHORSE_TYPE_ARRAY_BLOB_OM = 10043;
    static final short REDHORSE_TYPE_ARRAY_STREAM = 10044;
    static final short REDHORSE_TYPE_ARRAY_ROWID = 10045;
    static final short REDHORSE_TYPE_ARRAY_SIBLING = 10046;
    static final short REDHORSE_TYPE_ARRAY_JSON = 10047;
    static final short REDHORSE_TYPE_ARRAY_POINT = 10048;
    static final short REDHORSE_TYPE_ARRAY_LSEG = 10049;
    static final short REDHORSE_TYPE_ARRAY_LINE = 10050;
    static final short REDHORSE_TYPE_ARRAY_BOX = 10051;
    static final short REDHORSE_TYPE_ARRAY_PATH = 10052;
    static final short REDHORSE_TYPE_ARRAY_POLYGON = 10053;
    static final short REDHORSE_TYPE_ARRAY_CIRCLE = 10054;
    static final short REDHORSE_TYPE_ARRAY_GEOMETRY = 10055;
    static final short REDHORSE_TYPE_ARRAY_GEOGRAPHY = 10056;
    static final short REDHORSE_TYPE_ARRAY_BOX2D = 10057;
    static final short REDHORSE_TYPE_ARRAY_BOX3D = 10058;
    static final short REDHORSE_TYPE_ARRAY_SPHEROID = 10059;
    static final short REDHORSE_TYPE_ARRAY_RASTER = 10060;
    static final short REDHORSE_TYPE_ARRAY_ST_END = 10061;
    static final short REDHORSE_TYPE_ARRAY_BIT = 10062;
    static final short REDHORSE_TYPE_ARRAY_VARBIT = 10063;
    static final short REDHORSE_TYPE_ARRAY_MAX_SYS = 10064;
    static final short REDHORSE_TYPE_ARRAY_BLADE_BEGIN = 10101;
    static final short REDHORSE_TYPE_ARRAY_BLADE_END = 11000;
    static final short REDHORSE_TYPE_ARRAY_OBJECT = 11001;
    static final short REDHORSE_TYPE_ARRAY_REFROW = 11002;
    static final short REDHORSE_TYPE_ARRAY_RECORD = 11003;
    static final short REDHORSE_TYPE_ARRAY_TYPE_VARRAY = 11004;
    static final short REDHORSE_TYPE_ARRAY_TABLE = 11005;
    static final short REDHORSE_TYPE_ARRAY_ITABLE = 11006;
    static final short REDHORSE_TYPE_ARRAY_CURSOR = 11007;
    static final short REDHORSE_TYPE_ARRAY_REFCUR = 11008;
    static final short REDHORSE_TYPE_ARRAY_ROWTYPE = 11009;
    static final short REDHORSE_TYPE_ARRAY_COLTYPE = 11010;
    static final short REDHORSE_TYPE_ARRAY_CUR_REC = 11011;
    static final short REDHORSE_TYPE_ARRAY_PARAM = 11012;
    static final short REDHORSE_TYPE_ARRAY_MAX_ALL = 11013;

    public static int toJavaType(int redhorseType) {
        int jdbcType;
        if (redhorseType > 10000) {
            jdbcType = 2003;
        } else {
            switch (redhorseType) {
                case 1: {
                    jdbcType = 0;
                    break;
                }
                case 3: {
                    jdbcType = -6;
                    break;
                }
                case 4: {
                    jdbcType = 5;
                    break;
                }
                case 5: {
                    jdbcType = 4;
                    break;
                }
                case 6: {
                    jdbcType = -5;
                    break;
                }
                case 8: {
                    jdbcType = 6;
                    break;
                }
                case 9: {
                    jdbcType = 8;
                    break;
                }
                case 7: {
                    jdbcType = 2;
                    break;
                }
                case 2: {
                    jdbcType = 16;
                    break;
                }
                case 30: {
                    jdbcType = 12;
                    break;
                }
                case 10: {
                    jdbcType = 91;
                    break;
                }
                case 11: {
                    jdbcType = 92;
                    break;
                }
                case 12: {
                    jdbcType = 3200;
                    break;
                }
                case 13: {
                    jdbcType = 93;
                    break;
                }
                case 14: {
                    jdbcType = 3100;
                    break;
                }
                case 24: {
                    jdbcType = 3010;
                    break;
                }
                case 16: {
                    jdbcType = 3007;
                    break;
                }
                case 15: {
                    jdbcType = 3001;
                    break;
                }
                case 17: {
                    jdbcType = 3002;
                    break;
                }
                case 18: {
                    jdbcType = 3003;
                    break;
                }
                case 20: {
                    jdbcType = 3004;
                    break;
                }
                case 23: {
                    jdbcType = 3005;
                    break;
                }
                case 27: {
                    jdbcType = 3006;
                    break;
                }
                case 19: {
                    jdbcType = 3008;
                    break;
                }
                case 21: {
                    jdbcType = 3009;
                    break;
                }
                case 22: {
                    jdbcType = 3011;
                    break;
                }
                case 25: {
                    jdbcType = 3012;
                    break;
                }
                case 26: {
                    jdbcType = 3013;
                    break;
                }
                case 33: {
                    jdbcType = -2;
                    break;
                }
                case 34: {
                    jdbcType = 2004;
                    break;
                }
                case 32: {
                    jdbcType = 2005;
                    break;
                }
                case 28: {
                    jdbcType = 3399;
                    break;
                }
                case 29: {
                    jdbcType = 3400;
                    break;
                }
                case 1008: {
                    jdbcType = -10;
                    break;
                }
                case 1007: {
                    jdbcType = -11;
                    break;
                }
                case 45: {
                    jdbcType = -8;
                    break;
                }
                case 1001: {
                    jdbcType = 3600;
                    break;
                }
                case 1003: {
                    jdbcType = 3601;
                    break;
                }
                case 1004: {
                    jdbcType = 3602;
                    break;
                }
                case 1005: {
                    jdbcType = 3603;
                    break;
                }
                case 47: {
                    jdbcType = 3700;
                    break;
                }
                case 48: {
                    jdbcType = 3701;
                    break;
                }
                case 50: {
                    jdbcType = 3703;
                    break;
                }
                case 49: {
                    jdbcType = 3702;
                    break;
                }
                case 51: {
                    jdbcType = 3704;
                    break;
                }
                case 52: {
                    jdbcType = 3705;
                    break;
                }
                case 53: {
                    jdbcType = 3706;
                    break;
                }
                case 54: {
                    jdbcType = 3707;
                    break;
                }
                case 55: {
                    jdbcType = 3708;
                    break;
                }
                case 56: {
                    jdbcType = 3709;
                    break;
                }
                case 57: {
                    jdbcType = 3710;
                    break;
                }
                case 58: {
                    jdbcType = 3711;
                    break;
                }
                case 59: {
                    jdbcType = 3712;
                    break;
                }
                case 60: {
                    jdbcType = 3713;
                    break;
                }
                case 64: {
                    jdbcType = 3714;
                    break;
                }
                case 62: {
                    jdbcType = -7;
                    break;
                }
                case 63: {
                    jdbcType = 3800;
                    break;
                }
                case 65: {
                    jdbcType = 2003;
                    break;
                }
                default: {
                    jdbcType = 12;
                }
            }
        }
        return jdbcType;
    }

    public static int toJavaArrayType(int redhorseType) {
        return TypesUtil.toJavaType(redhorseType - 10000) + 10000;
    }

    public static String getRedhorseTypeName(int redhorseType) {
        if (redhorseType > 10000) {
            return "ARRAY";
        }
        switch (redhorseType) {
            case 1: {
                return "NULL";
            }
            case 3: {
                return "TINYINT";
            }
            case 4: {
                return "SMALLINT";
            }
            case 5: {
                return "INTEGER";
            }
            case 6: {
                return "BIGINT";
            }
            case 8: {
                return "FLOAT";
            }
            case 9: {
                return "DOUBLE";
            }
            case 7: {
                return "NUMERIC";
            }
            case 2: {
                return "BOOLEAN";
            }
            case 30: {
                return "VARCHAR";
            }
            case 10: {
                return "DATE";
            }
            case 11: {
                return "TIME";
            }
            case 12: {
                return "TIME WITH TIME ZONE";
            }
            case 13: {
                return "DATETIME";
            }
            case 14: {
                return "DATETIME WITH TIME ZONE";
            }
            case 24: {
                return "INTERVAL DAY TO SECOND";
            }
            case 16: {
                return "INTERVAL YEAR TO MONTH";
            }
            case 15: {
                return "INTERVAL YEAR";
            }
            case 17: {
                return "INTERVAL MONTH";
            }
            case 18: {
                return "INTERVAL DAY";
            }
            case 20: {
                return "INTERVAL HOUR";
            }
            case 23: {
                return "INTERVAL MINUTE";
            }
            case 27: {
                return "INTERVAL SECOND";
            }
            case 19: {
                return "INTERVAL DAY TO HOUR";
            }
            case 21: {
                return "INTERVAL DAY TO MINUTE";
            }
            case 22: {
                return "INTERVAL HOUR TO MINUTE";
            }
            case 25: {
                return "INTERVAL HOUR TO SECOND";
            }
            case 26: {
                return "INTERVAL MINUTE TO SECOND";
            }
            case 33: {
                return "BINARY";
            }
            case 32: {
                return "CLOB";
            }
            case 34: {
                return "BLOB";
            }
            case 29: {
                return "GUID";
            }
            case 1008: {
                return "REFCUR";
            }
            case 1007: {
                return "CURSOR";
            }
            case 45: {
                return "ROWID";
            }
            case 28: {
                return "ROWVERSION";
            }
            case 1001: {
                return "UDTOBJECT";
            }
            case 1003: {
                return "UDTRECORD";
            }
            case 1004: {
                return "UDTVARRAY";
            }
            case 1005: {
                return "UDTTABLE";
            }
            case 47: {
                return "JSON";
            }
            case 48: {
                return "POINT";
            }
            case 50: {
                return "LINE";
            }
            case 49: {
                return "LSEG";
            }
            case 51: {
                return "BOX";
            }
            case 52: {
                return "PATH";
            }
            case 53: {
                return "POLYGON";
            }
            case 54: {
                return "CIRCLE";
            }
            case 55: {
                return "GEOMETRY";
            }
            case 56: {
                return "GEOGRAPHY";
            }
            case 57: {
                return "BOX2D";
            }
            case 58: {
                return "BOX3D";
            }
            case 59: {
                return "SPHEROID";
            }
            case 60: {
                return "RASTER";
            }
            case 64: {
                return "XML";
            }
            case 62: {
                return "BIT";
            }
            case 63: {
                return "VARBIT";
            }
            case 65: {
                return "ARRAY";
            }
        }
        return null;
    }

    public static String getRedhorseArrayTypeName(int redhorseType) {
        return TypesUtil.getRedhorseTypeName(redhorseType - 10000) + "[]";
    }

    public static String getClassName(int redhorseType) {
        if (redhorseType > 10000) {
            return "java.sql.Array";
        }
        String no_type = "There is no referrible type in java types";
        switch (redhorseType) {
            case 1: {
                return null;
            }
            case 62: {
                return "java.lang.Byte";
            }
            case 63: {
                return "java.lang.Byte";
            }
            case 3: {
                return "java.lang.Long";
            }
            case 4: {
                return "java.lang.Short";
            }
            case 5: {
                return "java.lang.Integer";
            }
            case 6: {
                return "java.lang.Long";
            }
            case 8: {
                return "java.lang.Float";
            }
            case 9: {
                return "java.lang.Double";
            }
            case 7: {
                return "java.math.BigDecimal";
            }
            case 2: {
                return "java.lang.Boolean";
            }
            case 30: {
                return "java.lang.String";
            }
            case 10: {
                return "java.sql.Date";
            }
            case 11: {
                return "java.sql.Time";
            }
            case 13: {
                return "java.sql.Timestamp";
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 1007: 
            case 1008: {
                return no_type;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 45: 
            case 1001: 
            case 1003: 
            case 1004: 
            case 1005: {
                return "java.lang.String";
            }
            case 33: {
                return "java.sql.Blob";
            }
            case 34: {
                return "java.sql.Blob";
            }
            case 32: {
                return "java.sql.Clob";
            }
            case 65: {
                return "java.sql.Array";
            }
        }
        return null;
    }

    public static String getArrayClassName(int redhorseType) {
        if (redhorseType > 10000) {
            return "java.sql.Array";
        }
        return TypesUtil.getClassName(redhorseType);
    }

    public static short toRedhorseType(int javaType) {
        short redhorseType;
        switch (javaType) {
            case -16: 
            case -15: 
            case -9: 
            case 0: 
            case 1: 
            case 12: 
            case 2003: {
                redhorseType = 30;
                break;
            }
            case -7: {
                redhorseType = 62;
                break;
            }
            case 3800: {
                redhorseType = 63;
                break;
            }
            case -6: {
                redhorseType = 3;
                break;
            }
            case 5: {
                redhorseType = 4;
                break;
            }
            case 4: {
                redhorseType = 5;
                break;
            }
            case -5: {
                redhorseType = 6;
                break;
            }
            case 6: 
            case 7: {
                redhorseType = 8;
                break;
            }
            case 8: {
                redhorseType = 9;
                break;
            }
            case 2: 
            case 3: {
                redhorseType = 7;
                break;
            }
            case 3399: {
                redhorseType = 28;
                break;
            }
            case 91: {
                redhorseType = 10;
                break;
            }
            case 92: {
                redhorseType = 11;
                break;
            }
            case 93: {
                redhorseType = 13;
                break;
            }
            case 3100: {
                redhorseType = 14;
                break;
            }
            case 3200: {
                redhorseType = 12;
                break;
            }
            case 3001: {
                redhorseType = 15;
                break;
            }
            case 3002: {
                redhorseType = 17;
                break;
            }
            case 3003: {
                redhorseType = 18;
                break;
            }
            case 3004: {
                redhorseType = 20;
                break;
            }
            case 3005: {
                redhorseType = 23;
                break;
            }
            case 3006: {
                redhorseType = 27;
                break;
            }
            case 3007: {
                redhorseType = 16;
                break;
            }
            case 3008: {
                redhorseType = 19;
                break;
            }
            case 3009: {
                redhorseType = 21;
                break;
            }
            case 3010: {
                redhorseType = 24;
                break;
            }
            case 3011: {
                redhorseType = 22;
                break;
            }
            case 3012: {
                redhorseType = 25;
                break;
            }
            case 3013: {
                redhorseType = 26;
                break;
            }
            case -2: {
                redhorseType = 33;
                break;
            }
            case -3: {
                redhorseType = 33;
                break;
            }
            case -4: 
            case 2004: 
            case 3500: {
                redhorseType = 34;
                break;
            }
            case 2005: 
            case 2011: 
            case 3700: {
                redhorseType = 32;
                break;
            }
            case 16: {
                redhorseType = 2;
                break;
            }
            case 3400: {
                redhorseType = 29;
                break;
            }
            case -10: {
                redhorseType = 1008;
                break;
            }
            case -11: {
                redhorseType = 1007;
                break;
            }
            case -8: {
                redhorseType = 45;
                break;
            }
            case 3600: {
                redhorseType = 1001;
                break;
            }
            case 3601: {
                redhorseType = 1003;
                break;
            }
            case 3602: {
                redhorseType = 1004;
                break;
            }
            case 3603: {
                redhorseType = 1005;
                break;
            }
            case 3701: {
                redhorseType = 48;
                break;
            }
            case 3703: {
                redhorseType = 50;
                break;
            }
            case 3702: {
                redhorseType = 49;
                break;
            }
            case 3704: {
                redhorseType = 51;
                break;
            }
            case 3705: {
                redhorseType = 52;
                break;
            }
            case 3706: {
                redhorseType = 53;
                break;
            }
            case 3707: {
                redhorseType = 54;
                break;
            }
            case 3708: {
                redhorseType = 55;
                break;
            }
            case 3709: {
                redhorseType = 56;
                break;
            }
            case 3710: {
                redhorseType = 57;
                break;
            }
            case 3711: {
                redhorseType = 58;
                break;
            }
            case 3712: {
                redhorseType = 59;
                break;
            }
            case 3713: {
                redhorseType = 60;
                break;
            }
            default: {
                redhorseType = 0;
            }
        }
        return redhorseType;
    }

    public static short toRedhorseArrayType(int javaType) {
        short redhorseType = javaType > 10000 ? TypesUtil.toRedhorseType(javaType - 10000) : TypesUtil.toRedhorseType(javaType);
        return redhorseType;
    }

    public static int getRedhorseType(String redhorseTypeName) {
        if (redhorseTypeName.equalsIgnoreCase("null")) {
            return 1;
        }
        if (redhorseTypeName.equalsIgnoreCase("BOOLEAN")) {
            return 2;
        }
        if (redhorseTypeName.equalsIgnoreCase("TINYINT")) {
            return 3;
        }
        if (redhorseTypeName.equalsIgnoreCase("SMALLINT")) {
            return 4;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTEGER")) {
            return 5;
        }
        if (redhorseTypeName.equalsIgnoreCase("BIGINT")) {
            return 6;
        }
        if (redhorseTypeName.equalsIgnoreCase("NUMERIC")) {
            return 7;
        }
        if (redhorseTypeName.equalsIgnoreCase("FLOAT")) {
            return 8;
        }
        if (redhorseTypeName.equalsIgnoreCase("DOUBLE")) {
            return 9;
        }
        if (redhorseTypeName.equalsIgnoreCase("DATE")) {
            return 10;
        }
        if (redhorseTypeName.equalsIgnoreCase("TIME")) {
            return 11;
        }
        if (redhorseTypeName.equalsIgnoreCase("TIME WITH TIME ZONE")) {
            return 12;
        }
        if (redhorseTypeName.equalsIgnoreCase("DATETIME")) {
            return 13;
        }
        if (redhorseTypeName.equalsIgnoreCase("DATETIME WITH TIME ZONE")) {
            return 14;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL YEAR")) {
            return 15;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL YEAR TO MONTH")) {
            return 16;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL MONTH")) {
            return 17;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL DAY")) {
            return 18;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL DAY TO HOUR")) {
            return 19;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL HOUR")) {
            return 20;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL DAY TO MINUTE")) {
            return 21;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL HOUR TO MINUTE")) {
            return 22;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL MINUTE")) {
            return 23;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL DAY TO SECOND")) {
            return 24;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL HOUR TO SECOND")) {
            return 25;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL MINUTE TO SECOND")) {
            return 26;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL SECOND")) {
            return 27;
        }
        if (redhorseTypeName.equalsIgnoreCase("ROWVERSION")) {
            return 28;
        }
        if (redhorseTypeName.equalsIgnoreCase("GUID")) {
            return 29;
        }
        if (redhorseTypeName.equalsIgnoreCase("CHAR")) {
            return 30;
        }
        if (redhorseTypeName.equalsIgnoreCase("CLOB")) {
            return 32;
        }
        if (redhorseTypeName.equalsIgnoreCase("BINARY")) {
            return 33;
        }
        if (redhorseTypeName.equalsIgnoreCase("BLOB")) {
            return 34;
        }
        if (redhorseTypeName.equalsIgnoreCase("ROWID")) {
            return 45;
        }
        if (redhorseTypeName.equalsIgnoreCase("JSON")) {
            return 47;
        }
        if (redhorseTypeName.equalsIgnoreCase("POINT")) {
            return 48;
        }
        if (redhorseTypeName.equalsIgnoreCase("LSEG")) {
            return 49;
        }
        if (redhorseTypeName.equalsIgnoreCase("LINE")) {
            return 50;
        }
        if (redhorseTypeName.equalsIgnoreCase("BOX")) {
            return 51;
        }
        if (redhorseTypeName.equalsIgnoreCase("PATH")) {
            return 52;
        }
        if (redhorseTypeName.equalsIgnoreCase("POLYGON")) {
            return 53;
        }
        if (redhorseTypeName.equalsIgnoreCase("CIRCLE")) {
            return 54;
        }
        if (redhorseTypeName.equalsIgnoreCase("BIT")) {
            return 62;
        }
        if (redhorseTypeName.equalsIgnoreCase("VARBIT")) {
            return 63;
        }
        if (redhorseTypeName.equalsIgnoreCase("XML")) {
            return 64;
        }
        if (redhorseTypeName.equalsIgnoreCase("ARRAY")) {
            return 65;
        }
        if (redhorseTypeName.equalsIgnoreCase("VARCHAR")) {
            return 30;
        }
        if (redhorseTypeName.equalsIgnoreCase("TIMESTAMP")) {
            return 13;
        }
        if (redhorseTypeName.equalsIgnoreCase("REFCUR")) {
            return 1008;
        }
        if (redhorseTypeName.equalsIgnoreCase("CURSOR")) {
            return 1007;
        }
        if (redhorseTypeName.equalsIgnoreCase("IMAGE")) {
            return 34;
        }
        if (redhorseTypeName.equalsIgnoreCase("UDTOBJECT")) {
            return 1001;
        }
        if (redhorseTypeName.equalsIgnoreCase("UDTRECORD")) {
            return 1003;
        }
        if (redhorseTypeName.equalsIgnoreCase("UDTVARRAY")) {
            return 1004;
        }
        if (redhorseTypeName.equalsIgnoreCase("GEOMETRY")) {
            return 55;
        }
        if (redhorseTypeName.equalsIgnoreCase("GEOGRAPHY")) {
            return 56;
        }
        if (redhorseTypeName.equalsIgnoreCase("BOX2D")) {
            return 57;
        }
        if (redhorseTypeName.equalsIgnoreCase("BOX3D")) {
            return 58;
        }
        if (redhorseTypeName.equalsIgnoreCase("SPHEROID")) {
            return 59;
        }
        if (redhorseTypeName.equalsIgnoreCase("RASTER")) {
            return 60;
        }
        if (redhorseTypeName.equalsIgnoreCase("UDTTABLE")) {
            return 1005;
        }
        return -1000;
    }

    public static int getRedhorseArrayType(String redhorseArrayTypeName) {
        int redhorseType;
        if (redhorseArrayTypeName.contains("[") && redhorseArrayTypeName.contains("]")) {
            String redhorseTypeName = redhorseArrayTypeName.replace("[", "").replace("]", "");
            redhorseType = TypesUtil.getRedhorseType(redhorseTypeName);
        } else {
            redhorseType = TypesUtil.getRedhorseType(redhorseArrayTypeName);
        }
        return redhorseType + 10000;
    }
}

