/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.queue.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hertzbeat.common.entity.log.LogEntry;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnProperty(prefix="common.queue", name={"type"}, havingValue="memory", matchIfMissing=true)
@Primary
public class InMemoryCommonDataQueue
implements CommonDataQueue,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(InMemoryCommonDataQueue.class);
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToAlertQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToStorageQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<CollectRep.MetricsData> serviceDiscoveryDataQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<LogEntry> logEntryQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<LogEntry> logEntryToStorageQueue = new LinkedBlockingQueue();

    public Map<String, Integer> getQueueSizeMetricsInfo() {
        HashMap<String, Integer> metrics = new HashMap<String, Integer>(8);
        metrics.put("metricsDataToAlertQueue", this.metricsDataToAlertQueue.size());
        metrics.put("metricsDataToStorageQueue", this.metricsDataToStorageQueue.size());
        metrics.put("logEntryQueue", this.logEntryQueue.size());
        metrics.put("logEntryToStorageQueue", this.logEntryToStorageQueue.size());
        return metrics;
    }

    @Override
    public CollectRep.MetricsData pollServiceDiscoveryData() throws InterruptedException {
        return this.serviceDiscoveryDataQueue.take();
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToAlerter() throws InterruptedException {
        return this.metricsDataToAlertQueue.take();
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToStorage() throws InterruptedException {
        return this.metricsDataToStorageQueue.take();
    }

    @Override
    public void sendMetricsData(CollectRep.MetricsData metricsData) {
        this.metricsDataToAlertQueue.offer(metricsData);
    }

    @Override
    public void sendMetricsDataToStorage(CollectRep.MetricsData metricsData) {
        this.metricsDataToStorageQueue.offer(metricsData);
    }

    @Override
    public void sendServiceDiscoveryData(CollectRep.MetricsData metricsData) {
        this.serviceDiscoveryDataQueue.offer(metricsData);
    }

    @Override
    public void sendLogEntry(LogEntry logEntry) {
        this.logEntryQueue.offer(logEntry);
    }

    @Override
    public LogEntry pollLogEntry() throws InterruptedException {
        return this.logEntryQueue.take();
    }

    @Override
    public void sendLogEntryToStorage(LogEntry logEntry) {
        this.logEntryToStorageQueue.offer(logEntry);
    }

    @Override
    public LogEntry pollLogEntryToStorage() throws InterruptedException {
        return this.logEntryToStorageQueue.take();
    }

    @Override
    public void sendLogEntryToAlertBatch(List<LogEntry> logEntries) {
        if (logEntries == null || logEntries.isEmpty()) {
            return;
        }
        for (LogEntry logEntry : logEntries) {
            this.logEntryQueue.offer(logEntry);
        }
    }

    @Override
    public List<LogEntry> pollLogEntryToAlertBatch(int maxBatchSize) throws InterruptedException {
        ArrayList<LogEntry> batch = new ArrayList<LogEntry>(maxBatchSize);
        LogEntry first = this.logEntryQueue.poll(1L, TimeUnit.SECONDS);
        if (first != null) {
            batch.add(first);
            this.logEntryQueue.drainTo(batch, maxBatchSize - 1);
        }
        return batch;
    }

    @Override
    public void sendLogEntryToStorageBatch(List<LogEntry> logEntries) {
        if (logEntries == null || logEntries.isEmpty()) {
            return;
        }
        for (LogEntry logEntry : logEntries) {
            this.logEntryToStorageQueue.offer(logEntry);
        }
    }

    @Override
    public List<LogEntry> pollLogEntryToStorageBatch(int maxBatchSize) throws InterruptedException {
        ArrayList<LogEntry> batch = new ArrayList<LogEntry>(maxBatchSize);
        LogEntry first = this.logEntryToStorageQueue.poll(1L, TimeUnit.SECONDS);
        if (first != null) {
            batch.add(first);
            this.logEntryToStorageQueue.drainTo(batch, maxBatchSize - 1);
        }
        return batch;
    }

    public void destroy() {
        this.metricsDataToAlertQueue.clear();
        this.metricsDataToStorageQueue.clear();
        this.serviceDiscoveryDataQueue.clear();
        this.logEntryQueue.clear();
        this.logEntryToStorageQueue.clear();
    }
}

