/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.serialize;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.hertzbeat.common.entity.log.LogEntry;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaLogEntrySerializer
implements Serializer<LogEntry> {
    private static final Logger log = LoggerFactory.getLogger(KafkaLogEntrySerializer.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(configs, isKey);
    }

    public byte[] serialize(String topic, LogEntry logEntry) {
        if (logEntry == null) {
            log.warn("LogEntry is null for topic: {}", (Object)topic);
            return null;
        }
        try {
            String jsonString = this.objectMapper.writeValueAsString((Object)logEntry);
            return jsonString.getBytes(StandardCharsets.UTF_8);
        }
        catch (JsonProcessingException e) {
            log.error("Failed to serialize LogEntry to JSON for topic: {}", (Object)topic, (Object)e);
            return null;
        }
    }

    public byte[] serialize(String topic, Headers headers, LogEntry logEntry) {
        return this.serialize(topic, logEntry);
    }

    public void close() {
        super.close();
    }
}

