/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractIntervalPartitionFrameCursor;
import io.questdb.cairo.TimestampFinder;
import io.questdb.cairo.sql.PartitionFrame;
import io.questdb.griffin.model.RuntimeIntrinsicIntervalModel;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;

public class IntervalFwdPartitionFrameCursor
extends AbstractIntervalPartitionFrameCursor {
    private static final Log LOG = LogFactory.getLog(IntervalFwdPartitionFrameCursor.class);

    public IntervalFwdPartitionFrameCursor(RuntimeIntrinsicIntervalModel intervalModel, int timestampIndex) {
        super(intervalModel, timestampIndex);
    }

    @Override
    public PartitionFrame next(long skipTarget) {
        while (this.intervalsLo < this.intervalsHi && this.partitionLo < this.partitionHi) {
            long rowCount = this.reader.getPartitionRowCountFromMetadata(this.partitionLo);
            if (rowCount > 0L) {
                long hi;
                TimestampFinder timestampFinder = this.initTimestampFinder(this.partitionLo, rowCount);
                long intervalLo = this.intervals.getQuick(this.intervalsLo * 2);
                long intervalHi = this.intervals.getQuick(this.intervalsLo * 2 + 1);
                long partitionTimestampLoApprox = timestampFinder.minTimestampApproxFromMetadata();
                if (partitionTimestampLoApprox > intervalHi) {
                    ++this.intervalsLo;
                    continue;
                }
                long partitionTimestampHiApprox = timestampFinder.maxTimestampApproxFromMetadata();
                if (partitionTimestampHiApprox < intervalLo) {
                    this.partitionLimit = 0L;
                    ++this.partitionLo;
                    continue;
                }
                LOG.debug().$("next [partition=").$(this.partitionLo).$(", intervalLo=").microTime(intervalLo).$(", intervalHi=").microTime(intervalHi).$(", partitionHi=").microTime(partitionTimestampHiApprox).$(", partitionLimit=").$(this.partitionLimit).$(", rowCount=").$(rowCount).I$();
                this.reader.openPartition(this.partitionLo);
                timestampFinder.prepare();
                long partitionTimestampLoExact = timestampFinder.minTimestampExact();
                if (partitionTimestampLoExact > intervalHi) {
                    ++this.intervalsLo;
                    continue;
                }
                long partitionTimestampHiExact = timestampFinder.maxTimestampExact();
                if (partitionTimestampHiExact < intervalLo) {
                    this.partitionLimit = 0L;
                    ++this.partitionLo;
                    continue;
                }
                long lo = partitionTimestampLoExact < intervalLo ? timestampFinder.findTimestamp(intervalLo - 1L, this.partitionLimit, rowCount - 1L) + 1L : 0L;
                if (lo < (hi = partitionTimestampHiExact > intervalHi ? timestampFinder.findTimestamp(intervalHi, lo, rowCount - 1L) + 1L : rowCount)) {
                    this.frame.partitionIndex = this.partitionLo;
                    this.frame.rowLo = lo;
                    this.frame.rowHi = hi;
                    this.sizeSoFar += hi - lo;
                    byte format = this.reader.getPartitionFormat(this.partitionLo);
                    if (format == 1) {
                        assert (this.parquetDecoder.getFileAddr() != -1L) : "parquet decoder is not initialized";
                        this.frame.format = 1;
                        this.frame.parquetDecoder = this.parquetDecoder;
                    } else {
                        assert (format == 0);
                        this.frame.format = 0;
                        this.frame.parquetDecoder = null;
                    }
                    if (hi == rowCount) {
                        this.partitionLimit = 0L;
                        ++this.partitionLo;
                    } else {
                        this.partitionLimit = hi;
                        ++this.intervalsLo;
                    }
                    return this.frame;
                }
                this.partitionLimit = hi;
                ++this.intervalsLo;
                continue;
            }
            ++this.partitionLo;
        }
        return null;
    }

    @Override
    public void toTop() {
        super.toTop();
        this.partitionLimit = 0L;
    }
}

