/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableToken;
import io.questdb.std.Mutable;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public interface SecurityContext
extends Mutable {
    public static final byte AUTH_TYPE_CREDENTIALS = 1;
    public static final byte AUTH_TYPE_JWK_TOKEN = 2;
    public static final byte AUTH_TYPE_NONE = 0;

    public void authorizeAlterTableAddColumn(TableToken var1);

    public void authorizeAlterTableAddIndex(TableToken var1, @NotNull ObjList<CharSequence> var2);

    public void authorizeAlterTableAlterColumnCache(TableToken var1, @NotNull ObjList<CharSequence> var2);

    public void authorizeAlterTableAlterColumnType(TableToken var1, @NotNull ObjList<CharSequence> var2);

    public void authorizeAlterTableAttachPartition(TableToken var1);

    public void authorizeAlterTableDedupDisable(TableToken var1);

    public void authorizeAlterTableDedupEnable(TableToken var1);

    public void authorizeAlterTableDetachPartition(TableToken var1);

    public void authorizeAlterTableDropColumn(TableToken var1, @NotNull ObjList<CharSequence> var2);

    public void authorizeAlterTableDropIndex(TableToken var1, @NotNull ObjList<CharSequence> var2);

    public void authorizeAlterTableDropPartition(TableToken var1);

    public void authorizeAlterTableRenameColumn(TableToken var1, @NotNull ObjList<CharSequence> var2);

    public void authorizeAlterTableSetType(TableToken var1);

    public void authorizeCopyCancel(SecurityContext var1);

    public void authorizeDatabaseSnapshot();

    public void authorizeHttp();

    public void authorizeInsert(TableToken var1);

    public void authorizeLineTcp();

    public void authorizeMatViewCreate();

    public void authorizeMatViewDrop(TableToken var1);

    public void authorizeMatViewRefresh(TableToken var1);

    public void authorizePGWire();

    public void authorizeResumeWal(TableToken var1);

    public void authorizeSelect(TableToken var1, @NotNull ObjList<CharSequence> var2);

    public void authorizeSelectOnAnyColumn(TableToken var1);

    public void authorizeSettings();

    public void authorizeSqlEngineAdmin();

    public void authorizeSystemAdmin();

    public void authorizeTableBackup(ObjHashSet<TableToken> var1);

    public void authorizeTableCreate();

    public void authorizeTableDrop(TableToken var1);

    public void authorizeTableReindex(TableToken var1, @NotNull ObjList<CharSequence> var2);

    public void authorizeTableRename(TableToken var1);

    public void authorizeTableTruncate(TableToken var1);

    public void authorizeTableUpdate(TableToken var1, @NotNull ObjList<CharSequence> var2);

    public void authorizeTableVacuum(TableToken var1);

    public void checkEntityEnabled();

    @Override
    default public void clear() {
    }

    default public CharSequence getAssumedServiceAccount() {
        CharSequence principal = this.getPrincipal();
        CharSequence sessionPrincipal = this.getSessionPrincipal();
        return sessionPrincipal == null || sessionPrincipal.equals(principal) ? null : principal;
    }

    public CharSequence getPrincipal();

    default public CharSequence getSessionPrincipal() {
        return this.getPrincipal();
    }

    default public boolean isExternal() {
        return false;
    }

    default public boolean isQueryCancellationAllowed() {
        return true;
    }

    public boolean isSystemAdmin();
}

