/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnTypeDriver;
import io.questdb.cairo.O3CopyJob;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryOM;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.std.FilesFacade;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8SplitString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VarcharTypeDriver
implements ColumnTypeDriver {
    public static final VarcharTypeDriver INSTANCE = new VarcharTypeDriver();
    public static final int VARCHAR_AUX_WIDTH_BYTES = 16;
    public static final int VARCHAR_HEADER_FLAG_NULL = 4;
    public static final int VARCHAR_INLINED_PREFIX_BYTES = 6;
    public static final long VARCHAR_INLINED_PREFIX_MASK = 0xFFFFFFFFFFFFL;
    public static final int VARCHAR_MAX_BYTES_FULLY_INLINED = 9;
    public static final long VARCHAR_MAX_COLUMN_SIZE = 0x1000000000000L;
    private static final int FULLY_INLINED_STRING_OFFSET = 1;
    private static final int HEADER_FLAGS_WIDTH = 4;
    private static final int HEADER_FLAG_ASCII = 2;
    private static final int HEADER_FLAG_INLINED = 1;
    private static final int INLINED_LENGTH_MASK = 15;
    private static final int INLINED_PREFIX_OFFSET = 4;
    private static final int LENGTH_LIMIT_BYTES = 0x10000000;
    private static final int DATA_LENGTH_MASK = 0xFFFFFFF;

    public static void appendPlainValue(long dataMemAddr, @Nullable Utf8Sequence value, boolean eraseAsciiFlag) {
        if (value == null) {
            Unsafe.getUnsafe().putInt(dataMemAddr, -1);
            return;
        }
        int hi = value.size();
        value.writeTo(dataMemAddr + 4L, 0, hi);
        if (eraseAsciiFlag) {
            Unsafe.getUnsafe().putInt(dataMemAddr, hi);
        } else {
            boolean ascii = value.isAscii();
            Unsafe.getUnsafe().putInt(dataMemAddr, ascii ? hi | Integer.MIN_VALUE : hi);
        }
    }

    public static void appendPlainValue(MemoryA dataMem, @Nullable Utf8Sequence value) {
        if (value == null) {
            dataMem.putInt(-1);
            return;
        }
        int size = value.size();
        dataMem.putInt(value.isAscii() ? size | Integer.MIN_VALUE : size);
        dataMem.putVarchar(value, 0, size);
    }

    public static void appendValue(MemoryA auxMem, MemoryA dataMem, @Nullable Utf8Sequence value) {
        long offset;
        if (value != null) {
            int size = value.size();
            if (size <= 9) {
                int flags = 1;
                if (value.isAscii()) {
                    flags |= 2;
                }
                auxMem.putByte((byte)(size << 4 | flags));
                auxMem.putVarchar(value, 0, size);
                for (int i = size; i < 9; ++i) {
                    auxMem.putByte((byte)0);
                }
                offset = dataMem.getAppendOffset();
            } else {
                if (size >= 0x10000000) {
                    throw CairoException.critical(0).put("varchar value is too long [size=").put(size).put(", max=").put(0x10000000L).put(']');
                }
                int flags = 0;
                if (value.isAscii()) {
                    flags |= 2;
                }
                auxMem.putInt(size << 4 | flags);
                auxMem.putVarchar(value, 0, 6);
                offset = dataMem.putVarchar(value, 0, size);
                if (offset >= 0x1000000000000L) {
                    throw CairoException.critical(0).put("varchar data column is too large [offset=").put(offset).put(", max=").put(0x1000000000000L).put(']');
                }
            }
        } else {
            auxMem.putInt(4);
            auxMem.putInt(0);
            auxMem.putShort((short)0);
            offset = dataMem.getAppendOffset();
        }
        auxMem.putShort((short)offset);
        auxMem.putInt((int)(offset >> 16));
    }

    public static long getDataVectorSize(MemoryR auxMem, long offset) {
        int raw = auxMem.getInt(offset);
        assert (raw != 0);
        long dataOffset = VarcharTypeDriver.getDataOffset(auxMem, offset);
        if (VarcharTypeDriver.hasNullOrInlinedFlag(raw)) {
            return dataOffset;
        }
        int size = raw >> 4 & 0xFFFFFFF;
        return dataOffset + (long)size;
    }

    public static Utf8Sequence getPlainValue(@NotNull MemoryR dataMem, long offset) {
        long address = dataMem.addressOf(offset);
        int header = Unsafe.getUnsafe().getInt(address);
        assert (header != 0);
        return VarcharTypeDriver.isNull(header) ? null : dataMem.getDirectVarchar(offset + 4L, VarcharTypeDriver.size(header), VarcharTypeDriver.isAscii(header));
    }

    public static DirectUtf8Sequence getPlainValue(long dataMemAddr, @NotNull DirectUtf8String sequence) {
        int header = Unsafe.getUnsafe().getInt(dataMemAddr);
        if (VarcharTypeDriver.isNull(header)) {
            return null;
        }
        return sequence.of(dataMemAddr + 4L, dataMemAddr + 4L + (long)VarcharTypeDriver.size(header), VarcharTypeDriver.isAscii(header));
    }

    public static int getPlainValueSize(MemoryR dataMem, long offset) {
        int header = dataMem.getInt(offset);
        if (VarcharTypeDriver.isNull(header)) {
            return -1;
        }
        return VarcharTypeDriver.size(header);
    }

    public static int getPlainValueSize(long dataMemAddr) {
        int header = Unsafe.getUnsafe().getInt(dataMemAddr);
        if (VarcharTypeDriver.isNull(header)) {
            return -1;
        }
        return VarcharTypeDriver.size(header);
    }

    public static int getSingleMemValueByteCount(@Nullable Utf8Sequence value) {
        return value != null ? 4 + value.size() : 4;
    }

    public static Utf8Sequence getSplitValue(MemoryCR auxMem, MemoryCR dataMem, long rowNum, int ab) {
        long auxOffset = 16L * rowNum;
        int raw = auxMem.getInt(auxOffset);
        assert (raw != 0);
        if (VarcharTypeDriver.hasNullFlag(raw)) {
            return null;
        }
        boolean isAscii = VarcharTypeDriver.hasAsciiFlag(raw);
        if (VarcharTypeDriver.hasInlinedFlag(raw)) {
            long auxLo = auxMem.addressOf(auxOffset + 1L);
            long auxLim = auxMem.addressHi();
            int size = raw >> 4 & 0xF;
            assert (size <= 9);
            return ab == 1 ? auxMem.getSplitVarcharA(auxLo, auxLo, auxLim, size, isAscii) : auxMem.getSplitVarcharB(auxLo, auxLo, auxLim, size, isAscii);
        }
        long auxLo = auxMem.addressOf(auxOffset + 4L);
        long dataLo = dataMem.addressOf(VarcharTypeDriver.getDataOffset(auxMem, auxOffset));
        long dataLim = dataMem.addressHi();
        int size = raw >> 4 & 0xFFFFFFF;
        return ab == 1 ? auxMem.getSplitVarcharA(auxLo, dataLo, dataLim, size, isAscii) : auxMem.getSplitVarcharB(auxLo, dataLo, dataLim, size, isAscii);
    }

    public static Utf8Sequence getSplitValue(long auxAddr, long auxLim, long dataAddr, long dataLim, long rowNum, Utf8SplitString utf8SplitView) {
        long auxEntry = auxAddr + 16L * rowNum;
        int raw = Unsafe.getUnsafe().getInt(auxEntry);
        assert (raw != 0);
        if (VarcharTypeDriver.hasNullFlag(raw)) {
            return null;
        }
        boolean isAscii = VarcharTypeDriver.hasAsciiFlag(raw);
        if (VarcharTypeDriver.hasInlinedFlag(raw)) {
            long auxLo = auxEntry + 1L;
            int size = raw >> 4 & 0xF;
            assert (size <= 9);
            return utf8SplitView.of(auxLo, auxLo, auxLim, size, isAscii);
        }
        long auxLo = auxEntry + 4L;
        long dataLo = dataAddr + VarcharTypeDriver.getDataOffset(auxEntry);
        int size = raw >> 4 & 0xFFFFFFF;
        return utf8SplitView.of(auxLo, dataLo, dataLim, size, isAscii);
    }

    public static int getValueSize(long auxAddr, long rowNum) {
        if (rowNum < 0L) {
            return -1;
        }
        long auxEntry = auxAddr + 16L * rowNum;
        int raw = Unsafe.getUnsafe().getInt(auxEntry);
        if (VarcharTypeDriver.hasNullFlag(raw)) {
            return -1;
        }
        if (VarcharTypeDriver.hasInlinedFlag(raw)) {
            return raw >> 4 & 0xF;
        }
        return raw >> 4 & 0xFFFFFFF;
    }

    public static int getValueSize(MemoryR auxMem, long rowNum) {
        if (rowNum < 0L) {
            return -1;
        }
        long auxOffset = 16L * rowNum;
        int raw = auxMem.getInt(auxOffset);
        if (VarcharTypeDriver.hasNullFlag(raw)) {
            return -1;
        }
        if (VarcharTypeDriver.hasInlinedFlag(raw)) {
            return raw >> 4 & 0xF;
        }
        return raw >> 4 & 0xFFFFFFF;
    }

    @Override
    public void appendNull(MemoryA auxMem, MemoryA dataMem) {
        VarcharTypeDriver.appendValue(auxMem, dataMem, null);
    }

    @Override
    public long auxRowsToBytes(long rowCount) {
        return 16L * rowCount;
    }

    @Override
    public void configureAuxMemMA(MemoryMA auxMem) {
    }

    @Override
    public void configureAuxMemMA(FilesFacade ff, MemoryMA auxMem, LPSZ fileName, long dataAppendPageSize, int memoryTag, int opts, int madviseOpts) {
        auxMem.of(ff, fileName, dataAppendPageSize, -1L, 12, opts, madviseOpts);
    }

    @Override
    public void configureAuxMemO3RSS(MemoryARW auxMem) {
    }

    @Override
    public void configureAuxMemOM(FilesFacade ff, MemoryOM auxMem, long fd, LPSZ fileName, long rowLo, long rowHi, int memoryTag, int opts) {
        auxMem.ofOffset(ff, fd, false, fileName, 16L * rowLo, 16L * rowHi, memoryTag, opts);
    }

    @Override
    public void configureDataMemOM(FilesFacade ff, MemoryR auxMem, MemoryOM dataMem, long dataFd, LPSZ fileName, long rowLo, long rowHi, int memoryTag, int opts) {
        long lo = rowLo > 0L ? VarcharTypeDriver.getDataOffset(auxMem, 16L * rowLo) : 0L;
        long hi = rowHi > 0L ? VarcharTypeDriver.getDataVectorSize(auxMem, 16L * (rowHi - 1L)) : 0L;
        dataMem.ofOffset(ff, dataFd, false, fileName, lo, hi, memoryTag, opts);
    }

    @Override
    public long dedupMergeVarColumnSize(long mergeIndexAddr, long mergeIndexCount, long srcDataFixAddr, long srcOooFixAddr) {
        return Vect.dedupMergeVarcharColumnSize(mergeIndexAddr, mergeIndexCount, srcDataFixAddr, srcOooFixAddr);
    }

    @Override
    public long getAuxVectorOffset(long row) {
        return 16L * row;
    }

    @Override
    public long getAuxVectorSize(long storageRowCount) {
        return 16L * storageRowCount;
    }

    @Override
    public long getDataVectorMinEntrySize() {
        return 0L;
    }

    @Override
    public long getDataVectorOffset(long auxMemAddr, long row) {
        long auxEntry = auxMemAddr + 16L * row;
        assert (Unsafe.getUnsafe().getInt(auxEntry) != 0);
        return VarcharTypeDriver.getDataOffset(auxEntry);
    }

    @Override
    public long getDataVectorSize(long auxMemAddr, long rowLo, long rowHi) {
        if (rowLo > rowHi) {
            return 0L;
        }
        if (rowLo > 0L) {
            return this.getDataVectorSizeAt(auxMemAddr, rowHi) - this.getDataVectorOffset(auxMemAddr, rowLo);
        }
        return this.getDataVectorSizeAt(auxMemAddr, rowHi);
    }

    @Override
    public long getDataVectorSizeAt(long auxMemAddr, long row) {
        return VarcharTypeDriver.getDataVectorSize(auxMemAddr + 16L * row);
    }

    @Override
    public long getDataVectorSizeAtFromFd(FilesFacade ff, long auxFd, long row) {
        long auxFileOffset = 16L * row;
        if (row < 0L) {
            return 0L;
        }
        int raw = VarcharTypeDriver.readInt(ff, auxFd, auxFileOffset);
        int offsetLo = VarcharTypeDriver.readInt(ff, auxFd, auxFileOffset + 8L);
        int offsetHi = VarcharTypeDriver.readInt(ff, auxFd, auxFileOffset + 12L);
        long dataOffset = Numbers.encodeLowHighInts(offsetLo, offsetHi) >>> 16;
        if (VarcharTypeDriver.hasNullOrInlinedFlag(raw)) {
            return dataOffset;
        }
        int size = raw >> 4 & 0xFFFFFFF;
        return dataOffset + (long)size;
    }

    @Override
    public long getMinAuxVectorSize() {
        return 0L;
    }

    @Override
    public boolean isSparseDataVector(long auxMemAddr, long dataMemAddr, long rowCount) {
        long lastSizeInDataVector = 0L;
        int row = 0;
        while ((long)row < rowCount) {
            long offset = this.getDataVectorOffset(auxMemAddr, row);
            if (offset != lastSizeInDataVector) {
                return true;
            }
            lastSizeInDataVector = this.getDataVectorSizeAt(auxMemAddr, row);
            ++row;
        }
        return false;
    }

    @Override
    public long mergeShuffleColumnFromManyAddresses(long indexFormat, long primaryAddressList, long secondaryAddressList, long outPrimaryAddress, long outSecondaryAddress, long mergeIndex, long destDataOffset, long destDataSize) {
        return Vect.mergeShuffleVarcharColumnFromManyAddresses(indexFormat, primaryAddressList, secondaryAddressList, outPrimaryAddress, outSecondaryAddress, mergeIndex, destDataOffset, destDataSize);
    }

    @Override
    public void o3ColumnMerge(long timestampMergeIndexAddr, long timestampMergeIndexCount, long srcAuxAddr1, long srcDataAddr1, long srcAuxAddr2, long srcDataAddr2, long dstAuxAddr, long dstDataAddr, long dstDataOffset) {
        Vect.oooMergeCopyVarcharColumn(timestampMergeIndexAddr, timestampMergeIndexCount, srcAuxAddr1, srcDataAddr1, srcAuxAddr2, srcDataAddr2, dstAuxAddr, dstDataAddr, dstDataOffset);
    }

    @Override
    public void o3copyAuxVector(FilesFacade ff, long srcAddr, long srcLo, long srcHi, long dstAddr, long dstFileOffset, long dstFd, boolean mixedIOFlag) {
        O3CopyJob.copyFixedSizeCol(ff, srcAddr, srcLo, srcHi, dstAddr, dstFileOffset, dstFd, 4, mixedIOFlag);
    }

    @Override
    public void o3sort(long sortedTimestampsAddr, long sortedTimestampsRowCount, MemoryCR srcDataMem, MemoryCR srcAuxMem, MemoryCARW dstDataMem, MemoryCARW dstAuxMem) {
        long srcDataAddr = srcDataMem.addressOf(0L);
        long srcAuxAddr = srcAuxMem.addressOf(0L);
        long tgtAuxAddr = dstAuxMem.resize(this.getAuxVectorSize(sortedTimestampsRowCount));
        long tgtDataAddr = dstDataMem.resize(this.getDataVectorSizeAt(srcAuxAddr, sortedTimestampsRowCount - 1L));
        assert (srcAuxAddr != 0L);
        assert (tgtAuxAddr != 0L);
        long offset = Vect.sortVarcharColumn(sortedTimestampsAddr, sortedTimestampsRowCount, srcDataAddr, srcAuxAddr, tgtDataAddr, tgtAuxAddr);
        dstDataMem.jumpTo(offset);
        dstAuxMem.jumpTo(16L * sortedTimestampsRowCount);
    }

    @Override
    public long setAppendAuxMemAppendPosition(MemoryMA auxMem, MemoryMA dataMem, int columnType, long rowCount) {
        if (rowCount > 0L) {
            auxMem.jumpTo(16L * (rowCount - 1L));
            long dataMemOffset = VarcharTypeDriver.getDataVectorSize(auxMem.getAppendAddress());
            auxMem.jumpTo(16L * rowCount);
            return dataMemOffset;
        }
        auxMem.jumpTo(0L);
        return 0L;
    }

    @Override
    public long setAppendPosition(long pos, MemoryMA auxMem, MemoryMA dataMem) {
        if (pos > 0L) {
            long auxVectorOffset = this.getAuxVectorOffset(pos - 1L);
            auxMem.jumpTo(auxVectorOffset);
            long auxEntryPtr = auxMem.getAppendAddress();
            long dataVectorSize = VarcharTypeDriver.getDataVectorSize(auxEntryPtr);
            long auxVectorSize = this.getAuxVectorSize(pos);
            long totalDataSizeBytes = dataVectorSize + auxVectorSize;
            auxVectorOffset = this.getAuxVectorOffset(pos);
            auxMem.jumpTo(auxVectorOffset);
            dataMem.jumpTo(dataVectorSize);
            return totalDataSizeBytes;
        }
        dataMem.jumpTo(0L);
        auxMem.jumpTo(0L);
        return 0L;
    }

    @Override
    public void setDataVectorEntriesToNull(long dataMemAddr, long rowCount) {
    }

    @Override
    public void setFullAuxVectorNull(long auxMemAddr, long rowCount) {
        Vect.setVarcharColumnNullRefs(auxMemAddr, 0L, rowCount);
    }

    @Override
    public void setPartAuxVectorNull(long auxMemAddr, long initialOffset, long columnTop) {
        Vect.setVarcharColumnNullRefs(auxMemAddr, initialOffset, columnTop);
    }

    @Override
    public void shiftCopyAuxVector(long shift, long srcAddr, long srcLo, long srcHi, long dstAddr, long dstAddrSize) {
        assert ((srcHi - srcLo + 1L) * 16L <= dstAddrSize);
        Vect.shiftCopyVarcharColumnAux(shift, srcAddr, srcLo, srcHi, dstAddr);
    }

    private static long getDataOffset(long auxEntry) {
        return Unsafe.getUnsafe().getLong(auxEntry + 8L) >>> 16;
    }

    private static long getDataOffset(MemoryR auxMem, long offset) {
        return auxMem.getLong(offset + 8L) >>> 16;
    }

    private static long getDataVectorSize(long auxEntry) {
        int raw = Unsafe.getUnsafe().getInt(auxEntry);
        assert (raw != 0);
        long dataOffset = VarcharTypeDriver.getDataOffset(auxEntry);
        if (VarcharTypeDriver.hasNullOrInlinedFlag(raw)) {
            return dataOffset;
        }
        int size = raw >> 4 & 0xFFFFFFF;
        assert (size > 9) : String.format("size %,d <= %d, dataOffset %,d", size, 9, dataOffset);
        return dataOffset + (long)size;
    }

    private static boolean hasAsciiFlag(int auxHeader) {
        return (auxHeader & 2) == 2;
    }

    private static boolean hasInlinedFlag(int auxHeader) {
        return (auxHeader & 1) == 1;
    }

    private static boolean hasNullFlag(int auxHeader) {
        return (auxHeader & 4) == 4;
    }

    private static boolean hasNullOrInlinedFlag(int auxHeader) {
        return (auxHeader & 5) != 0;
    }

    private static boolean isAscii(int header) {
        return (header & Integer.MIN_VALUE) != 0;
    }

    private static boolean isNull(int header) {
        return header == -1;
    }

    private static int readInt(FilesFacade ff, long fd, long offset) {
        long res = ff.readIntAsUnsignedLong(fd, offset);
        if (res < 0L) {
            throw CairoException.critical(ff.errno()).put("Invalid data read from varchar aux file [fd=").put(fd).put(", offset=").put(offset).put(", fileSize=").put(ff.length(fd)).put(", result=").put(res).put(']');
        }
        return Numbers.decodeLowInt(res);
    }

    private static int size(int header) {
        return header & Integer.MAX_VALUE;
    }
}

