/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mv;

import io.questdb.cairo.TableToken;
import io.questdb.mp.ValueHolder;

public class MatViewRefreshTask
implements ValueHolder<MatViewRefreshTask> {
    public static final int FULL_REFRESH = 1;
    public static final int INCREMENTAL_REFRESH = 0;
    public static final int INVALIDATE = 3;
    public static final int RANGE_REFRESH = 2;
    public static final int UNDEFINED = -1;
    public static final int UPDATE_REFRESH_INTERVALS = 4;
    public TableToken baseTableToken;
    public String invalidationReason;
    public TableToken matViewToken;
    public int operation = -1;
    public long rangeFrom = Long.MIN_VALUE;
    public long rangeTo = Long.MIN_VALUE;
    public long refreshTriggerTimestamp = Long.MIN_VALUE;

    public static String getRefreshOperationName(int operation) {
        switch (operation) {
            case 0: {
                return "incremental_refresh";
            }
            case 1: {
                return "full_refresh";
            }
            case 2: {
                return "range_refresh";
            }
            case 3: {
                return "invalidate";
            }
        }
        return "unknown";
    }

    public static boolean isRefreshOperation(int operation) {
        return operation == 0 || operation == 2 || operation == 1;
    }

    @Override
    public void clear() {
        this.operation = -1;
        this.baseTableToken = null;
        this.matViewToken = null;
        this.invalidationReason = null;
        this.refreshTriggerTimestamp = Long.MIN_VALUE;
        this.rangeFrom = Long.MIN_VALUE;
        this.rangeTo = Long.MIN_VALUE;
    }

    @Override
    public void copyTo(MatViewRefreshTask anotherHolder) {
        anotherHolder.operation = this.operation;
        anotherHolder.baseTableToken = this.baseTableToken;
        anotherHolder.matViewToken = this.matViewToken;
        anotherHolder.invalidationReason = this.invalidationReason;
        anotherHolder.refreshTriggerTimestamp = this.refreshTriggerTimestamp;
        anotherHolder.rangeFrom = this.rangeFrom;
        anotherHolder.rangeTo = this.rangeTo;
    }

    public boolean isBaseTableTask() {
        return this.matViewToken == null;
    }
}

