/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm.api;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.BorrowedArray;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryC;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.std.BinarySequence;
import io.questdb.std.DirectByteSequenceView;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectString;

public interface MemoryCR
extends MemoryC,
MemoryR {
    public long addressHi();

    default public boolean checkOffsetMapped(long offset) {
        return offset <= this.size();
    }

    default public ArrayView getArray(long offset, BorrowedArray array) {
        return ArrayTypeDriver.getPlainValue(this.addressOf(offset), array);
    }

    default public BinarySequence getBin(long offset, DirectByteSequenceView view) {
        long addr = this.addressOf(offset);
        long len = Unsafe.getUnsafe().getLong(addr);
        if (len > -1L) {
            return view.of(addr + 8L, len);
        }
        return null;
    }

    @Override
    default public long getBinLen(long offset) {
        return this.getLong(offset);
    }

    @Override
    default public boolean getBool(long offset) {
        return this.getByte(offset) == 1;
    }

    @Override
    default public byte getByte(long offset) {
        if (!1.$assertionsDisabled && this.addressOf(offset + 1L) <= 0L) {
            throw new AssertionError();
        }
        return Unsafe.getUnsafe().getByte(this.addressOf(offset));
    }

    @Override
    default public char getChar(long offset) {
        if (!1.$assertionsDisabled && this.addressOf(offset + 2L) <= 0L) {
            throw new AssertionError();
        }
        return Unsafe.getUnsafe().getChar(this.addressOf(offset));
    }

    @Override
    default public double getDouble(long offset) {
        if (!1.$assertionsDisabled && this.addressOf(offset + 8L) <= 0L) {
            throw new AssertionError();
        }
        return Unsafe.getUnsafe().getDouble(this.addressOf(offset));
    }

    public long getFd();

    @Override
    default public float getFloat(long offset) {
        if (!1.$assertionsDisabled && this.addressOf(offset + 4L) <= 0L) {
            throw new AssertionError();
        }
        return Unsafe.getUnsafe().getFloat(this.addressOf(offset));
    }

    @Override
    default public int getIPv4(long offset) {
        return this.getInt(offset);
    }

    @Override
    default public int getInt(long offset) {
        if (!1.$assertionsDisabled && this.addressOf(offset + 4L) <= 0L) {
            throw new AssertionError();
        }
        return Unsafe.getUnsafe().getInt(this.addressOf(offset));
    }

    @Override
    default public long getLong(long offset) {
        if (!(1.$assertionsDisabled || offset > -1L && this.addressOf(offset + 8L) > 0L)) {
            throw new AssertionError();
        }
        return Unsafe.getUnsafe().getLong(this.addressOf(offset));
    }

    @Override
    default public void getLong256(long offset, CharSink<?> sink) {
        long addr = this.addressOf(offset + 32L);
        Numbers.appendLong256FromUnsafe(addr - 32L, sink);
    }

    @Override
    default public long getPageSize() {
        return this.size();
    }

    @Override
    default public short getShort(long offset) {
        return Unsafe.getUnsafe().getShort(this.addressOf(offset));
    }

    default public DirectString getStr(long offset, DirectString view) {
        long addr = this.addressOf(offset);
        if (!1.$assertionsDisabled && addr <= 0L) {
            throw new AssertionError();
        }
        if (!this.checkOffsetMapped(offset + 4L)) {
            throw CairoException.critical(0).put("string is outside of file boundary [offset=").put(offset).put(", size=").put(this.size()).put(']');
        }
        int len = Unsafe.getUnsafe().getInt(addr);
        if (len != -1) {
            if (this.checkOffsetMapped(Vm.getStorageLength(len) + offset)) {
                return view.of(addr + 4L, len);
            }
            throw CairoException.critical(0).put("string is outside of file boundary [offset=").put(offset).put(", len=").put(len).put(", size=").put(this.size()).put(']');
        }
        return null;
    }

    @Override
    default public int getStrLen(long offset) {
        return this.getInt(offset);
    }

    default public boolean isFileBased() {
        return false;
    }

    default public void map() {
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

