/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cairo.wal.WalApplySqlExecutionContext;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.bind.BindVariableServiceImpl;
import io.questdb.griffin.engine.ops.AbstractOperation;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.std.Misc;
import io.questdb.std.Rnd;
import java.io.Closeable;

class OperationExecutor
implements Closeable {
    private final BindVariableService bindVariableService;
    private final CairoEngine engine;
    private final WalApplySqlExecutionContext executionContext;
    private final Rnd rnd = new Rnd();

    OperationExecutor(CairoEngine engine, int sharedQueryWorkerCount) {
        this.bindVariableService = new BindVariableServiceImpl(engine.getConfiguration());
        this.executionContext = new WalApplySqlExecutionContext(engine, sharedQueryWorkerCount);
        this.executionContext.with(engine.getConfiguration().getFactoryProvider().getSecurityContextFactory().getRootContext(), this.bindVariableService, this.rnd, -1L, null);
        this.engine = engine;
    }

    @Override
    public void close() {
        Misc.free(this.executionContext);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public String executeAlter(TableWriter tableWriter, CharSequence alterSql, long seqTxn) throws SqlException {
        tableToken = tableWriter.getTableToken();
        try {
            compiler = this.engine.getSqlCompiler();
            try {
                block19: {
                    this.executionContext.remapTableNameResolutionTo(tableToken);
                    stallCount = 0;
                    while (true) {
                        try {
                            compiledQuery = compiler.compile(alterSql, this.executionContext);
                        }
                        catch (TableReferenceOutOfDateException ex) {
                            updatedToken = this.engine.getUpdatedTableToken(tableToken);
                            if (updatedToken != null && !updatedToken.equals(tableToken)) {
                                tableWriter.updateTableToken(updatedToken);
                                this.executionContext.remapTableNameResolutionTo(updatedToken);
                                continue;
                            }
                            if (stallCount++ > 10) ** break;
                            continue;
                            throw ex;
                        }
                        break;
                    }
                    alterOp = compiledQuery.getAlterOperation();
                    try {
                        alterOp.withContext(this.executionContext);
                        if (!OperationExecutor.$assertionsDisabled && alterOp.isStructural()) {
                            throw new AssertionError((Object)"alter operation must not be structural when applied as SQL");
                        }
                        tableWriter.apply((AbstractOperation)alterOp, seqTxn);
                        var10_11 = alterOp.matViewInvalidationReason();
                        if (alterOp == null) break block19;
                    }
                    catch (Throwable var10_12) {
                        if (alterOp != null) {
                            try {
                                alterOp.close();
                            }
                            catch (Throwable var11_15) {
                                var10_12.addSuppressed(var11_15);
                            }
                        }
                        throw var10_12;
                    }
                    alterOp.close();
                }
                return var10_11;
            }
            finally {
                if (compiler != null) {
                    compiler.close();
                }
            }
        }
        catch (SqlException ex) {
            tableWriter.markSeqTxnCommitted(seqTxn);
            throw ex;
        }
    }

    public long executeUpdate(TableWriter tableWriter, CharSequence updateSql, long seqTxn) throws SqlException {
        TableToken tableToken = tableWriter.getTableToken();
        try (SqlCompiler compiler = this.engine.getSqlCompiler();){
            this.executionContext.remapTableNameResolutionTo(tableToken);
            CompiledQuery compiledQuery = compiler.compile(updateSql, this.executionContext);
            UpdateOperation updateOperation = compiledQuery.getUpdateOperation();
            try {
                updateOperation.withSqlStatement(updateSql);
                updateOperation.withContext(this.executionContext);
                long l = tableWriter.apply(updateOperation, seqTxn);
                if (updateOperation != null) {
                    updateOperation.close();
                }
                return l;
            }
            catch (Throwable throwable) {
                if (updateOperation != null) {
                    try {
                        updateOperation.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public BindVariableService getBindVariableService() {
        return this.bindVariableService;
    }

    public void resetRnd(long seed0, long seed1) {
        this.rnd.reset(seed0, seed1);
    }

    public void setNowAndFixClock(long now) {
        this.executionContext.setNowAndFixClock(now);
    }
}

