/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal.seq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.MemorySerializer;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.cairo.wal.seq.TableTransactionLogFile;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class TableTransactionLogV1
implements TableTransactionLogFile {
    private static final Log LOG = LogFactory.getLog(TableTransactionLogV1.class);
    private static final ThreadLocal<TransactionLogCursorImpl> tlTransactionLogCursor = new ThreadLocal();
    public static long RECORD_SIZE = 28L;
    private final CairoConfiguration configuration;
    private final FilesFacade ff;
    private final AtomicLong maxTxn = new AtomicLong();
    private final MemoryCMARW txnMem = Vm.getCMARWInstance();

    public TableTransactionLogV1(CairoConfiguration configuration) {
        this.configuration = configuration;
        this.ff = configuration.getFilesFacade();
    }

    public static long readMaxStructureVersion(long logFileFd, FilesFacade ff) {
        long maxTxn = ff.readNonNegativeLong(logFileFd, 4L);
        if (maxTxn < 0L) {
            return -1L;
        }
        long offset = 76L + (maxTxn - 1L) * RECORD_SIZE;
        return ff.readNonNegativeLong(logFileFd, offset);
    }

    @Override
    public long addEntry(long structureVersion, int walId, int segmentId, int segmentTxn, long timestamp, long txnMinTimestamp, long txnMaxTimestamp, long txnRowCount) {
        this.txnMem.putLong(structureVersion);
        this.txnMem.putInt(walId);
        this.txnMem.putInt(segmentId);
        this.txnMem.putInt(segmentTxn);
        this.txnMem.putLong(timestamp);
        Unsafe.getUnsafe().storeFence();
        long maxTxn = this.maxTxn.incrementAndGet();
        this.txnMem.putLong(4L, maxTxn);
        this.sync0();
        return maxTxn;
    }

    @Override
    public void beginMetadataChangeEntry(long newStructureVersion, MemorySerializer serializer, Object instance, long timestamp) {
        this.txnMem.putLong(newStructureVersion);
        this.txnMem.putInt(-1);
        this.txnMem.putInt(-1);
        this.txnMem.putInt(-1);
        this.txnMem.putLong(timestamp);
    }

    @Override
    public void close() {
        long maxTxnInFile;
        if (this.txnMem.isOpen() && (maxTxnInFile = this.txnMem.getLong(4L)) != this.maxTxn.get()) {
            LOG.info().$("Max txn in the file ").$(maxTxnInFile).$(" but in memory is ").$(this.maxTxn.get()).$();
        }
        this.txnMem.close(false);
    }

    @Override
    public void create(Path path, long tableCreateTimestamp) {
        int pathLength = path.size();
        TableUtils.openSmallFile(this.ff, path, pathLength, this.txnMem, "_txnlog", 13);
        this.txnMem.jumpTo(0L);
        this.txnMem.putInt(0);
        this.txnMem.putLong(0L);
        this.txnMem.putLong(tableCreateTimestamp);
        this.txnMem.putInt(0);
        this.sync0();
        this.txnMem.jumpTo(76L);
    }

    @Override
    public long endMetadataChangeEntry() {
        long nextTxn = this.maxTxn.incrementAndGet();
        this.txnMem.putLong(4L, nextTxn);
        return nextTxn;
    }

    @Override
    public void fullSync() {
        this.txnMem.sync(false);
    }

    @Override
    public TransactionLogCursor getCursor(long txnLo, Path path) {
        TransactionLogCursorImpl cursor = tlTransactionLogCursor.get();
        if (cursor == null) {
            cursor = new TransactionLogCursorImpl(this.ff, txnLo, path);
            tlTransactionLogCursor.set(cursor);
            return cursor;
        }
        try {
            return cursor.of(this.ff, txnLo, path);
        }
        catch (Throwable th) {
            cursor.close();
            throw th;
        }
    }

    @Override
    public boolean isDropped() {
        long lastTxn = this.maxTxn.get();
        if (lastTxn > 0L) {
            return -2 == this.txnMem.getInt(76L + (lastTxn - 1L) * RECORD_SIZE + 8L);
        }
        return false;
    }

    @Override
    public long lastTxn() {
        return this.maxTxn.get();
    }

    @Override
    public long open(Path path) {
        if (!this.txnMem.isOpen()) {
            this.txnMem.close(false);
            TableUtils.openSmallFile(this.ff, path, path.size(), this.txnMem, "_txnlog", 13);
        }
        long lastTxn = this.txnMem.getLong(4L);
        this.maxTxn.set(lastTxn);
        this.txnMem.jumpTo(76L);
        long maxStructureVersion = this.txnMem.getLong(76L + (lastTxn - 1L) * RECORD_SIZE + 0L);
        this.txnMem.jumpTo(76L + lastTxn * RECORD_SIZE);
        return maxStructureVersion;
    }

    private void sync0() {
        int commitMode = this.configuration.getCommitMode();
        if (commitMode != 2) {
            this.txnMem.sync(commitMode == 0);
        }
    }

    private static class TransactionLogCursorImpl
    implements TransactionLogCursor {
        private long address;
        private long fd;
        private FilesFacade ff;
        private long txn;
        private long txnCount = -1L;
        private long txnLo;
        private long txnOffset;

        public TransactionLogCursorImpl(FilesFacade ff, long txnLo, Path path) {
            try {
                this.of(ff, txnLo, path);
            }
            catch (Throwable th) {
                this.close();
                throw th;
            }
        }

        @Override
        public void close() {
            if (this.fd > 0L) {
                this.ff.close(this.fd);
                this.fd = 0L;
            }
            if (this.txnCount > -1L && this.address > 0L) {
                this.ff.munmap(this.address, this.getMappedLen(), 14);
                this.txnCount = 0L;
                this.address = 0L;
            }
        }

        @Override
        public boolean extend() {
            long newTxnCount = this.ff.readNonNegativeLong(this.fd, 4L);
            if (newTxnCount > this.txnCount) {
                this.remap(newTxnCount);
                this.txnLo = this.txn - 1L;
                this.txnOffset -= RECORD_SIZE;
                return true;
            }
            return false;
        }

        @Override
        public long getCommitTimestamp() {
            return Unsafe.getUnsafe().getLong(this.address + this.txnOffset + 20L);
        }

        @Override
        public long getMaxTxn() {
            return this.txnCount;
        }

        @Override
        public int getPartitionSize() {
            return 0;
        }

        @Override
        public int getSegmentId() {
            return Unsafe.getUnsafe().getInt(this.address + this.txnOffset + 12L);
        }

        @Override
        public int getSegmentTxn() {
            return Unsafe.getUnsafe().getInt(this.address + this.txnOffset + 16L);
        }

        @Override
        public long getStructureVersion() {
            return Unsafe.getUnsafe().getLong(this.address + this.txnOffset + 0L);
        }

        @Override
        public long getTxn() {
            return this.txn;
        }

        @Override
        public long getTxnMaxTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTxnMinTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTxnRowCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public int getWalId() {
            return Unsafe.getUnsafe().getInt(this.address + this.txnOffset + 8L);
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext(this.getMappedLen())) {
                return true;
            }
            long newTxnCount = this.ff.readNonNegativeLong(this.fd, 4L);
            if (newTxnCount > this.txnCount) {
                this.remap(newTxnCount);
                return this.hasNext(this.getMappedLen());
            }
            return false;
        }

        @Override
        public void setPosition(long txn) {
            this.txnOffset = 76L + (txn - 1L) * RECORD_SIZE;
            this.txn = txn;
        }

        @Override
        public void toMinTxn() {
            this.toTop();
        }

        @Override
        public void toTop() {
            if (this.txnCount > -1L) {
                this.txnOffset = 76L + (this.txnLo - 1L) * RECORD_SIZE;
                this.txn = this.txnLo;
            }
        }

        private static long openFileRO(FilesFacade ff, Path path) {
            return TableUtils.openRO(ff, path, "_txnlog", LOG);
        }

        private long getMappedLen() {
            return this.txnCount * RECORD_SIZE + 76L;
        }

        private boolean hasNext(long mappedLen) {
            if (this.txnOffset + 2L * RECORD_SIZE <= mappedLen) {
                this.txnOffset += RECORD_SIZE;
                ++this.txn;
                return true;
            }
            return false;
        }

        @NotNull
        private TransactionLogCursorImpl of(FilesFacade ff, long txnLo, Path path) {
            this.ff = ff;
            this.close();
            this.fd = TransactionLogCursorImpl.openFileRO(ff, path);
            long newTxnCount = ff.readNonNegativeLong(this.fd, 4L);
            if (newTxnCount <= -1L) {
                throw CairoException.critical(ff.errno()).put("cannot read sequencer transactions [path=").put(path).put(']');
            }
            this.txnCount = newTxnCount;
            this.address = ff.mmap(this.fd, this.getMappedLen(), 0L, 1, 14);
            this.txnOffset = 76L + (txnLo - 1L) * RECORD_SIZE;
            this.txnLo = txnLo;
            this.txn = txnLo;
            return this;
        }

        private void remap(long newTxnCount) {
            long oldSize = this.getMappedLen();
            this.txnCount = newTxnCount;
            long newSize = this.getMappedLen();
            this.address = this.ff.mremap(this.fd, this.address, oldSize, newSize, 0L, 1, 14);
        }
    }
}

