/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cutlass.http.HttpPostPutProcessor;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.ServerDisconnectException;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;

public class ChunkedContentParser
implements Mutable {
    private long chunkSize = -1L;

    @Override
    public void clear() {
        this.chunkSize = -1L;
    }

    public long handleRecv(long lo, long hi, HttpPostPutProcessor processor) throws PeerIsSlowToReadException, ServerDisconnectException, PeerDisconnectedException {
        while (lo < hi) {
            if (this.chunkSize == 0L || this.chunkSize == -1L ? (lo = this.parseChunkLength(lo, hi, this.chunkSize == -1L)) > -1L && this.chunkSize == 0L : this.chunkSize == -2L) {
                return this.waitTrailingEol(lo, hi);
            }
            if (lo < 0L) {
                return lo;
            }
            long n = Math.min(hi - lo, this.chunkSize);
            processor.onChunk(lo, lo + n);
            this.chunkSize -= n;
            lo += n;
        }
        return hi;
    }

    private static boolean isEol(long lo, long hi) {
        return hi - lo > 1L && Unsafe.getUnsafe().getByte(lo) == 13 && Unsafe.getUnsafe().getByte(lo + 1L) == 10;
    }

    private long parseChunkLength(long lo, long hi, boolean skipEol) {
        long startLo = lo;
        long chunkSize = 0L;
        if (!skipEol) {
            if (!ChunkedContentParser.isEol(lo, hi)) {
                return -startLo;
            }
            lo += 2L;
        }
        while (lo < hi) {
            byte b = Unsafe.getUnsafe().getByte(lo++);
            if (b >= 48 && b <= 57) {
                chunkSize = chunkSize * 16L + (long)(b - 48);
                continue;
            }
            if (b >= 97 && b <= 102) {
                chunkSize = chunkSize * 16L + (long)(b - 97 + 10);
                continue;
            }
            if (b >= 65 && b <= 70) {
                chunkSize = chunkSize * 16L + (long)(b - 65 + 10);
                continue;
            }
            if (b == 13 && hi - lo < 1L) break;
            if (ChunkedContentParser.isEol(lo - 1L, hi) && lo > startLo + 1L) {
                this.chunkSize = chunkSize;
                return lo + 1L;
            }
            this.chunkSize = -2L;
            return Long.MIN_VALUE;
        }
        return -startLo;
    }

    private long waitTrailingEol(long lo, long hi) {
        if (hi - lo == 2L) {
            if (ChunkedContentParser.isEol(lo, hi)) {
                return Long.MAX_VALUE;
            }
            return Long.MIN_VALUE;
        }
        if (hi - lo <= 1L) {
            this.chunkSize = -2L;
            return -lo;
        }
        return Long.MIN_VALUE;
    }
}

