/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.processors.JsonQueryProcessorConfiguration;
import io.questdb.cutlass.http.processors.LineHttpProcessorConfiguration;
import io.questdb.cutlass.http.processors.StaticContentProcessorConfiguration;
import io.questdb.std.ConcurrentCacheConfiguration;
import io.questdb.std.ObjList;

public interface HttpFullFatServerConfiguration
extends HttpServerConfiguration {
    public static final String DEFAULT_PROCESSOR_URL = "*";

    public ConcurrentCacheConfiguration getConcurrentCacheConfiguration();

    default public ObjList<String> getContextPathDefault() {
        return new ObjList<String>(DEFAULT_PROCESSOR_URL);
    }

    default public ObjList<String> getContextPathExec() {
        return new ObjList<String>("/exec");
    }

    default public ObjList<String> getContextPathExport() {
        return new ObjList<String>("/exp");
    }

    default public ObjList<String> getContextPathILP() {
        return new ObjList<String>("/write", "/api/v2/write");
    }

    default public ObjList<String> getContextPathILPPing() {
        return new ObjList<String>("/ping");
    }

    default public ObjList<String> getContextPathImport() {
        return new ObjList<String>("/imp");
    }

    default public ObjList<String> getContextPathSettings() {
        return new ObjList<String>("/settings");
    }

    default public ObjList<String> getContextPathTableStatus() {
        return new ObjList<String>("/chk");
    }

    default public ObjList<String> getContextPathWarnings() {
        return new ObjList<String>("/warnings");
    }

    default public String getContextPathWebConsole() {
        return "";
    }

    public JsonQueryProcessorConfiguration getJsonQueryProcessorConfiguration();

    public LineHttpProcessorConfiguration getLineHttpProcessorConfiguration();

    public String getPassword();

    public StaticContentProcessorConfiguration getStaticContentProcessorConfiguration();

    public String getUsername();

    public boolean isQueryCacheEnabled();

    public boolean isSettingsReadOnly();
}

